/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.TransactionResult;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionResultPair
implements XdrElement {
    private Hash transactionHash;
    private TransactionResult result;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.transactionHash.encode(stream);
        this.result.encode(stream);
    }

    public static TransactionResultPair decode(XdrDataInputStream stream) throws IOException {
        TransactionResultPair decodedTransactionResultPair = new TransactionResultPair();
        decodedTransactionResultPair.transactionHash = Hash.decode(stream);
        decodedTransactionResultPair.result = TransactionResult.decode(stream);
        return decodedTransactionResultPair;
    }

    public static TransactionResultPair fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionResultPair.fromXdrByteArray(bytes);
    }

    public static TransactionResultPair fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionResultPair.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionResultPairBuilder builder() {
        return new TransactionResultPairBuilder();
    }

    @Generated
    public TransactionResultPairBuilder toBuilder() {
        return new TransactionResultPairBuilder().transactionHash(this.transactionHash).result(this.result);
    }

    @Generated
    public Hash getTransactionHash() {
        return this.transactionHash;
    }

    @Generated
    public TransactionResult getResult() {
        return this.result;
    }

    @Generated
    public void setTransactionHash(Hash transactionHash) {
        this.transactionHash = transactionHash;
    }

    @Generated
    public void setResult(TransactionResult result) {
        this.result = result;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionResultPair)) {
            return false;
        }
        TransactionResultPair other = (TransactionResultPair)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Hash this$transactionHash = this.getTransactionHash();
        Hash other$transactionHash = other.getTransactionHash();
        if (this$transactionHash == null ? other$transactionHash != null : !((Object)this$transactionHash).equals(other$transactionHash)) {
            return false;
        }
        TransactionResult this$result = this.getResult();
        TransactionResult other$result = other.getResult();
        return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionResultPair;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Hash $transactionHash = this.getTransactionHash();
        result = result * 59 + ($transactionHash == null ? 43 : ((Object)$transactionHash).hashCode());
        TransactionResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionResultPair(transactionHash=" + this.getTransactionHash() + ", result=" + this.getResult() + ")";
    }

    @Generated
    public TransactionResultPair() {
    }

    @Generated
    public TransactionResultPair(Hash transactionHash, TransactionResult result) {
        this.transactionHash = transactionHash;
        this.result = result;
    }

    @Generated
    public static class TransactionResultPairBuilder {
        @Generated
        private Hash transactionHash;
        @Generated
        private TransactionResult result;

        @Generated
        TransactionResultPairBuilder() {
        }

        @Generated
        public TransactionResultPairBuilder transactionHash(Hash transactionHash) {
            this.transactionHash = transactionHash;
            return this;
        }

        @Generated
        public TransactionResultPairBuilder result(TransactionResult result) {
            this.result = result;
            return this;
        }

        @Generated
        public TransactionResultPair build() {
            return new TransactionResultPair(this.transactionHash, this.result);
        }

        @Generated
        public String toString() {
            return "TransactionResultPair.TransactionResultPairBuilder(transactionHash=" + this.transactionHash + ", result=" + this.result + ")";
        }
    }
}

