// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;

/**
 * AssetType's original definition in the XDR file is:
 *
 * <pre>
 * enum AssetType
 * {
 *     ASSET_TYPE_NATIVE = 0,
 *     ASSET_TYPE_CREDIT_ALPHANUM4 = 1,
 *     ASSET_TYPE_CREDIT_ALPHANUM12 = 2,
 *     ASSET_TYPE_POOL_SHARE = 3
 * };
 * </pre>
 */
public enum AssetType implements XdrElement {
  ASSET_TYPE_NATIVE(0),
  ASSET_TYPE_CREDIT_ALPHANUM4(1),
  ASSET_TYPE_CREDIT_ALPHANUM12(2),
  ASSET_TYPE_POOL_SHARE(3);

  private final int value;

  AssetType(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static AssetType decode(XdrDataInputStream stream) throws IOException {
    int value = stream.readInt();
    switch (value) {
      case 0:
        return ASSET_TYPE_NATIVE;
      case 1:
        return ASSET_TYPE_CREDIT_ALPHANUM4;
      case 2:
        return ASSET_TYPE_CREDIT_ALPHANUM12;
      case 3:
        return ASSET_TYPE_POOL_SHARE;
      default:
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(value);
  }

  public static AssetType fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static AssetType fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
