// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ClaimOfferAtom's original definition in the XDR file is:
 *
 * <pre>
 * struct ClaimOfferAtom
 * {
 *     // emitted to identify the offer
 *     AccountID sellerID; // Account that owns the offer
 *     int64 offerID;
 *
 *     // amount and asset taken from the owner
 *     Asset assetSold;
 *     int64 amountSold;
 *
 *     // amount and asset sent to the owner
 *     Asset assetBought;
 *     int64 amountBought;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ClaimOfferAtom implements XdrElement {
  private AccountID sellerID;
  private Int64 offerID;
  private Asset assetSold;
  private Int64 amountSold;
  private Asset assetBought;
  private Int64 amountBought;

  public void encode(XdrDataOutputStream stream) throws IOException {
    sellerID.encode(stream);
    offerID.encode(stream);
    assetSold.encode(stream);
    amountSold.encode(stream);
    assetBought.encode(stream);
    amountBought.encode(stream);
  }

  public static ClaimOfferAtom decode(XdrDataInputStream stream) throws IOException {
    ClaimOfferAtom decodedClaimOfferAtom = new ClaimOfferAtom();
    decodedClaimOfferAtom.sellerID = AccountID.decode(stream);
    decodedClaimOfferAtom.offerID = Int64.decode(stream);
    decodedClaimOfferAtom.assetSold = Asset.decode(stream);
    decodedClaimOfferAtom.amountSold = Int64.decode(stream);
    decodedClaimOfferAtom.assetBought = Asset.decode(stream);
    decodedClaimOfferAtom.amountBought = Int64.decode(stream);
    return decodedClaimOfferAtom;
  }

  public static ClaimOfferAtom fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ClaimOfferAtom fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
