// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ConfigSettingContractComputeV0's original definition in the XDR file is:
 *
 * <pre>
 * struct ConfigSettingContractComputeV0
 * {
 *     // Maximum instructions per ledger
 *     int64 ledgerMaxInstructions;
 *     // Maximum instructions per transaction
 *     int64 txMaxInstructions;
 *     // Cost of 10000 instructions
 *     int64 feeRatePerInstructionsIncrement;
 *
 *     // Memory limit per transaction. Unlike instructions, there is no fee
 *     // for memory, just the limit.
 *     uint32 txMemoryLimit;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ConfigSettingContractComputeV0 implements XdrElement {
  private Int64 ledgerMaxInstructions;
  private Int64 txMaxInstructions;
  private Int64 feeRatePerInstructionsIncrement;
  private Uint32 txMemoryLimit;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ledgerMaxInstructions.encode(stream);
    txMaxInstructions.encode(stream);
    feeRatePerInstructionsIncrement.encode(stream);
    txMemoryLimit.encode(stream);
  }

  public static ConfigSettingContractComputeV0 decode(XdrDataInputStream stream)
      throws IOException {
    ConfigSettingContractComputeV0 decodedConfigSettingContractComputeV0 =
        new ConfigSettingContractComputeV0();
    decodedConfigSettingContractComputeV0.ledgerMaxInstructions = Int64.decode(stream);
    decodedConfigSettingContractComputeV0.txMaxInstructions = Int64.decode(stream);
    decodedConfigSettingContractComputeV0.feeRatePerInstructionsIncrement = Int64.decode(stream);
    decodedConfigSettingContractComputeV0.txMemoryLimit = Uint32.decode(stream);
    return decodedConfigSettingContractComputeV0;
  }

  public static ConfigSettingContractComputeV0 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ConfigSettingContractComputeV0 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
