// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * CreateAccountResult's original definition in the XDR file is:
 *
 * <pre>
 * union CreateAccountResult switch (CreateAccountResultCode code)
 * {
 * case CREATE_ACCOUNT_SUCCESS:
 *     void;
 * case CREATE_ACCOUNT_MALFORMED:
 * case CREATE_ACCOUNT_UNDERFUNDED:
 * case CREATE_ACCOUNT_LOW_RESERVE:
 * case CREATE_ACCOUNT_ALREADY_EXIST:
 *     void;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class CreateAccountResult implements XdrElement {
  private CreateAccountResultCode discriminant;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case CREATE_ACCOUNT_SUCCESS:
        break;
      case CREATE_ACCOUNT_MALFORMED:
      case CREATE_ACCOUNT_UNDERFUNDED:
      case CREATE_ACCOUNT_LOW_RESERVE:
      case CREATE_ACCOUNT_ALREADY_EXIST:
        break;
    }
  }

  public static CreateAccountResult decode(XdrDataInputStream stream) throws IOException {
    CreateAccountResult decodedCreateAccountResult = new CreateAccountResult();
    CreateAccountResultCode discriminant = CreateAccountResultCode.decode(stream);
    decodedCreateAccountResult.setDiscriminant(discriminant);
    switch (decodedCreateAccountResult.getDiscriminant()) {
      case CREATE_ACCOUNT_SUCCESS:
        break;
      case CREATE_ACCOUNT_MALFORMED:
      case CREATE_ACCOUNT_UNDERFUNDED:
      case CREATE_ACCOUNT_LOW_RESERVE:
      case CREATE_ACCOUNT_ALREADY_EXIST:
        break;
    }
    return decodedCreateAccountResult;
  }

  public static CreateAccountResult fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static CreateAccountResult fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
