// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * FeeBumpTransaction's original definition in the XDR file is:
 *
 * <pre>
 * struct FeeBumpTransaction
 * {
 *     MuxedAccount feeSource;
 *     int64 fee;
 *     union switch (EnvelopeType type)
 *     {
 *     case ENVELOPE_TYPE_TX:
 *         TransactionV1Envelope v1;
 *     }
 *     innerTx;
 *     union switch (int v)
 *     {
 *     case 0:
 *         void;
 *     }
 *     ext;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class FeeBumpTransaction implements XdrElement {
  private MuxedAccount feeSource;
  private Int64 fee;
  private FeeBumpTransactionInnerTx innerTx;
  private FeeBumpTransactionExt ext;

  public void encode(XdrDataOutputStream stream) throws IOException {
    feeSource.encode(stream);
    fee.encode(stream);
    innerTx.encode(stream);
    ext.encode(stream);
  }

  public static FeeBumpTransaction decode(XdrDataInputStream stream) throws IOException {
    FeeBumpTransaction decodedFeeBumpTransaction = new FeeBumpTransaction();
    decodedFeeBumpTransaction.feeSource = MuxedAccount.decode(stream);
    decodedFeeBumpTransaction.fee = Int64.decode(stream);
    decodedFeeBumpTransaction.innerTx = FeeBumpTransactionInnerTx.decode(stream);
    decodedFeeBumpTransaction.ext = FeeBumpTransactionExt.decode(stream);
    return decodedFeeBumpTransaction;
  }

  public static FeeBumpTransaction fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static FeeBumpTransaction fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * FeeBumpTransactionInnerTx's original definition in the XDR file is:
   *
   * <pre>
   * union switch (EnvelopeType type)
   *     {
   *     case ENVELOPE_TYPE_TX:
   *         TransactionV1Envelope v1;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class FeeBumpTransactionInnerTx implements XdrElement {
    private EnvelopeType discriminant;
    private TransactionV1Envelope v1;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant.getValue());
      switch (discriminant) {
        case ENVELOPE_TYPE_TX:
          v1.encode(stream);
          break;
      }
    }

    public static FeeBumpTransactionInnerTx decode(XdrDataInputStream stream) throws IOException {
      FeeBumpTransactionInnerTx decodedFeeBumpTransactionInnerTx = new FeeBumpTransactionInnerTx();
      EnvelopeType discriminant = EnvelopeType.decode(stream);
      decodedFeeBumpTransactionInnerTx.setDiscriminant(discriminant);
      switch (decodedFeeBumpTransactionInnerTx.getDiscriminant()) {
        case ENVELOPE_TYPE_TX:
          decodedFeeBumpTransactionInnerTx.v1 = TransactionV1Envelope.decode(stream);
          break;
      }
      return decodedFeeBumpTransactionInnerTx;
    }

    public static FeeBumpTransactionInnerTx fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static FeeBumpTransactionInnerTx fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  /**
   * FeeBumpTransactionExt's original definition in the XDR file is:
   *
   * <pre>
   * union switch (int v)
   *     {
   *     case 0:
   *         void;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class FeeBumpTransactionExt implements XdrElement {
    private Integer discriminant;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant);
      switch (discriminant) {
        case 0:
          break;
      }
    }

    public static FeeBumpTransactionExt decode(XdrDataInputStream stream) throws IOException {
      FeeBumpTransactionExt decodedFeeBumpTransactionExt = new FeeBumpTransactionExt();
      Integer discriminant = stream.readInt();
      decodedFeeBumpTransactionExt.setDiscriminant(discriminant);
      switch (decodedFeeBumpTransactionExt.getDiscriminant()) {
        case 0:
          break;
      }
      return decodedFeeBumpTransactionExt;
    }

    public static FeeBumpTransactionExt fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static FeeBumpTransactionExt fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
