// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * InvokeHostFunctionResult's original definition in the XDR file is:
 *
 * <pre>
 * union InvokeHostFunctionResult switch (InvokeHostFunctionResultCode code)
 * {
 * case INVOKE_HOST_FUNCTION_SUCCESS:
 *     Hash success; // sha256(InvokeHostFunctionSuccessPreImage)
 * case INVOKE_HOST_FUNCTION_MALFORMED:
 * case INVOKE_HOST_FUNCTION_TRAPPED:
 * case INVOKE_HOST_FUNCTION_RESOURCE_LIMIT_EXCEEDED:
 * case INVOKE_HOST_FUNCTION_ENTRY_ARCHIVED:
 * case INVOKE_HOST_FUNCTION_INSUFFICIENT_REFUNDABLE_FEE:
 *     void;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class InvokeHostFunctionResult implements XdrElement {
  private InvokeHostFunctionResultCode discriminant;
  private Hash success;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case INVOKE_HOST_FUNCTION_SUCCESS:
        success.encode(stream);
        break;
      case INVOKE_HOST_FUNCTION_MALFORMED:
      case INVOKE_HOST_FUNCTION_TRAPPED:
      case INVOKE_HOST_FUNCTION_RESOURCE_LIMIT_EXCEEDED:
      case INVOKE_HOST_FUNCTION_ENTRY_ARCHIVED:
      case INVOKE_HOST_FUNCTION_INSUFFICIENT_REFUNDABLE_FEE:
        break;
    }
  }

  public static InvokeHostFunctionResult decode(XdrDataInputStream stream) throws IOException {
    InvokeHostFunctionResult decodedInvokeHostFunctionResult = new InvokeHostFunctionResult();
    InvokeHostFunctionResultCode discriminant = InvokeHostFunctionResultCode.decode(stream);
    decodedInvokeHostFunctionResult.setDiscriminant(discriminant);
    switch (decodedInvokeHostFunctionResult.getDiscriminant()) {
      case INVOKE_HOST_FUNCTION_SUCCESS:
        decodedInvokeHostFunctionResult.success = Hash.decode(stream);
        break;
      case INVOKE_HOST_FUNCTION_MALFORMED:
      case INVOKE_HOST_FUNCTION_TRAPPED:
      case INVOKE_HOST_FUNCTION_RESOURCE_LIMIT_EXCEEDED:
      case INVOKE_HOST_FUNCTION_ENTRY_ARCHIVED:
      case INVOKE_HOST_FUNCTION_INSUFFICIENT_REFUNDABLE_FEE:
        break;
    }
    return decodedInvokeHostFunctionResult;
  }

  public static InvokeHostFunctionResult fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static InvokeHostFunctionResult fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
