// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ManageSellOfferOp's original definition in the XDR file is:
 *
 * <pre>
 * struct ManageSellOfferOp
 * {
 *     Asset selling;
 *     Asset buying;
 *     int64 amount; // amount being sold. if set to 0, delete the offer
 *     Price price;  // price of thing being sold in terms of what you are buying
 *
 *     // 0=create a new offer, otherwise edit an existing offer
 *     int64 offerID;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ManageSellOfferOp implements XdrElement {
  private Asset selling;
  private Asset buying;
  private Int64 amount;
  private Price price;
  private Int64 offerID;

  public void encode(XdrDataOutputStream stream) throws IOException {
    selling.encode(stream);
    buying.encode(stream);
    amount.encode(stream);
    price.encode(stream);
    offerID.encode(stream);
  }

  public static ManageSellOfferOp decode(XdrDataInputStream stream) throws IOException {
    ManageSellOfferOp decodedManageSellOfferOp = new ManageSellOfferOp();
    decodedManageSellOfferOp.selling = Asset.decode(stream);
    decodedManageSellOfferOp.buying = Asset.decode(stream);
    decodedManageSellOfferOp.amount = Int64.decode(stream);
    decodedManageSellOfferOp.price = Price.decode(stream);
    decodedManageSellOfferOp.offerID = Int64.decode(stream);
    return decodedManageSellOfferOp;
  }

  public static ManageSellOfferOp fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ManageSellOfferOp fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
