// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * PersistedSCPStateV1's original definition in the XDR file is:
 *
 * <pre>
 * struct PersistedSCPStateV1
 * {
 * 	// Tx sets are saved separately
 * 	SCPEnvelope scpEnvelopes&lt;&gt;;
 * 	SCPQuorumSet quorumSets&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class PersistedSCPStateV1 implements XdrElement {
  private SCPEnvelope[] scpEnvelopes;
  private SCPQuorumSet[] quorumSets;

  public void encode(XdrDataOutputStream stream) throws IOException {
    int scpEnvelopesSize = getScpEnvelopes().length;
    stream.writeInt(scpEnvelopesSize);
    for (int i = 0; i < scpEnvelopesSize; i++) {
      scpEnvelopes[i].encode(stream);
    }
    int quorumSetsSize = getQuorumSets().length;
    stream.writeInt(quorumSetsSize);
    for (int i = 0; i < quorumSetsSize; i++) {
      quorumSets[i].encode(stream);
    }
  }

  public static PersistedSCPStateV1 decode(XdrDataInputStream stream) throws IOException {
    PersistedSCPStateV1 decodedPersistedSCPStateV1 = new PersistedSCPStateV1();
    int scpEnvelopesSize = stream.readInt();
    decodedPersistedSCPStateV1.scpEnvelopes = new SCPEnvelope[scpEnvelopesSize];
    for (int i = 0; i < scpEnvelopesSize; i++) {
      decodedPersistedSCPStateV1.scpEnvelopes[i] = SCPEnvelope.decode(stream);
    }
    int quorumSetsSize = stream.readInt();
    decodedPersistedSCPStateV1.quorumSets = new SCPQuorumSet[quorumSetsSize];
    for (int i = 0; i < quorumSetsSize; i++) {
      decodedPersistedSCPStateV1.quorumSets[i] = SCPQuorumSet.decode(stream);
    }
    return decodedPersistedSCPStateV1;
  }

  public static PersistedSCPStateV1 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static PersistedSCPStateV1 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
