// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCError's original definition in the XDR file is:
 *
 * <pre>
 * union SCError switch (SCErrorType type)
 * {
 * case SCE_CONTRACT:
 *     uint32 contractCode;
 * case SCE_WASM_VM:
 * case SCE_CONTEXT:
 * case SCE_STORAGE:
 * case SCE_OBJECT:
 * case SCE_CRYPTO:
 * case SCE_EVENTS:
 * case SCE_BUDGET:
 * case SCE_VALUE:
 * case SCE_AUTH:
 *     SCErrorCode code;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCError implements XdrElement {
  private SCErrorType discriminant;
  private Uint32 contractCode;
  private SCErrorCode code;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case SCE_CONTRACT:
        contractCode.encode(stream);
        break;
      case SCE_WASM_VM:
      case SCE_CONTEXT:
      case SCE_STORAGE:
      case SCE_OBJECT:
      case SCE_CRYPTO:
      case SCE_EVENTS:
      case SCE_BUDGET:
      case SCE_VALUE:
      case SCE_AUTH:
        code.encode(stream);
        break;
    }
  }

  public static SCError decode(XdrDataInputStream stream) throws IOException {
    SCError decodedSCError = new SCError();
    SCErrorType discriminant = SCErrorType.decode(stream);
    decodedSCError.setDiscriminant(discriminant);
    switch (decodedSCError.getDiscriminant()) {
      case SCE_CONTRACT:
        decodedSCError.contractCode = Uint32.decode(stream);
        break;
      case SCE_WASM_VM:
      case SCE_CONTEXT:
      case SCE_STORAGE:
      case SCE_OBJECT:
      case SCE_CRYPTO:
      case SCE_EVENTS:
      case SCE_BUDGET:
      case SCE_VALUE:
      case SCE_AUTH:
        decodedSCError.code = SCErrorCode.decode(stream);
        break;
    }
    return decodedSCError;
  }

  public static SCError fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCError fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
