// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCVal's original definition in the XDR file is:
 *
 * <pre>
 * union SCVal switch (SCValType type)
 * {
 *
 * case SCV_BOOL:
 *     bool b;
 * case SCV_VOID:
 *     void;
 * case SCV_ERROR:
 *     SCError error;
 *
 * case SCV_U32:
 *     uint32 u32;
 * case SCV_I32:
 *     int32 i32;
 *
 * case SCV_U64:
 *     uint64 u64;
 * case SCV_I64:
 *     int64 i64;
 * case SCV_TIMEPOINT:
 *     TimePoint timepoint;
 * case SCV_DURATION:
 *     Duration duration;
 *
 * case SCV_U128:
 *     UInt128Parts u128;
 * case SCV_I128:
 *     Int128Parts i128;
 *
 * case SCV_U256:
 *     UInt256Parts u256;
 * case SCV_I256:
 *     Int256Parts i256;
 *
 * case SCV_BYTES:
 *     SCBytes bytes;
 * case SCV_STRING:
 *     SCString str;
 * case SCV_SYMBOL:
 *     SCSymbol sym;
 *
 * // Vec and Map are recursive so need to live
 * // behind an option, due to xdrpp limitations.
 * case SCV_VEC:
 *     SCVec &#42;vec;
 * case SCV_MAP:
 *     SCMap &#42;map;
 *
 * case SCV_ADDRESS:
 *     SCAddress address;
 *
 * // Special SCVals reserved for system-constructed contract-data
 * // ledger keys, not generally usable elsewhere.
 * case SCV_LEDGER_KEY_CONTRACT_INSTANCE:
 *     void;
 * case SCV_LEDGER_KEY_NONCE:
 *     SCNonceKey nonce_key;
 *
 * case SCV_CONTRACT_INSTANCE:
 *     SCContractInstance instance;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCVal implements XdrElement {
  private SCValType discriminant;
  private Boolean b;
  private SCError error;
  private Uint32 u32;
  private Int32 i32;
  private Uint64 u64;
  private Int64 i64;
  private TimePoint timepoint;
  private Duration duration;
  private UInt128Parts u128;
  private Int128Parts i128;
  private UInt256Parts u256;
  private Int256Parts i256;
  private SCBytes bytes;
  private SCString str;
  private SCSymbol sym;
  private SCVec vec;
  private SCMap map;
  private SCAddress address;
  private SCNonceKey nonce_key;
  private SCContractInstance instance;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case SCV_BOOL:
        stream.writeInt(b ? 1 : 0);
        break;
      case SCV_VOID:
        break;
      case SCV_ERROR:
        error.encode(stream);
        break;
      case SCV_U32:
        u32.encode(stream);
        break;
      case SCV_I32:
        i32.encode(stream);
        break;
      case SCV_U64:
        u64.encode(stream);
        break;
      case SCV_I64:
        i64.encode(stream);
        break;
      case SCV_TIMEPOINT:
        timepoint.encode(stream);
        break;
      case SCV_DURATION:
        duration.encode(stream);
        break;
      case SCV_U128:
        u128.encode(stream);
        break;
      case SCV_I128:
        i128.encode(stream);
        break;
      case SCV_U256:
        u256.encode(stream);
        break;
      case SCV_I256:
        i256.encode(stream);
        break;
      case SCV_BYTES:
        bytes.encode(stream);
        break;
      case SCV_STRING:
        str.encode(stream);
        break;
      case SCV_SYMBOL:
        sym.encode(stream);
        break;
      case SCV_VEC:
        if (vec != null) {
          stream.writeInt(1);
          vec.encode(stream);
        } else {
          stream.writeInt(0);
        }
        break;
      case SCV_MAP:
        if (map != null) {
          stream.writeInt(1);
          map.encode(stream);
        } else {
          stream.writeInt(0);
        }
        break;
      case SCV_ADDRESS:
        address.encode(stream);
        break;
      case SCV_LEDGER_KEY_CONTRACT_INSTANCE:
        break;
      case SCV_LEDGER_KEY_NONCE:
        nonce_key.encode(stream);
        break;
      case SCV_CONTRACT_INSTANCE:
        instance.encode(stream);
        break;
    }
  }

  public static SCVal decode(XdrDataInputStream stream) throws IOException {
    SCVal decodedSCVal = new SCVal();
    SCValType discriminant = SCValType.decode(stream);
    decodedSCVal.setDiscriminant(discriminant);
    switch (decodedSCVal.getDiscriminant()) {
      case SCV_BOOL:
        decodedSCVal.b = stream.readInt() == 1 ? true : false;
        break;
      case SCV_VOID:
        break;
      case SCV_ERROR:
        decodedSCVal.error = SCError.decode(stream);
        break;
      case SCV_U32:
        decodedSCVal.u32 = Uint32.decode(stream);
        break;
      case SCV_I32:
        decodedSCVal.i32 = Int32.decode(stream);
        break;
      case SCV_U64:
        decodedSCVal.u64 = Uint64.decode(stream);
        break;
      case SCV_I64:
        decodedSCVal.i64 = Int64.decode(stream);
        break;
      case SCV_TIMEPOINT:
        decodedSCVal.timepoint = TimePoint.decode(stream);
        break;
      case SCV_DURATION:
        decodedSCVal.duration = Duration.decode(stream);
        break;
      case SCV_U128:
        decodedSCVal.u128 = UInt128Parts.decode(stream);
        break;
      case SCV_I128:
        decodedSCVal.i128 = Int128Parts.decode(stream);
        break;
      case SCV_U256:
        decodedSCVal.u256 = UInt256Parts.decode(stream);
        break;
      case SCV_I256:
        decodedSCVal.i256 = Int256Parts.decode(stream);
        break;
      case SCV_BYTES:
        decodedSCVal.bytes = SCBytes.decode(stream);
        break;
      case SCV_STRING:
        decodedSCVal.str = SCString.decode(stream);
        break;
      case SCV_SYMBOL:
        decodedSCVal.sym = SCSymbol.decode(stream);
        break;
      case SCV_VEC:
        int vecPresent = stream.readInt();
        if (vecPresent != 0) {
          decodedSCVal.vec = SCVec.decode(stream);
        }
        break;
      case SCV_MAP:
        int mapPresent = stream.readInt();
        if (mapPresent != 0) {
          decodedSCVal.map = SCMap.decode(stream);
        }
        break;
      case SCV_ADDRESS:
        decodedSCVal.address = SCAddress.decode(stream);
        break;
      case SCV_LEDGER_KEY_CONTRACT_INSTANCE:
        break;
      case SCV_LEDGER_KEY_NONCE:
        decodedSCVal.nonce_key = SCNonceKey.decode(stream);
        break;
      case SCV_CONTRACT_INSTANCE:
        decodedSCVal.instance = SCContractInstance.decode(stream);
        break;
    }
    return decodedSCVal;
  }

  public static SCVal fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCVal fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
