/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import lombok.Generated;
import org.stellar.sdk.Address;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.Network;
import org.stellar.sdk.Util;
import org.stellar.sdk.exception.UnexpectedException;
import org.stellar.sdk.scval.Scv;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.HashIDPreimage;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.SorobanAddressCredentials;
import org.stellar.sdk.xdr.SorobanAuthorizationEntry;
import org.stellar.sdk.xdr.SorobanAuthorizedInvocation;
import org.stellar.sdk.xdr.SorobanCredentials;
import org.stellar.sdk.xdr.SorobanCredentialsType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrUnsignedInteger;

public class Auth {
    public static SorobanAuthorizationEntry authorizeEntry(String entry, KeyPair signer, Long validUntilLedgerSeq, Network network) {
        SorobanAuthorizationEntry entryXdr;
        try {
            entryXdr = SorobanAuthorizationEntry.fromXdrBase64(entry);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to convert entry to SorobanAuthorizationEntry", e);
        }
        return Auth.authorizeEntry(entryXdr, signer, validUntilLedgerSeq, network);
    }

    public static SorobanAuthorizationEntry authorizeEntry(SorobanAuthorizationEntry entry, KeyPair signer, Long validUntilLedgerSeq, Network network) {
        Signer entrySigner = preimage -> {
            byte[] data;
            try {
                data = preimage.toXdrByteArray();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to convert preimage to bytes", e);
            }
            byte[] payload = Util.hash(data);
            byte[] signature = signer.sign(payload);
            return new Signature(signer.getAccountId(), signature);
        };
        return Auth.authorizeEntry(entry, entrySigner, validUntilLedgerSeq, network);
    }

    public static SorobanAuthorizationEntry authorizeEntry(String entry, Signer signer, Long validUntilLedgerSeq, Network network) {
        SorobanAuthorizationEntry entryXdr;
        try {
            entryXdr = SorobanAuthorizationEntry.fromXdrBase64(entry);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to convert entry to SorobanAuthorizationEntry", e);
        }
        return Auth.authorizeEntry(entryXdr, signer, validUntilLedgerSeq, network);
    }

    public static SorobanAuthorizationEntry authorizeEntry(SorobanAuthorizationEntry entry, Signer signer, Long validUntilLedgerSeq, Network network) {
        byte[] data;
        SorobanAuthorizationEntry clone;
        try {
            clone = SorobanAuthorizationEntry.fromXdrByteArray(entry.toXdrByteArray());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to clone SorobanAuthorizationEntry", e);
        }
        if (clone.getCredentials().getDiscriminant() != SorobanCredentialsType.SOROBAN_CREDENTIALS_ADDRESS) {
            return clone;
        }
        SorobanAddressCredentials addressCredentials = clone.getCredentials().getAddress();
        addressCredentials.setSignatureExpirationLedger(new Uint32(new XdrUnsignedInteger(validUntilLedgerSeq)));
        HashIDPreimage preimage = HashIDPreimage.builder().discriminant(EnvelopeType.ENVELOPE_TYPE_SOROBAN_AUTHORIZATION).sorobanAuthorization(HashIDPreimage.HashIDPreimageSorobanAuthorization.builder().networkID(new Hash(network.getNetworkId())).nonce(addressCredentials.getNonce()).invocation(clone.getRootInvocation()).signatureExpirationLedger(addressCredentials.getSignatureExpirationLedger()).build()).build();
        final Signature signature = signer.sign(preimage);
        try {
            data = preimage.toXdrByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to convert preimage to bytes", e);
        }
        byte[] payload = Util.hash(data);
        final KeyPair kp = KeyPair.fromAccountId(signature.publicKey);
        if (!kp.verify(payload, signature.signature)) {
            throw new IllegalArgumentException("signature does not match payload");
        }
        SCVal sigScVal = Scv.toMap(new LinkedHashMap<SCVal, SCVal>(){
            {
                this.put(Scv.toSymbol("public_key"), Scv.toBytes(kp.getPublicKey()));
                this.put(Scv.toSymbol("signature"), Scv.toBytes(signature.getSignature()));
            }
        });
        addressCredentials.setSignature(Scv.toVec(Collections.singleton(sigScVal)));
        return clone;
    }

    public static SorobanAuthorizationEntry authorizeInvocation(KeyPair signer, Long validUntilLedgerSeq, SorobanAuthorizedInvocation invocation, Network network) {
        Signer entrySigner = preimage -> {
            try {
                byte[] payload = Util.hash(preimage.toXdrByteArray());
                byte[] signature = signer.sign(payload);
                return new Signature(signer.getAccountId(), signature);
            }
            catch (IOException e) {
                throw new UnexpectedException(e);
            }
        };
        return Auth.authorizeInvocation(entrySigner, signer.getAccountId(), validUntilLedgerSeq, invocation, network);
    }

    public static SorobanAuthorizationEntry authorizeInvocation(Signer signer, String publicKey, Long validUntilLedgerSeq, SorobanAuthorizedInvocation invocation, Network network) {
        long nonce = new SecureRandom().nextLong();
        SorobanAuthorizationEntry entry = SorobanAuthorizationEntry.builder().credentials(SorobanCredentials.builder().discriminant(SorobanCredentialsType.SOROBAN_CREDENTIALS_ADDRESS).address(SorobanAddressCredentials.builder().address(new Address(publicKey).toSCAddress()).nonce(new Int64(nonce)).signatureExpirationLedger(new Uint32(new XdrUnsignedInteger(validUntilLedgerSeq))).signature(Scv.toVoid()).build()).build()).rootInvocation(invocation).build();
        return Auth.authorizeEntry(entry, signer, validUntilLedgerSeq, network);
    }

    public static interface Signer {
        public Signature sign(HashIDPreimage var1);
    }

    public static final class Signature {
        private final String publicKey;
        private final byte[] signature;

        @Generated
        public Signature(String publicKey, byte[] signature) {
            this.publicKey = publicKey;
            this.signature = signature;
        }

        @Generated
        public String getPublicKey() {
            return this.publicKey;
        }

        @Generated
        public byte[] getSignature() {
            return this.signature;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Signature)) {
                return false;
            }
            Signature other = (Signature)o;
            String this$publicKey = this.getPublicKey();
            String other$publicKey = other.getPublicKey();
            if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
                return false;
            }
            return Arrays.equals(this.getSignature(), other.getSignature());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $publicKey = this.getPublicKey();
            result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
            result = result * 59 + Arrays.hashCode(this.getSignature());
            return result;
        }

        @Generated
        public String toString() {
            return "Auth.Signature(publicKey=" + this.getPublicKey() + ", signature=" + Arrays.toString(this.getSignature()) + ")";
        }
    }
}

