/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import com.google.gson.reflect.TypeToken;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.stellar.sdk.requests.EventListener;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.SSEStream;
import org.stellar.sdk.responses.LedgerResponse;
import org.stellar.sdk.responses.Page;

public class LedgersRequestBuilder
extends RequestBuilder {
    public LedgersRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "ledgers");
    }

    public LedgerResponse ledger(HttpUrl uri) {
        TypeToken<LedgerResponse> type = new TypeToken<LedgerResponse>(){};
        return LedgersRequestBuilder.executeGetRequest(this.httpClient, uri, type);
    }

    public LedgerResponse ledger(long ledgerSeq) {
        this.setSegments("ledgers", String.valueOf(ledgerSeq));
        return this.ledger(this.buildUri());
    }

    public static Page<LedgerResponse> execute(OkHttpClient httpClient, HttpUrl uri) {
        TypeToken<Page<LedgerResponse>> type = new TypeToken<Page<LedgerResponse>>(){};
        return LedgersRequestBuilder.executeGetRequest(httpClient, uri, type);
    }

    public SSEStream<LedgerResponse> stream(EventListener<LedgerResponse> listener, long reconnectTimeout) {
        return SSEStream.create(this.httpClient, this, LedgerResponse.class, listener, reconnectTimeout);
    }

    public SSEStream<LedgerResponse> stream(EventListener<LedgerResponse> listener) {
        return this.stream(listener, 15000L);
    }

    public Page<LedgerResponse> execute() {
        return LedgersRequestBuilder.execute(this.httpClient, this.buildUri());
    }

    @Override
    public LedgersRequestBuilder cursor(String token) {
        super.cursor(token);
        return this;
    }

    @Override
    public LedgersRequestBuilder limit(int number) {
        super.limit(number);
        return this;
    }

    @Override
    public LedgersRequestBuilder order(RequestBuilder.Order direction) {
        super.order(direction);
        return this;
    }
}

