/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.TransactionBuilderAccount;
import org.stellar.sdk.TrustLineAsset;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Response;

public class AccountResponse
extends Response
implements TransactionBuilderAccount {
    @SerializedName(value="id")
    private String id;
    @SerializedName(value="account_id")
    private String accountId;
    @SerializedName(value="sequence")
    private Long sequenceNumber;
    @SerializedName(value="sequence_ledger")
    private Long sequenceLedger;
    @SerializedName(value="sequence_time")
    private Long sequenceTime;
    @SerializedName(value="subentry_count")
    private Integer subentryCount;
    @SerializedName(value="inflation_destination")
    private String inflationDestination;
    @SerializedName(value="home_domain")
    private String homeDomain;
    @SerializedName(value="last_modified_ledger")
    private Integer lastModifiedLedger;
    @SerializedName(value="last_modified_time")
    private String lastModifiedTime;
    @SerializedName(value="thresholds")
    private Thresholds thresholds;
    @SerializedName(value="flags")
    private Flags flags;
    @SerializedName(value="balances")
    private List<Balance> balances;
    @SerializedName(value="signers")
    private List<Signer> signers;
    @SerializedName(value="data")
    private Data data;
    @SerializedName(value="num_sponsoring")
    private Integer numSponsoring;
    @SerializedName(value="num_sponsored")
    private Integer numSponsored;
    @SerializedName(value="sponsor")
    private String sponsor;
    @SerializedName(value="paging_token")
    private String pagingToken;
    @SerializedName(value="_links")
    private Links links;

    @Override
    public String getAccountId() {
        return this.accountId;
    }

    @Override
    public KeyPair getKeyPair() {
        return KeyPair.fromAccountId(this.accountId);
    }

    @Override
    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public void setSequenceNumber(long seqNum) {
        this.sequenceNumber = seqNum;
    }

    @Override
    public Long getIncrementedSequenceNumber() {
        return this.sequenceNumber + 1L;
    }

    @Override
    public void incrementSequenceNumber() {
        Long l = this.sequenceNumber;
        this.sequenceNumber = this.sequenceNumber + 1L;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Long getSequenceLedger() {
        return this.sequenceLedger;
    }

    @Generated
    public Long getSequenceTime() {
        return this.sequenceTime;
    }

    @Generated
    public Integer getSubentryCount() {
        return this.subentryCount;
    }

    @Generated
    public String getInflationDestination() {
        return this.inflationDestination;
    }

    @Generated
    public String getHomeDomain() {
        return this.homeDomain;
    }

    @Generated
    public Integer getLastModifiedLedger() {
        return this.lastModifiedLedger;
    }

    @Generated
    public String getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Generated
    public Thresholds getThresholds() {
        return this.thresholds;
    }

    @Generated
    public Flags getFlags() {
        return this.flags;
    }

    @Generated
    public List<Balance> getBalances() {
        return this.balances;
    }

    @Generated
    public List<Signer> getSigners() {
        return this.signers;
    }

    @Generated
    public Data getData() {
        return this.data;
    }

    @Generated
    public Integer getNumSponsoring() {
        return this.numSponsoring;
    }

    @Generated
    public Integer getNumSponsored() {
        return this.numSponsored;
    }

    @Generated
    public String getSponsor() {
        return this.sponsor;
    }

    @Generated
    public String getPagingToken() {
        return this.pagingToken;
    }

    @Generated
    public Links getLinks() {
        return this.links;
    }

    @Generated
    public String toString() {
        return "AccountResponse(id=" + this.getId() + ", accountId=" + this.getAccountId() + ", sequenceNumber=" + this.getSequenceNumber() + ", sequenceLedger=" + this.getSequenceLedger() + ", sequenceTime=" + this.getSequenceTime() + ", subentryCount=" + this.getSubentryCount() + ", inflationDestination=" + this.getInflationDestination() + ", homeDomain=" + this.getHomeDomain() + ", lastModifiedLedger=" + this.getLastModifiedLedger() + ", lastModifiedTime=" + this.getLastModifiedTime() + ", thresholds=" + this.getThresholds() + ", flags=" + this.getFlags() + ", balances=" + this.getBalances() + ", signers=" + this.getSigners() + ", data=" + this.getData() + ", numSponsoring=" + this.getNumSponsoring() + ", numSponsored=" + this.getNumSponsored() + ", sponsor=" + this.getSponsor() + ", pagingToken=" + this.getPagingToken() + ", links=" + this.getLinks() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountResponse)) {
            return false;
        }
        AccountResponse other = (AccountResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$sequenceNumber = this.getSequenceNumber();
        Long other$sequenceNumber = other.getSequenceNumber();
        if (this$sequenceNumber == null ? other$sequenceNumber != null : !((Object)this$sequenceNumber).equals(other$sequenceNumber)) {
            return false;
        }
        Long this$sequenceLedger = this.getSequenceLedger();
        Long other$sequenceLedger = other.getSequenceLedger();
        if (this$sequenceLedger == null ? other$sequenceLedger != null : !((Object)this$sequenceLedger).equals(other$sequenceLedger)) {
            return false;
        }
        Long this$sequenceTime = this.getSequenceTime();
        Long other$sequenceTime = other.getSequenceTime();
        if (this$sequenceTime == null ? other$sequenceTime != null : !((Object)this$sequenceTime).equals(other$sequenceTime)) {
            return false;
        }
        Integer this$subentryCount = this.getSubentryCount();
        Integer other$subentryCount = other.getSubentryCount();
        if (this$subentryCount == null ? other$subentryCount != null : !((Object)this$subentryCount).equals(other$subentryCount)) {
            return false;
        }
        Integer this$lastModifiedLedger = this.getLastModifiedLedger();
        Integer other$lastModifiedLedger = other.getLastModifiedLedger();
        if (this$lastModifiedLedger == null ? other$lastModifiedLedger != null : !((Object)this$lastModifiedLedger).equals(other$lastModifiedLedger)) {
            return false;
        }
        Integer this$numSponsoring = this.getNumSponsoring();
        Integer other$numSponsoring = other.getNumSponsoring();
        if (this$numSponsoring == null ? other$numSponsoring != null : !((Object)this$numSponsoring).equals(other$numSponsoring)) {
            return false;
        }
        Integer this$numSponsored = this.getNumSponsored();
        Integer other$numSponsored = other.getNumSponsored();
        if (this$numSponsored == null ? other$numSponsored != null : !((Object)this$numSponsored).equals(other$numSponsored)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        String this$inflationDestination = this.getInflationDestination();
        String other$inflationDestination = other.getInflationDestination();
        if (this$inflationDestination == null ? other$inflationDestination != null : !this$inflationDestination.equals(other$inflationDestination)) {
            return false;
        }
        String this$homeDomain = this.getHomeDomain();
        String other$homeDomain = other.getHomeDomain();
        if (this$homeDomain == null ? other$homeDomain != null : !this$homeDomain.equals(other$homeDomain)) {
            return false;
        }
        String this$lastModifiedTime = this.getLastModifiedTime();
        String other$lastModifiedTime = other.getLastModifiedTime();
        if (this$lastModifiedTime == null ? other$lastModifiedTime != null : !this$lastModifiedTime.equals(other$lastModifiedTime)) {
            return false;
        }
        Thresholds this$thresholds = this.getThresholds();
        Thresholds other$thresholds = other.getThresholds();
        if (this$thresholds == null ? other$thresholds != null : !((Object)this$thresholds).equals(other$thresholds)) {
            return false;
        }
        Flags this$flags = this.getFlags();
        Flags other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        List<Balance> this$balances = this.getBalances();
        List<Balance> other$balances = other.getBalances();
        if (this$balances == null ? other$balances != null : !((Object)this$balances).equals(other$balances)) {
            return false;
        }
        List<Signer> this$signers = this.getSigners();
        List<Signer> other$signers = other.getSigners();
        if (this$signers == null ? other$signers != null : !((Object)this$signers).equals(other$signers)) {
            return false;
        }
        Data this$data = this.getData();
        Data other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$sponsor = this.getSponsor();
        String other$sponsor = other.getSponsor();
        if (this$sponsor == null ? other$sponsor != null : !this$sponsor.equals(other$sponsor)) {
            return false;
        }
        String this$pagingToken = this.getPagingToken();
        String other$pagingToken = other.getPagingToken();
        if (this$pagingToken == null ? other$pagingToken != null : !this$pagingToken.equals(other$pagingToken)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccountResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + ($sequenceNumber == null ? 43 : ((Object)$sequenceNumber).hashCode());
        Long $sequenceLedger = this.getSequenceLedger();
        result = result * 59 + ($sequenceLedger == null ? 43 : ((Object)$sequenceLedger).hashCode());
        Long $sequenceTime = this.getSequenceTime();
        result = result * 59 + ($sequenceTime == null ? 43 : ((Object)$sequenceTime).hashCode());
        Integer $subentryCount = this.getSubentryCount();
        result = result * 59 + ($subentryCount == null ? 43 : ((Object)$subentryCount).hashCode());
        Integer $lastModifiedLedger = this.getLastModifiedLedger();
        result = result * 59 + ($lastModifiedLedger == null ? 43 : ((Object)$lastModifiedLedger).hashCode());
        Integer $numSponsoring = this.getNumSponsoring();
        result = result * 59 + ($numSponsoring == null ? 43 : ((Object)$numSponsoring).hashCode());
        Integer $numSponsored = this.getNumSponsored();
        result = result * 59 + ($numSponsored == null ? 43 : ((Object)$numSponsored).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        String $inflationDestination = this.getInflationDestination();
        result = result * 59 + ($inflationDestination == null ? 43 : $inflationDestination.hashCode());
        String $homeDomain = this.getHomeDomain();
        result = result * 59 + ($homeDomain == null ? 43 : $homeDomain.hashCode());
        String $lastModifiedTime = this.getLastModifiedTime();
        result = result * 59 + ($lastModifiedTime == null ? 43 : $lastModifiedTime.hashCode());
        Thresholds $thresholds = this.getThresholds();
        result = result * 59 + ($thresholds == null ? 43 : ((Object)$thresholds).hashCode());
        Flags $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        List<Balance> $balances = this.getBalances();
        result = result * 59 + ($balances == null ? 43 : ((Object)$balances).hashCode());
        List<Signer> $signers = this.getSigners();
        result = result * 59 + ($signers == null ? 43 : ((Object)$signers).hashCode());
        Data $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $sponsor = this.getSponsor();
        result = result * 59 + ($sponsor == null ? 43 : $sponsor.hashCode());
        String $pagingToken = this.getPagingToken();
        result = result * 59 + ($pagingToken == null ? 43 : $pagingToken.hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }

    public static final class Thresholds {
        @SerializedName(value="low_threshold")
        private final Integer lowThreshold;
        @SerializedName(value="med_threshold")
        private final Integer medThreshold;
        @SerializedName(value="high_threshold")
        private final Integer highThreshold;

        @Generated
        public Thresholds(Integer lowThreshold, Integer medThreshold, Integer highThreshold) {
            this.lowThreshold = lowThreshold;
            this.medThreshold = medThreshold;
            this.highThreshold = highThreshold;
        }

        @Generated
        public Integer getLowThreshold() {
            return this.lowThreshold;
        }

        @Generated
        public Integer getMedThreshold() {
            return this.medThreshold;
        }

        @Generated
        public Integer getHighThreshold() {
            return this.highThreshold;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Thresholds)) {
                return false;
            }
            Thresholds other = (Thresholds)o;
            Integer this$lowThreshold = this.getLowThreshold();
            Integer other$lowThreshold = other.getLowThreshold();
            if (this$lowThreshold == null ? other$lowThreshold != null : !((Object)this$lowThreshold).equals(other$lowThreshold)) {
                return false;
            }
            Integer this$medThreshold = this.getMedThreshold();
            Integer other$medThreshold = other.getMedThreshold();
            if (this$medThreshold == null ? other$medThreshold != null : !((Object)this$medThreshold).equals(other$medThreshold)) {
                return false;
            }
            Integer this$highThreshold = this.getHighThreshold();
            Integer other$highThreshold = other.getHighThreshold();
            return !(this$highThreshold == null ? other$highThreshold != null : !((Object)this$highThreshold).equals(other$highThreshold));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $lowThreshold = this.getLowThreshold();
            result = result * 59 + ($lowThreshold == null ? 43 : ((Object)$lowThreshold).hashCode());
            Integer $medThreshold = this.getMedThreshold();
            result = result * 59 + ($medThreshold == null ? 43 : ((Object)$medThreshold).hashCode());
            Integer $highThreshold = this.getHighThreshold();
            result = result * 59 + ($highThreshold == null ? 43 : ((Object)$highThreshold).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccountResponse.Thresholds(lowThreshold=" + this.getLowThreshold() + ", medThreshold=" + this.getMedThreshold() + ", highThreshold=" + this.getHighThreshold() + ")";
        }
    }

    public static final class Flags {
        @SerializedName(value="auth_required")
        private final Boolean authRequired;
        @SerializedName(value="auth_revocable")
        private final Boolean authRevocable;
        @SerializedName(value="auth_immutable")
        private final Boolean authImmutable;
        @SerializedName(value="auth_clawback_enabled")
        private final Boolean authClawbackEnabled;

        @Generated
        public Flags(Boolean authRequired, Boolean authRevocable, Boolean authImmutable, Boolean authClawbackEnabled) {
            this.authRequired = authRequired;
            this.authRevocable = authRevocable;
            this.authImmutable = authImmutable;
            this.authClawbackEnabled = authClawbackEnabled;
        }

        @Generated
        public Boolean getAuthRequired() {
            return this.authRequired;
        }

        @Generated
        public Boolean getAuthRevocable() {
            return this.authRevocable;
        }

        @Generated
        public Boolean getAuthImmutable() {
            return this.authImmutable;
        }

        @Generated
        public Boolean getAuthClawbackEnabled() {
            return this.authClawbackEnabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Flags)) {
                return false;
            }
            Flags other = (Flags)o;
            Boolean this$authRequired = this.getAuthRequired();
            Boolean other$authRequired = other.getAuthRequired();
            if (this$authRequired == null ? other$authRequired != null : !((Object)this$authRequired).equals(other$authRequired)) {
                return false;
            }
            Boolean this$authRevocable = this.getAuthRevocable();
            Boolean other$authRevocable = other.getAuthRevocable();
            if (this$authRevocable == null ? other$authRevocable != null : !((Object)this$authRevocable).equals(other$authRevocable)) {
                return false;
            }
            Boolean this$authImmutable = this.getAuthImmutable();
            Boolean other$authImmutable = other.getAuthImmutable();
            if (this$authImmutable == null ? other$authImmutable != null : !((Object)this$authImmutable).equals(other$authImmutable)) {
                return false;
            }
            Boolean this$authClawbackEnabled = this.getAuthClawbackEnabled();
            Boolean other$authClawbackEnabled = other.getAuthClawbackEnabled();
            return !(this$authClawbackEnabled == null ? other$authClawbackEnabled != null : !((Object)this$authClawbackEnabled).equals(other$authClawbackEnabled));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $authRequired = this.getAuthRequired();
            result = result * 59 + ($authRequired == null ? 43 : ((Object)$authRequired).hashCode());
            Boolean $authRevocable = this.getAuthRevocable();
            result = result * 59 + ($authRevocable == null ? 43 : ((Object)$authRevocable).hashCode());
            Boolean $authImmutable = this.getAuthImmutable();
            result = result * 59 + ($authImmutable == null ? 43 : ((Object)$authImmutable).hashCode());
            Boolean $authClawbackEnabled = this.getAuthClawbackEnabled();
            result = result * 59 + ($authClawbackEnabled == null ? 43 : ((Object)$authClawbackEnabled).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccountResponse.Flags(authRequired=" + this.getAuthRequired() + ", authRevocable=" + this.getAuthRevocable() + ", authImmutable=" + this.getAuthImmutable() + ", authClawbackEnabled=" + this.getAuthClawbackEnabled() + ")";
        }
    }

    public static class Data
    extends HashMap<String, String> {
        @Override
        public int size() {
            return super.size();
        }

        public String get(String key) {
            return (String)super.get(key);
        }

        public byte[] getDecoded(String key) {
            return Base64Factory.getInstance().decode(this.get(key));
        }
    }

    public static final class Links {
        @SerializedName(value="self")
        private final Link self;
        @SerializedName(value="transactions")
        private final Link transactions;
        @SerializedName(value="operations")
        private final Link operations;
        @SerializedName(value="payments")
        private final Link payments;
        @SerializedName(value="effects")
        private final Link effects;
        @SerializedName(value="offers")
        private final Link offers;
        @SerializedName(value="trades")
        private final Link trades;
        @SerializedName(value="data")
        private final Link data;

        @Generated
        public Links(Link self, Link transactions, Link operations, Link payments, Link effects, Link offers, Link trades, Link data) {
            this.self = self;
            this.transactions = transactions;
            this.operations = operations;
            this.payments = payments;
            this.effects = effects;
            this.offers = offers;
            this.trades = trades;
            this.data = data;
        }

        @Generated
        public Link getSelf() {
            return this.self;
        }

        @Generated
        public Link getTransactions() {
            return this.transactions;
        }

        @Generated
        public Link getOperations() {
            return this.operations;
        }

        @Generated
        public Link getPayments() {
            return this.payments;
        }

        @Generated
        public Link getEffects() {
            return this.effects;
        }

        @Generated
        public Link getOffers() {
            return this.offers;
        }

        @Generated
        public Link getTrades() {
            return this.trades;
        }

        @Generated
        public Link getData() {
            return this.data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Links)) {
                return false;
            }
            Links other = (Links)o;
            Link this$self = this.getSelf();
            Link other$self = other.getSelf();
            if (this$self == null ? other$self != null : !((Object)this$self).equals(other$self)) {
                return false;
            }
            Link this$transactions = this.getTransactions();
            Link other$transactions = other.getTransactions();
            if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
                return false;
            }
            Link this$operations = this.getOperations();
            Link other$operations = other.getOperations();
            if (this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations)) {
                return false;
            }
            Link this$payments = this.getPayments();
            Link other$payments = other.getPayments();
            if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
                return false;
            }
            Link this$effects = this.getEffects();
            Link other$effects = other.getEffects();
            if (this$effects == null ? other$effects != null : !((Object)this$effects).equals(other$effects)) {
                return false;
            }
            Link this$offers = this.getOffers();
            Link other$offers = other.getOffers();
            if (this$offers == null ? other$offers != null : !((Object)this$offers).equals(other$offers)) {
                return false;
            }
            Link this$trades = this.getTrades();
            Link other$trades = other.getTrades();
            if (this$trades == null ? other$trades != null : !((Object)this$trades).equals(other$trades)) {
                return false;
            }
            Link this$data = this.getData();
            Link other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Link $self = this.getSelf();
            result = result * 59 + ($self == null ? 43 : ((Object)$self).hashCode());
            Link $transactions = this.getTransactions();
            result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
            Link $operations = this.getOperations();
            result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
            Link $payments = this.getPayments();
            result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
            Link $effects = this.getEffects();
            result = result * 59 + ($effects == null ? 43 : ((Object)$effects).hashCode());
            Link $offers = this.getOffers();
            result = result * 59 + ($offers == null ? 43 : ((Object)$offers).hashCode());
            Link $trades = this.getTrades();
            result = result * 59 + ($trades == null ? 43 : ((Object)$trades).hashCode());
            Link $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccountResponse.Links(self=" + this.getSelf() + ", transactions=" + this.getTransactions() + ", operations=" + this.getOperations() + ", payments=" + this.getPayments() + ", effects=" + this.getEffects() + ", offers=" + this.getOffers() + ", trades=" + this.getTrades() + ", data=" + this.getData() + ")";
        }
    }

    public static final class Signer {
        @SerializedName(value="key")
        private final String key;
        @SerializedName(value="type")
        private final String type;
        @SerializedName(value="weight")
        private final Integer weight;
        @SerializedName(value="sponsor")
        private final String sponsor;

        @Generated
        public Signer(String key, String type, Integer weight, String sponsor) {
            this.key = key;
            this.type = type;
            this.weight = weight;
            this.sponsor = sponsor;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Integer getWeight() {
            return this.weight;
        }

        @Generated
        public String getSponsor() {
            return this.sponsor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Signer)) {
                return false;
            }
            Signer other = (Signer)o;
            Integer this$weight = this.getWeight();
            Integer other$weight = other.getWeight();
            if (this$weight == null ? other$weight != null : !((Object)this$weight).equals(other$weight)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$sponsor = this.getSponsor();
            String other$sponsor = other.getSponsor();
            return !(this$sponsor == null ? other$sponsor != null : !this$sponsor.equals(other$sponsor));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $weight = this.getWeight();
            result = result * 59 + ($weight == null ? 43 : ((Object)$weight).hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $sponsor = this.getSponsor();
            result = result * 59 + ($sponsor == null ? 43 : $sponsor.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccountResponse.Signer(key=" + this.getKey() + ", type=" + this.getType() + ", weight=" + this.getWeight() + ", sponsor=" + this.getSponsor() + ")";
        }
    }

    public static final class Balance {
        @SerializedName(value="asset_type")
        private final String assetType;
        @SerializedName(value="asset_code")
        private final String assetCode;
        @SerializedName(value="asset_issuer")
        private final String assetIssuer;
        @SerializedName(value="liquidity_pool_id")
        private final String liquidityPoolId;
        @SerializedName(value="limit")
        private final String limit;
        @SerializedName(value="balance")
        private final String balance;
        @SerializedName(value="buying_liabilities")
        private final String buyingLiabilities;
        @SerializedName(value="selling_liabilities")
        private final String sellingLiabilities;
        @SerializedName(value="is_authorized")
        private final Boolean isAuthorized;
        @SerializedName(value="is_authorized_to_maintain_liabilities")
        private final Boolean isAuthorizedToMaintainLiabilities;
        @SerializedName(value="is_clawback_enabled")
        private final Boolean isClawbackEnabled;
        @SerializedName(value="last_modified_ledger")
        private final Integer lastModifiedLedger;
        @SerializedName(value="sponsor")
        private final String sponsor;

        public TrustLineAsset getTrustLineAsset() {
            return Response.getTrustLineAsset(this.assetType, this.assetCode, this.assetIssuer, this.liquidityPoolId);
        }

        @Generated
        public Balance(String assetType, String assetCode, String assetIssuer, String liquidityPoolId, String limit, String balance, String buyingLiabilities, String sellingLiabilities, Boolean isAuthorized, Boolean isAuthorizedToMaintainLiabilities, Boolean isClawbackEnabled, Integer lastModifiedLedger, String sponsor) {
            this.assetType = assetType;
            this.assetCode = assetCode;
            this.assetIssuer = assetIssuer;
            this.liquidityPoolId = liquidityPoolId;
            this.limit = limit;
            this.balance = balance;
            this.buyingLiabilities = buyingLiabilities;
            this.sellingLiabilities = sellingLiabilities;
            this.isAuthorized = isAuthorized;
            this.isAuthorizedToMaintainLiabilities = isAuthorizedToMaintainLiabilities;
            this.isClawbackEnabled = isClawbackEnabled;
            this.lastModifiedLedger = lastModifiedLedger;
            this.sponsor = sponsor;
        }

        @Generated
        public String getAssetType() {
            return this.assetType;
        }

        @Generated
        public String getAssetCode() {
            return this.assetCode;
        }

        @Generated
        public String getAssetIssuer() {
            return this.assetIssuer;
        }

        @Generated
        public String getLiquidityPoolId() {
            return this.liquidityPoolId;
        }

        @Generated
        public String getLimit() {
            return this.limit;
        }

        @Generated
        public String getBalance() {
            return this.balance;
        }

        @Generated
        public String getBuyingLiabilities() {
            return this.buyingLiabilities;
        }

        @Generated
        public String getSellingLiabilities() {
            return this.sellingLiabilities;
        }

        @Generated
        public Boolean getIsAuthorized() {
            return this.isAuthorized;
        }

        @Generated
        public Boolean getIsAuthorizedToMaintainLiabilities() {
            return this.isAuthorizedToMaintainLiabilities;
        }

        @Generated
        public Boolean getIsClawbackEnabled() {
            return this.isClawbackEnabled;
        }

        @Generated
        public Integer getLastModifiedLedger() {
            return this.lastModifiedLedger;
        }

        @Generated
        public String getSponsor() {
            return this.sponsor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Balance)) {
                return false;
            }
            Balance other = (Balance)o;
            Boolean this$isAuthorized = this.getIsAuthorized();
            Boolean other$isAuthorized = other.getIsAuthorized();
            if (this$isAuthorized == null ? other$isAuthorized != null : !((Object)this$isAuthorized).equals(other$isAuthorized)) {
                return false;
            }
            Boolean this$isAuthorizedToMaintainLiabilities = this.getIsAuthorizedToMaintainLiabilities();
            Boolean other$isAuthorizedToMaintainLiabilities = other.getIsAuthorizedToMaintainLiabilities();
            if (this$isAuthorizedToMaintainLiabilities == null ? other$isAuthorizedToMaintainLiabilities != null : !((Object)this$isAuthorizedToMaintainLiabilities).equals(other$isAuthorizedToMaintainLiabilities)) {
                return false;
            }
            Boolean this$isClawbackEnabled = this.getIsClawbackEnabled();
            Boolean other$isClawbackEnabled = other.getIsClawbackEnabled();
            if (this$isClawbackEnabled == null ? other$isClawbackEnabled != null : !((Object)this$isClawbackEnabled).equals(other$isClawbackEnabled)) {
                return false;
            }
            Integer this$lastModifiedLedger = this.getLastModifiedLedger();
            Integer other$lastModifiedLedger = other.getLastModifiedLedger();
            if (this$lastModifiedLedger == null ? other$lastModifiedLedger != null : !((Object)this$lastModifiedLedger).equals(other$lastModifiedLedger)) {
                return false;
            }
            String this$assetType = this.getAssetType();
            String other$assetType = other.getAssetType();
            if (this$assetType == null ? other$assetType != null : !this$assetType.equals(other$assetType)) {
                return false;
            }
            String this$assetCode = this.getAssetCode();
            String other$assetCode = other.getAssetCode();
            if (this$assetCode == null ? other$assetCode != null : !this$assetCode.equals(other$assetCode)) {
                return false;
            }
            String this$assetIssuer = this.getAssetIssuer();
            String other$assetIssuer = other.getAssetIssuer();
            if (this$assetIssuer == null ? other$assetIssuer != null : !this$assetIssuer.equals(other$assetIssuer)) {
                return false;
            }
            String this$liquidityPoolId = this.getLiquidityPoolId();
            String other$liquidityPoolId = other.getLiquidityPoolId();
            if (this$liquidityPoolId == null ? other$liquidityPoolId != null : !this$liquidityPoolId.equals(other$liquidityPoolId)) {
                return false;
            }
            String this$limit = this.getLimit();
            String other$limit = other.getLimit();
            if (this$limit == null ? other$limit != null : !this$limit.equals(other$limit)) {
                return false;
            }
            String this$balance = this.getBalance();
            String other$balance = other.getBalance();
            if (this$balance == null ? other$balance != null : !this$balance.equals(other$balance)) {
                return false;
            }
            String this$buyingLiabilities = this.getBuyingLiabilities();
            String other$buyingLiabilities = other.getBuyingLiabilities();
            if (this$buyingLiabilities == null ? other$buyingLiabilities != null : !this$buyingLiabilities.equals(other$buyingLiabilities)) {
                return false;
            }
            String this$sellingLiabilities = this.getSellingLiabilities();
            String other$sellingLiabilities = other.getSellingLiabilities();
            if (this$sellingLiabilities == null ? other$sellingLiabilities != null : !this$sellingLiabilities.equals(other$sellingLiabilities)) {
                return false;
            }
            String this$sponsor = this.getSponsor();
            String other$sponsor = other.getSponsor();
            return !(this$sponsor == null ? other$sponsor != null : !this$sponsor.equals(other$sponsor));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isAuthorized = this.getIsAuthorized();
            result = result * 59 + ($isAuthorized == null ? 43 : ((Object)$isAuthorized).hashCode());
            Boolean $isAuthorizedToMaintainLiabilities = this.getIsAuthorizedToMaintainLiabilities();
            result = result * 59 + ($isAuthorizedToMaintainLiabilities == null ? 43 : ((Object)$isAuthorizedToMaintainLiabilities).hashCode());
            Boolean $isClawbackEnabled = this.getIsClawbackEnabled();
            result = result * 59 + ($isClawbackEnabled == null ? 43 : ((Object)$isClawbackEnabled).hashCode());
            Integer $lastModifiedLedger = this.getLastModifiedLedger();
            result = result * 59 + ($lastModifiedLedger == null ? 43 : ((Object)$lastModifiedLedger).hashCode());
            String $assetType = this.getAssetType();
            result = result * 59 + ($assetType == null ? 43 : $assetType.hashCode());
            String $assetCode = this.getAssetCode();
            result = result * 59 + ($assetCode == null ? 43 : $assetCode.hashCode());
            String $assetIssuer = this.getAssetIssuer();
            result = result * 59 + ($assetIssuer == null ? 43 : $assetIssuer.hashCode());
            String $liquidityPoolId = this.getLiquidityPoolId();
            result = result * 59 + ($liquidityPoolId == null ? 43 : $liquidityPoolId.hashCode());
            String $limit = this.getLimit();
            result = result * 59 + ($limit == null ? 43 : $limit.hashCode());
            String $balance = this.getBalance();
            result = result * 59 + ($balance == null ? 43 : $balance.hashCode());
            String $buyingLiabilities = this.getBuyingLiabilities();
            result = result * 59 + ($buyingLiabilities == null ? 43 : $buyingLiabilities.hashCode());
            String $sellingLiabilities = this.getSellingLiabilities();
            result = result * 59 + ($sellingLiabilities == null ? 43 : $sellingLiabilities.hashCode());
            String $sponsor = this.getSponsor();
            result = result * 59 + ($sponsor == null ? 43 : $sponsor.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccountResponse.Balance(assetType=" + this.getAssetType() + ", assetCode=" + this.getAssetCode() + ", assetIssuer=" + this.getAssetIssuer() + ", liquidityPoolId=" + this.getLiquidityPoolId() + ", limit=" + this.getLimit() + ", balance=" + this.getBalance() + ", buyingLiabilities=" + this.getBuyingLiabilities() + ", sellingLiabilities=" + this.getSellingLiabilities() + ", isAuthorized=" + this.getIsAuthorized() + ", isAuthorizedToMaintainLiabilities=" + this.getIsAuthorizedToMaintainLiabilities() + ", isClawbackEnabled=" + this.getIsClawbackEnabled() + ", lastModifiedLedger=" + this.getLastModifiedLedger() + ", sponsor=" + this.getSponsor() + ")";
        }
    }
}

