/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum AccountMergeResultCode implements XdrElement
{
    ACCOUNT_MERGE_SUCCESS(0),
    ACCOUNT_MERGE_MALFORMED(-1),
    ACCOUNT_MERGE_NO_ACCOUNT(-2),
    ACCOUNT_MERGE_IMMUTABLE_SET(-3),
    ACCOUNT_MERGE_HAS_SUB_ENTRIES(-4),
    ACCOUNT_MERGE_SEQNUM_TOO_FAR(-5),
    ACCOUNT_MERGE_DEST_FULL(-6),
    ACCOUNT_MERGE_IS_SPONSOR(-7);

    private final int value;

    private AccountMergeResultCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AccountMergeResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return ACCOUNT_MERGE_SUCCESS;
            }
            case -1: {
                return ACCOUNT_MERGE_MALFORMED;
            }
            case -2: {
                return ACCOUNT_MERGE_NO_ACCOUNT;
            }
            case -3: {
                return ACCOUNT_MERGE_IMMUTABLE_SET;
            }
            case -4: {
                return ACCOUNT_MERGE_HAS_SUB_ENTRIES;
            }
            case -5: {
                return ACCOUNT_MERGE_SEQNUM_TOO_FAR;
            }
            case -6: {
                return ACCOUNT_MERGE_DEST_FULL;
            }
            case -7: {
                return ACCOUNT_MERGE_IS_SPONSOR;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static AccountMergeResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AccountMergeResultCode.fromXdrByteArray(bytes);
    }

    public static AccountMergeResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AccountMergeResultCode.decode(xdrDataInputStream);
    }
}

