/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AssetCode12;
import org.stellar.sdk.xdr.AssetCode4;
import org.stellar.sdk.xdr.AssetType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AssetCode
implements XdrElement {
    private AssetType discriminant;
    private AssetCode4 assetCode4;
    private AssetCode12 assetCode12;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                this.assetCode4.encode(stream);
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                this.assetCode12.encode(stream);
            }
        }
    }

    public static AssetCode decode(XdrDataInputStream stream) throws IOException {
        AssetCode decodedAssetCode = new AssetCode();
        AssetType discriminant = AssetType.decode(stream);
        decodedAssetCode.setDiscriminant(discriminant);
        switch (decodedAssetCode.getDiscriminant()) {
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                decodedAssetCode.assetCode4 = AssetCode4.decode(stream);
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                decodedAssetCode.assetCode12 = AssetCode12.decode(stream);
            }
        }
        return decodedAssetCode;
    }

    public static AssetCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AssetCode.fromXdrByteArray(bytes);
    }

    public static AssetCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AssetCode.decode(xdrDataInputStream);
    }

    @Generated
    public static AssetCodeBuilder builder() {
        return new AssetCodeBuilder();
    }

    @Generated
    public AssetCodeBuilder toBuilder() {
        return new AssetCodeBuilder().discriminant(this.discriminant).assetCode4(this.assetCode4).assetCode12(this.assetCode12);
    }

    @Generated
    public AssetType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public AssetCode4 getAssetCode4() {
        return this.assetCode4;
    }

    @Generated
    public AssetCode12 getAssetCode12() {
        return this.assetCode12;
    }

    @Generated
    public void setDiscriminant(AssetType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setAssetCode4(AssetCode4 assetCode4) {
        this.assetCode4 = assetCode4;
    }

    @Generated
    public void setAssetCode12(AssetCode12 assetCode12) {
        this.assetCode12 = assetCode12;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetCode)) {
            return false;
        }
        AssetCode other = (AssetCode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AssetType this$discriminant = this.getDiscriminant();
        AssetType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        AssetCode4 this$assetCode4 = this.getAssetCode4();
        AssetCode4 other$assetCode4 = other.getAssetCode4();
        if (this$assetCode4 == null ? other$assetCode4 != null : !((Object)this$assetCode4).equals(other$assetCode4)) {
            return false;
        }
        AssetCode12 this$assetCode12 = this.getAssetCode12();
        AssetCode12 other$assetCode12 = other.getAssetCode12();
        return !(this$assetCode12 == null ? other$assetCode12 != null : !((Object)this$assetCode12).equals(other$assetCode12));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssetCode;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AssetType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        AssetCode4 $assetCode4 = this.getAssetCode4();
        result = result * 59 + ($assetCode4 == null ? 43 : ((Object)$assetCode4).hashCode());
        AssetCode12 $assetCode12 = this.getAssetCode12();
        result = result * 59 + ($assetCode12 == null ? 43 : ((Object)$assetCode12).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssetCode(discriminant=" + this.getDiscriminant() + ", assetCode4=" + this.getAssetCode4() + ", assetCode12=" + this.getAssetCode12() + ")";
    }

    @Generated
    public AssetCode() {
    }

    @Generated
    public AssetCode(AssetType discriminant, AssetCode4 assetCode4, AssetCode12 assetCode12) {
        this.discriminant = discriminant;
        this.assetCode4 = assetCode4;
        this.assetCode12 = assetCode12;
    }

    @Generated
    public static class AssetCodeBuilder {
        @Generated
        private AssetType discriminant;
        @Generated
        private AssetCode4 assetCode4;
        @Generated
        private AssetCode12 assetCode12;

        @Generated
        AssetCodeBuilder() {
        }

        @Generated
        public AssetCodeBuilder discriminant(AssetType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public AssetCodeBuilder assetCode4(AssetCode4 assetCode4) {
            this.assetCode4 = assetCode4;
            return this;
        }

        @Generated
        public AssetCodeBuilder assetCode12(AssetCode12 assetCode12) {
            this.assetCode12 = assetCode12;
            return this;
        }

        @Generated
        public AssetCode build() {
            return new AssetCode(this.discriminant, this.assetCode4, this.assetCode12);
        }

        @Generated
        public String toString() {
            return "AssetCode.AssetCodeBuilder(discriminant=" + this.discriminant + ", assetCode4=" + this.assetCode4 + ", assetCode12=" + this.assetCode12 + ")";
        }
    }
}

