/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ClaimPredicateType implements XdrElement
{
    CLAIM_PREDICATE_UNCONDITIONAL(0),
    CLAIM_PREDICATE_AND(1),
    CLAIM_PREDICATE_OR(2),
    CLAIM_PREDICATE_NOT(3),
    CLAIM_PREDICATE_BEFORE_ABSOLUTE_TIME(4),
    CLAIM_PREDICATE_BEFORE_RELATIVE_TIME(5);

    private final int value;

    private ClaimPredicateType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ClaimPredicateType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return CLAIM_PREDICATE_UNCONDITIONAL;
            }
            case 1: {
                return CLAIM_PREDICATE_AND;
            }
            case 2: {
                return CLAIM_PREDICATE_OR;
            }
            case 3: {
                return CLAIM_PREDICATE_NOT;
            }
            case 4: {
                return CLAIM_PREDICATE_BEFORE_ABSOLUTE_TIME;
            }
            case 5: {
                return CLAIM_PREDICATE_BEFORE_RELATIVE_TIME;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static ClaimPredicateType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ClaimPredicateType.fromXdrByteArray(bytes);
    }

    public static ClaimPredicateType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ClaimPredicateType.decode(xdrDataInputStream);
    }
}

