/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerFootprint
implements XdrElement {
    private LedgerKey[] readOnly;
    private LedgerKey[] readWrite;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        int readOnlySize = this.getReadOnly().length;
        stream.writeInt(readOnlySize);
        for (int i = 0; i < readOnlySize; ++i) {
            this.readOnly[i].encode(stream);
        }
        int readWriteSize = this.getReadWrite().length;
        stream.writeInt(readWriteSize);
        for (int i = 0; i < readWriteSize; ++i) {
            this.readWrite[i].encode(stream);
        }
    }

    public static LedgerFootprint decode(XdrDataInputStream stream) throws IOException {
        LedgerFootprint decodedLedgerFootprint = new LedgerFootprint();
        int readOnlySize = stream.readInt();
        decodedLedgerFootprint.readOnly = new LedgerKey[readOnlySize];
        for (int i = 0; i < readOnlySize; ++i) {
            decodedLedgerFootprint.readOnly[i] = LedgerKey.decode(stream);
        }
        int readWriteSize = stream.readInt();
        decodedLedgerFootprint.readWrite = new LedgerKey[readWriteSize];
        for (int i = 0; i < readWriteSize; ++i) {
            decodedLedgerFootprint.readWrite[i] = LedgerKey.decode(stream);
        }
        return decodedLedgerFootprint;
    }

    public static LedgerFootprint fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerFootprint.fromXdrByteArray(bytes);
    }

    public static LedgerFootprint fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerFootprint.decode(xdrDataInputStream);
    }

    @Generated
    public static LedgerFootprintBuilder builder() {
        return new LedgerFootprintBuilder();
    }

    @Generated
    public LedgerFootprintBuilder toBuilder() {
        return new LedgerFootprintBuilder().readOnly(this.readOnly).readWrite(this.readWrite);
    }

    @Generated
    public LedgerKey[] getReadOnly() {
        return this.readOnly;
    }

    @Generated
    public LedgerKey[] getReadWrite() {
        return this.readWrite;
    }

    @Generated
    public void setReadOnly(LedgerKey[] readOnly) {
        this.readOnly = readOnly;
    }

    @Generated
    public void setReadWrite(LedgerKey[] readWrite) {
        this.readWrite = readWrite;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerFootprint)) {
            return false;
        }
        LedgerFootprint other = (LedgerFootprint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getReadOnly(), other.getReadOnly())) {
            return false;
        }
        return Arrays.deepEquals(this.getReadWrite(), other.getReadWrite());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LedgerFootprint;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getReadOnly());
        result = result * 59 + Arrays.deepHashCode(this.getReadWrite());
        return result;
    }

    @Generated
    public String toString() {
        return "LedgerFootprint(readOnly=" + Arrays.deepToString(this.getReadOnly()) + ", readWrite=" + Arrays.deepToString(this.getReadWrite()) + ")";
    }

    @Generated
    public LedgerFootprint() {
    }

    @Generated
    public LedgerFootprint(LedgerKey[] readOnly, LedgerKey[] readWrite) {
        this.readOnly = readOnly;
        this.readWrite = readWrite;
    }

    @Generated
    public static class LedgerFootprintBuilder {
        @Generated
        private LedgerKey[] readOnly;
        @Generated
        private LedgerKey[] readWrite;

        @Generated
        LedgerFootprintBuilder() {
        }

        @Generated
        public LedgerFootprintBuilder readOnly(LedgerKey[] readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        @Generated
        public LedgerFootprintBuilder readWrite(LedgerKey[] readWrite) {
            this.readWrite = readWrite;
            return this;
        }

        @Generated
        public LedgerFootprint build() {
            return new LedgerFootprint(this.readOnly, this.readWrite);
        }

        @Generated
        public String toString() {
            return "LedgerFootprint.LedgerFootprintBuilder(readOnly=" + Arrays.deepToString(this.readOnly) + ", readWrite=" + Arrays.deepToString(this.readWrite) + ")";
        }
    }
}

