/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ThresholdIndexes implements XdrElement
{
    THRESHOLD_MASTER_WEIGHT(0),
    THRESHOLD_LOW(1),
    THRESHOLD_MED(2),
    THRESHOLD_HIGH(3);

    private final int value;

    private ThresholdIndexes(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ThresholdIndexes decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return THRESHOLD_MASTER_WEIGHT;
            }
            case 1: {
                return THRESHOLD_LOW;
            }
            case 2: {
                return THRESHOLD_MED;
            }
            case 3: {
                return THRESHOLD_HIGH;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static ThresholdIndexes fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ThresholdIndexes.fromXdrByteArray(bytes);
    }

    public static ThresholdIndexes fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ThresholdIndexes.decode(xdrDataInputStream);
    }
}

