/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.DecoratedSignature;
import org.stellar.sdk.xdr.Transaction;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionV1Envelope
implements XdrElement {
    private Transaction tx;
    private DecoratedSignature[] signatures;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.tx.encode(stream);
        int signaturesSize = this.getSignatures().length;
        stream.writeInt(signaturesSize);
        for (int i = 0; i < signaturesSize; ++i) {
            this.signatures[i].encode(stream);
        }
    }

    public static TransactionV1Envelope decode(XdrDataInputStream stream) throws IOException {
        TransactionV1Envelope decodedTransactionV1Envelope = new TransactionV1Envelope();
        decodedTransactionV1Envelope.tx = Transaction.decode(stream);
        int signaturesSize = stream.readInt();
        decodedTransactionV1Envelope.signatures = new DecoratedSignature[signaturesSize];
        for (int i = 0; i < signaturesSize; ++i) {
            decodedTransactionV1Envelope.signatures[i] = DecoratedSignature.decode(stream);
        }
        return decodedTransactionV1Envelope;
    }

    public static TransactionV1Envelope fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionV1Envelope.fromXdrByteArray(bytes);
    }

    public static TransactionV1Envelope fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionV1Envelope.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionV1EnvelopeBuilder builder() {
        return new TransactionV1EnvelopeBuilder();
    }

    @Generated
    public TransactionV1EnvelopeBuilder toBuilder() {
        return new TransactionV1EnvelopeBuilder().tx(this.tx).signatures(this.signatures);
    }

    @Generated
    public Transaction getTx() {
        return this.tx;
    }

    @Generated
    public DecoratedSignature[] getSignatures() {
        return this.signatures;
    }

    @Generated
    public void setTx(Transaction tx) {
        this.tx = tx;
    }

    @Generated
    public void setSignatures(DecoratedSignature[] signatures) {
        this.signatures = signatures;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionV1Envelope)) {
            return false;
        }
        TransactionV1Envelope other = (TransactionV1Envelope)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Transaction this$tx = this.getTx();
        Transaction other$tx = other.getTx();
        if (this$tx == null ? other$tx != null : !((Object)this$tx).equals(other$tx)) {
            return false;
        }
        return Arrays.deepEquals(this.getSignatures(), other.getSignatures());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionV1Envelope;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Transaction $tx = this.getTx();
        result = result * 59 + ($tx == null ? 43 : ((Object)$tx).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSignatures());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionV1Envelope(tx=" + this.getTx() + ", signatures=" + Arrays.deepToString(this.getSignatures()) + ")";
    }

    @Generated
    public TransactionV1Envelope() {
    }

    @Generated
    public TransactionV1Envelope(Transaction tx, DecoratedSignature[] signatures) {
        this.tx = tx;
        this.signatures = signatures;
    }

    @Generated
    public static class TransactionV1EnvelopeBuilder {
        @Generated
        private Transaction tx;
        @Generated
        private DecoratedSignature[] signatures;

        @Generated
        TransactionV1EnvelopeBuilder() {
        }

        @Generated
        public TransactionV1EnvelopeBuilder tx(Transaction tx) {
            this.tx = tx;
            return this;
        }

        @Generated
        public TransactionV1EnvelopeBuilder signatures(DecoratedSignature[] signatures) {
            this.signatures = signatures;
            return this;
        }

        @Generated
        public TransactionV1Envelope build() {
            return new TransactionV1Envelope(this.tx, this.signatures);
        }

        @Generated
        public String toString() {
            return "TransactionV1Envelope.TransactionV1EnvelopeBuilder(tx=" + this.tx + ", signatures=" + Arrays.deepToString(this.signatures) + ")";
        }
    }
}

