/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Memo;
import org.stellar.sdk.Util;

abstract class MemoHashAbstract
extends Memo {
    protected byte @NonNull [] bytes;

    public MemoHashAbstract(byte @NonNull [] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (bytes.length != 32) {
            throw new IllegalArgumentException("bytes must be 32-bytes long.");
        }
        this.bytes = bytes;
    }

    public MemoHashAbstract(String hexString) {
        this(Util.hexToBytes(hexString.toLowerCase()));
    }

    public String getHexValue() {
        return Util.bytesToHex(this.bytes).toLowerCase();
    }

    @Override
    abstract org.stellar.sdk.xdr.Memo toXdr();

    public String toString() {
        return this.getHexValue();
    }

    @Generated
    public byte @NonNull [] getBytes() {
        return this.bytes;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemoHashAbstract)) {
            return false;
        }
        MemoHashAbstract other = (MemoHashAbstract)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getBytes(), other.getBytes());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MemoHashAbstract;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getBytes());
        return result;
    }
}

