/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ConfigUpgradeSetKey
implements XdrElement {
    private Hash contractID;
    private Hash contentHash;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.contractID.encode(stream);
        this.contentHash.encode(stream);
    }

    public static ConfigUpgradeSetKey decode(XdrDataInputStream stream) throws IOException {
        ConfigUpgradeSetKey decodedConfigUpgradeSetKey = new ConfigUpgradeSetKey();
        decodedConfigUpgradeSetKey.contractID = Hash.decode(stream);
        decodedConfigUpgradeSetKey.contentHash = Hash.decode(stream);
        return decodedConfigUpgradeSetKey;
    }

    public static ConfigUpgradeSetKey fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ConfigUpgradeSetKey.fromXdrByteArray(bytes);
    }

    public static ConfigUpgradeSetKey fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ConfigUpgradeSetKey.decode(xdrDataInputStream);
    }

    @Generated
    public static ConfigUpgradeSetKeyBuilder builder() {
        return new ConfigUpgradeSetKeyBuilder();
    }

    @Generated
    public ConfigUpgradeSetKeyBuilder toBuilder() {
        return new ConfigUpgradeSetKeyBuilder().contractID(this.contractID).contentHash(this.contentHash);
    }

    @Generated
    public Hash getContractID() {
        return this.contractID;
    }

    @Generated
    public Hash getContentHash() {
        return this.contentHash;
    }

    @Generated
    public void setContractID(Hash contractID) {
        this.contractID = contractID;
    }

    @Generated
    public void setContentHash(Hash contentHash) {
        this.contentHash = contentHash;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigUpgradeSetKey)) {
            return false;
        }
        ConfigUpgradeSetKey other = (ConfigUpgradeSetKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Hash this$contractID = this.getContractID();
        Hash other$contractID = other.getContractID();
        if (this$contractID == null ? other$contractID != null : !((Object)this$contractID).equals(other$contractID)) {
            return false;
        }
        Hash this$contentHash = this.getContentHash();
        Hash other$contentHash = other.getContentHash();
        return !(this$contentHash == null ? other$contentHash != null : !((Object)this$contentHash).equals(other$contentHash));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConfigUpgradeSetKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Hash $contractID = this.getContractID();
        result = result * 59 + ($contractID == null ? 43 : ((Object)$contractID).hashCode());
        Hash $contentHash = this.getContentHash();
        result = result * 59 + ($contentHash == null ? 43 : ((Object)$contentHash).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ConfigUpgradeSetKey(contractID=" + this.getContractID() + ", contentHash=" + this.getContentHash() + ")";
    }

    @Generated
    public ConfigUpgradeSetKey() {
    }

    @Generated
    public ConfigUpgradeSetKey(Hash contractID, Hash contentHash) {
        this.contractID = contractID;
        this.contentHash = contentHash;
    }

    @Generated
    public static class ConfigUpgradeSetKeyBuilder {
        @Generated
        private Hash contractID;
        @Generated
        private Hash contentHash;

        @Generated
        ConfigUpgradeSetKeyBuilder() {
        }

        @Generated
        public ConfigUpgradeSetKeyBuilder contractID(Hash contractID) {
            this.contractID = contractID;
            return this;
        }

        @Generated
        public ConfigUpgradeSetKeyBuilder contentHash(Hash contentHash) {
            this.contentHash = contentHash;
            return this;
        }

        @Generated
        public ConfigUpgradeSetKey build() {
            return new ConfigUpgradeSetKey(this.contractID, this.contentHash);
        }

        @Generated
        public String toString() {
            return "ConfigUpgradeSetKey.ConfigUpgradeSetKeyBuilder(contractID=" + this.contractID + ", contentHash=" + this.contentHash + ")";
        }
    }
}

