/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ContractEvent;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class DiagnosticEvent
implements XdrElement {
    private Boolean inSuccessfulContractCall;
    private ContractEvent event;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.inSuccessfulContractCall != false ? 1 : 0);
        this.event.encode(stream);
    }

    public static DiagnosticEvent decode(XdrDataInputStream stream) throws IOException {
        DiagnosticEvent decodedDiagnosticEvent = new DiagnosticEvent();
        decodedDiagnosticEvent.inSuccessfulContractCall = stream.readInt() == 1;
        decodedDiagnosticEvent.event = ContractEvent.decode(stream);
        return decodedDiagnosticEvent;
    }

    public static DiagnosticEvent fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return DiagnosticEvent.fromXdrByteArray(bytes);
    }

    public static DiagnosticEvent fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return DiagnosticEvent.decode(xdrDataInputStream);
    }

    @Generated
    public static DiagnosticEventBuilder builder() {
        return new DiagnosticEventBuilder();
    }

    @Generated
    public DiagnosticEventBuilder toBuilder() {
        return new DiagnosticEventBuilder().inSuccessfulContractCall(this.inSuccessfulContractCall).event(this.event);
    }

    @Generated
    public Boolean getInSuccessfulContractCall() {
        return this.inSuccessfulContractCall;
    }

    @Generated
    public ContractEvent getEvent() {
        return this.event;
    }

    @Generated
    public void setInSuccessfulContractCall(Boolean inSuccessfulContractCall) {
        this.inSuccessfulContractCall = inSuccessfulContractCall;
    }

    @Generated
    public void setEvent(ContractEvent event) {
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiagnosticEvent)) {
            return false;
        }
        DiagnosticEvent other = (DiagnosticEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$inSuccessfulContractCall = this.getInSuccessfulContractCall();
        Boolean other$inSuccessfulContractCall = other.getInSuccessfulContractCall();
        if (this$inSuccessfulContractCall == null ? other$inSuccessfulContractCall != null : !((Object)this$inSuccessfulContractCall).equals(other$inSuccessfulContractCall)) {
            return false;
        }
        ContractEvent this$event = this.getEvent();
        ContractEvent other$event = other.getEvent();
        return !(this$event == null ? other$event != null : !((Object)this$event).equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DiagnosticEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $inSuccessfulContractCall = this.getInSuccessfulContractCall();
        result = result * 59 + ($inSuccessfulContractCall == null ? 43 : ((Object)$inSuccessfulContractCall).hashCode());
        ContractEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : ((Object)$event).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DiagnosticEvent(inSuccessfulContractCall=" + this.getInSuccessfulContractCall() + ", event=" + this.getEvent() + ")";
    }

    @Generated
    public DiagnosticEvent() {
    }

    @Generated
    public DiagnosticEvent(Boolean inSuccessfulContractCall, ContractEvent event) {
        this.inSuccessfulContractCall = inSuccessfulContractCall;
        this.event = event;
    }

    @Generated
    public static class DiagnosticEventBuilder {
        @Generated
        private Boolean inSuccessfulContractCall;
        @Generated
        private ContractEvent event;

        @Generated
        DiagnosticEventBuilder() {
        }

        @Generated
        public DiagnosticEventBuilder inSuccessfulContractCall(Boolean inSuccessfulContractCall) {
            this.inSuccessfulContractCall = inSuccessfulContractCall;
            return this;
        }

        @Generated
        public DiagnosticEventBuilder event(ContractEvent event) {
            this.event = event;
            return this;
        }

        @Generated
        public DiagnosticEvent build() {
            return new DiagnosticEvent(this.inSuccessfulContractCall, this.event);
        }

        @Generated
        public String toString() {
            return "DiagnosticEvent.DiagnosticEventBuilder(inSuccessfulContractCall=" + this.inSuccessfulContractCall + ", event=" + this.event + ")";
        }
    }
}

