/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum InflationResultCode implements XdrElement
{
    INFLATION_SUCCESS(0),
    INFLATION_NOT_TIME(-1);

    private final int value;

    private InflationResultCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static InflationResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return INFLATION_SUCCESS;
            }
            case -1: {
                return INFLATION_NOT_TIME;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static InflationResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return InflationResultCode.fromXdrByteArray(bytes);
    }

    public static InflationResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return InflationResultCode.decode(xdrDataInputStream);
    }
}

