/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.DataValue;
import org.stellar.sdk.xdr.String64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ManageDataOp
implements XdrElement {
    private String64 dataName;
    private DataValue dataValue;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.dataName.encode(stream);
        if (this.dataValue != null) {
            stream.writeInt(1);
            this.dataValue.encode(stream);
        } else {
            stream.writeInt(0);
        }
    }

    public static ManageDataOp decode(XdrDataInputStream stream) throws IOException {
        ManageDataOp decodedManageDataOp = new ManageDataOp();
        decodedManageDataOp.dataName = String64.decode(stream);
        int dataValuePresent = stream.readInt();
        if (dataValuePresent != 0) {
            decodedManageDataOp.dataValue = DataValue.decode(stream);
        }
        return decodedManageDataOp;
    }

    public static ManageDataOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ManageDataOp.fromXdrByteArray(bytes);
    }

    public static ManageDataOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ManageDataOp.decode(xdrDataInputStream);
    }

    @Generated
    public static ManageDataOpBuilder builder() {
        return new ManageDataOpBuilder();
    }

    @Generated
    public ManageDataOpBuilder toBuilder() {
        return new ManageDataOpBuilder().dataName(this.dataName).dataValue(this.dataValue);
    }

    @Generated
    public String64 getDataName() {
        return this.dataName;
    }

    @Generated
    public DataValue getDataValue() {
        return this.dataValue;
    }

    @Generated
    public void setDataName(String64 dataName) {
        this.dataName = dataName;
    }

    @Generated
    public void setDataValue(DataValue dataValue) {
        this.dataValue = dataValue;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManageDataOp)) {
            return false;
        }
        ManageDataOp other = (ManageDataOp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String64 this$dataName = this.getDataName();
        String64 other$dataName = other.getDataName();
        if (this$dataName == null ? other$dataName != null : !((Object)this$dataName).equals(other$dataName)) {
            return false;
        }
        DataValue this$dataValue = this.getDataValue();
        DataValue other$dataValue = other.getDataValue();
        return !(this$dataValue == null ? other$dataValue != null : !((Object)this$dataValue).equals(other$dataValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ManageDataOp;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String64 $dataName = this.getDataName();
        result = result * 59 + ($dataName == null ? 43 : ((Object)$dataName).hashCode());
        DataValue $dataValue = this.getDataValue();
        result = result * 59 + ($dataValue == null ? 43 : ((Object)$dataValue).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ManageDataOp(dataName=" + this.getDataName() + ", dataValue=" + this.getDataValue() + ")";
    }

    @Generated
    public ManageDataOp() {
    }

    @Generated
    public ManageDataOp(String64 dataName, DataValue dataValue) {
        this.dataName = dataName;
        this.dataValue = dataValue;
    }

    @Generated
    public static class ManageDataOpBuilder {
        @Generated
        private String64 dataName;
        @Generated
        private DataValue dataValue;

        @Generated
        ManageDataOpBuilder() {
        }

        @Generated
        public ManageDataOpBuilder dataName(String64 dataName) {
            this.dataName = dataName;
            return this;
        }

        @Generated
        public ManageDataOpBuilder dataValue(DataValue dataValue) {
            this.dataValue = dataValue;
            return this;
        }

        @Generated
        public ManageDataOp build() {
            return new ManageDataOp(this.dataName, this.dataValue);
        }

        @Generated
        public String toString() {
            return "ManageDataOp.ManageDataOpBuilder(dataName=" + this.dataName + ", dataValue=" + this.dataValue + ")";
        }
    }
}

