/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ManageOfferEffect implements XdrElement
{
    MANAGE_OFFER_CREATED(0),
    MANAGE_OFFER_UPDATED(1),
    MANAGE_OFFER_DELETED(2);

    private final int value;

    private ManageOfferEffect(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ManageOfferEffect decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return MANAGE_OFFER_CREATED;
            }
            case 1: {
                return MANAGE_OFFER_UPDATED;
            }
            case 2: {
                return MANAGE_OFFER_DELETED;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static ManageOfferEffect fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ManageOfferEffect.fromXdrByteArray(bytes);
    }

    public static ManageOfferEffect fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ManageOfferEffect.decode(xdrDataInputStream);
    }
}

