/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCPEnvelope;
import org.stellar.sdk.xdr.SCPQuorumSet;
import org.stellar.sdk.xdr.StoredTransactionSet;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class PersistedSCPStateV0
implements XdrElement {
    private SCPEnvelope[] scpEnvelopes;
    private SCPQuorumSet[] quorumSets;
    private StoredTransactionSet[] txSets;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        int scpEnvelopesSize = this.getScpEnvelopes().length;
        stream.writeInt(scpEnvelopesSize);
        for (int i = 0; i < scpEnvelopesSize; ++i) {
            this.scpEnvelopes[i].encode(stream);
        }
        int quorumSetsSize = this.getQuorumSets().length;
        stream.writeInt(quorumSetsSize);
        for (int i = 0; i < quorumSetsSize; ++i) {
            this.quorumSets[i].encode(stream);
        }
        int txSetsSize = this.getTxSets().length;
        stream.writeInt(txSetsSize);
        for (int i = 0; i < txSetsSize; ++i) {
            this.txSets[i].encode(stream);
        }
    }

    public static PersistedSCPStateV0 decode(XdrDataInputStream stream) throws IOException {
        PersistedSCPStateV0 decodedPersistedSCPStateV0 = new PersistedSCPStateV0();
        int scpEnvelopesSize = stream.readInt();
        decodedPersistedSCPStateV0.scpEnvelopes = new SCPEnvelope[scpEnvelopesSize];
        for (int i = 0; i < scpEnvelopesSize; ++i) {
            decodedPersistedSCPStateV0.scpEnvelopes[i] = SCPEnvelope.decode(stream);
        }
        int quorumSetsSize = stream.readInt();
        decodedPersistedSCPStateV0.quorumSets = new SCPQuorumSet[quorumSetsSize];
        for (int i = 0; i < quorumSetsSize; ++i) {
            decodedPersistedSCPStateV0.quorumSets[i] = SCPQuorumSet.decode(stream);
        }
        int txSetsSize = stream.readInt();
        decodedPersistedSCPStateV0.txSets = new StoredTransactionSet[txSetsSize];
        for (int i = 0; i < txSetsSize; ++i) {
            decodedPersistedSCPStateV0.txSets[i] = StoredTransactionSet.decode(stream);
        }
        return decodedPersistedSCPStateV0;
    }

    public static PersistedSCPStateV0 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PersistedSCPStateV0.fromXdrByteArray(bytes);
    }

    public static PersistedSCPStateV0 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PersistedSCPStateV0.decode(xdrDataInputStream);
    }

    @Generated
    public static PersistedSCPStateV0Builder builder() {
        return new PersistedSCPStateV0Builder();
    }

    @Generated
    public PersistedSCPStateV0Builder toBuilder() {
        return new PersistedSCPStateV0Builder().scpEnvelopes(this.scpEnvelopes).quorumSets(this.quorumSets).txSets(this.txSets);
    }

    @Generated
    public SCPEnvelope[] getScpEnvelopes() {
        return this.scpEnvelopes;
    }

    @Generated
    public SCPQuorumSet[] getQuorumSets() {
        return this.quorumSets;
    }

    @Generated
    public StoredTransactionSet[] getTxSets() {
        return this.txSets;
    }

    @Generated
    public void setScpEnvelopes(SCPEnvelope[] scpEnvelopes) {
        this.scpEnvelopes = scpEnvelopes;
    }

    @Generated
    public void setQuorumSets(SCPQuorumSet[] quorumSets) {
        this.quorumSets = quorumSets;
    }

    @Generated
    public void setTxSets(StoredTransactionSet[] txSets) {
        this.txSets = txSets;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersistedSCPStateV0)) {
            return false;
        }
        PersistedSCPStateV0 other = (PersistedSCPStateV0)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getScpEnvelopes(), other.getScpEnvelopes())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getQuorumSets(), other.getQuorumSets())) {
            return false;
        }
        return Arrays.deepEquals(this.getTxSets(), other.getTxSets());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PersistedSCPStateV0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getScpEnvelopes());
        result = result * 59 + Arrays.deepHashCode(this.getQuorumSets());
        result = result * 59 + Arrays.deepHashCode(this.getTxSets());
        return result;
    }

    @Generated
    public String toString() {
        return "PersistedSCPStateV0(scpEnvelopes=" + Arrays.deepToString(this.getScpEnvelopes()) + ", quorumSets=" + Arrays.deepToString(this.getQuorumSets()) + ", txSets=" + Arrays.deepToString(this.getTxSets()) + ")";
    }

    @Generated
    public PersistedSCPStateV0() {
    }

    @Generated
    public PersistedSCPStateV0(SCPEnvelope[] scpEnvelopes, SCPQuorumSet[] quorumSets, StoredTransactionSet[] txSets) {
        this.scpEnvelopes = scpEnvelopes;
        this.quorumSets = quorumSets;
        this.txSets = txSets;
    }

    @Generated
    public static class PersistedSCPStateV0Builder {
        @Generated
        private SCPEnvelope[] scpEnvelopes;
        @Generated
        private SCPQuorumSet[] quorumSets;
        @Generated
        private StoredTransactionSet[] txSets;

        @Generated
        PersistedSCPStateV0Builder() {
        }

        @Generated
        public PersistedSCPStateV0Builder scpEnvelopes(SCPEnvelope[] scpEnvelopes) {
            this.scpEnvelopes = scpEnvelopes;
            return this;
        }

        @Generated
        public PersistedSCPStateV0Builder quorumSets(SCPQuorumSet[] quorumSets) {
            this.quorumSets = quorumSets;
            return this;
        }

        @Generated
        public PersistedSCPStateV0Builder txSets(StoredTransactionSet[] txSets) {
            this.txSets = txSets;
            return this;
        }

        @Generated
        public PersistedSCPStateV0 build() {
            return new PersistedSCPStateV0(this.scpEnvelopes, this.quorumSets, this.txSets);
        }

        @Generated
        public String toString() {
            return "PersistedSCPStateV0.PersistedSCPStateV0Builder(scpEnvelopes=" + Arrays.deepToString(this.scpEnvelopes) + ", quorumSets=" + Arrays.deepToString(this.quorumSets) + ", txSets=" + Arrays.deepToString(this.txSets) + ")";
        }
    }
}

