/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SimplePaymentResult
implements XdrElement {
    private AccountID destination;
    private Asset asset;
    private Int64 amount;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.destination.encode(stream);
        this.asset.encode(stream);
        this.amount.encode(stream);
    }

    public static SimplePaymentResult decode(XdrDataInputStream stream) throws IOException {
        SimplePaymentResult decodedSimplePaymentResult = new SimplePaymentResult();
        decodedSimplePaymentResult.destination = AccountID.decode(stream);
        decodedSimplePaymentResult.asset = Asset.decode(stream);
        decodedSimplePaymentResult.amount = Int64.decode(stream);
        return decodedSimplePaymentResult;
    }

    public static SimplePaymentResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SimplePaymentResult.fromXdrByteArray(bytes);
    }

    public static SimplePaymentResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SimplePaymentResult.decode(xdrDataInputStream);
    }

    @Generated
    public static SimplePaymentResultBuilder builder() {
        return new SimplePaymentResultBuilder();
    }

    @Generated
    public SimplePaymentResultBuilder toBuilder() {
        return new SimplePaymentResultBuilder().destination(this.destination).asset(this.asset).amount(this.amount);
    }

    @Generated
    public AccountID getDestination() {
        return this.destination;
    }

    @Generated
    public Asset getAsset() {
        return this.asset;
    }

    @Generated
    public Int64 getAmount() {
        return this.amount;
    }

    @Generated
    public void setDestination(AccountID destination) {
        this.destination = destination;
    }

    @Generated
    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    @Generated
    public void setAmount(Int64 amount) {
        this.amount = amount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimplePaymentResult)) {
            return false;
        }
        SimplePaymentResult other = (SimplePaymentResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AccountID this$destination = this.getDestination();
        AccountID other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !((Object)this$destination).equals(other$destination)) {
            return false;
        }
        Asset this$asset = this.getAsset();
        Asset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        Int64 this$amount = this.getAmount();
        Int64 other$amount = other.getAmount();
        return !(this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimplePaymentResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccountID $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : ((Object)$destination).hashCode());
        Asset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
        Int64 $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SimplePaymentResult(destination=" + this.getDestination() + ", asset=" + this.getAsset() + ", amount=" + this.getAmount() + ")";
    }

    @Generated
    public SimplePaymentResult() {
    }

    @Generated
    public SimplePaymentResult(AccountID destination, Asset asset, Int64 amount) {
        this.destination = destination;
        this.asset = asset;
        this.amount = amount;
    }

    @Generated
    public static class SimplePaymentResultBuilder {
        @Generated
        private AccountID destination;
        @Generated
        private Asset asset;
        @Generated
        private Int64 amount;

        @Generated
        SimplePaymentResultBuilder() {
        }

        @Generated
        public SimplePaymentResultBuilder destination(AccountID destination) {
            this.destination = destination;
            return this;
        }

        @Generated
        public SimplePaymentResultBuilder asset(Asset asset) {
            this.asset = asset;
            return this;
        }

        @Generated
        public SimplePaymentResultBuilder amount(Int64 amount) {
            this.amount = amount;
            return this;
        }

        @Generated
        public SimplePaymentResult build() {
            return new SimplePaymentResult(this.destination, this.asset, this.amount);
        }

        @Generated
        public String toString() {
            return "SimplePaymentResult.SimplePaymentResultBuilder(destination=" + this.destination + ", asset=" + this.asset + ", amount=" + this.amount + ")";
        }
    }
}

