// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;

/**
 * AccountFlags's original definition in the XDR file is:
 *
 * <pre>
 * enum AccountFlags
 * { // masks for each flag
 *
 *     // Flags set on issuer accounts
 *     // TrustLines are created with authorized set to "false" requiring
 *     // the issuer to set it for each TrustLine
 *     AUTH_REQUIRED_FLAG = 0x1,
 *     // If set, the authorized flag in TrustLines can be cleared
 *     // otherwise, authorization cannot be revoked
 *     AUTH_REVOCABLE_FLAG = 0x2,
 *     // Once set, causes all AUTH_&#42; flags to be read-only
 *     AUTH_IMMUTABLE_FLAG = 0x4,
 *     // Trustlines are created with clawback enabled set to "true",
 *     // and claimable balances created from those trustlines are created
 *     // with clawback enabled set to "true"
 *     AUTH_CLAWBACK_ENABLED_FLAG = 0x8
 * };
 * </pre>
 */
public enum AccountFlags implements XdrElement {
  AUTH_REQUIRED_FLAG(1),
  AUTH_REVOCABLE_FLAG(2),
  AUTH_IMMUTABLE_FLAG(4),
  AUTH_CLAWBACK_ENABLED_FLAG(8);

  private final int value;

  AccountFlags(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static AccountFlags decode(XdrDataInputStream stream) throws IOException {
    int value = stream.readInt();
    switch (value) {
      case 1:
        return AUTH_REQUIRED_FLAG;
      case 2:
        return AUTH_REVOCABLE_FLAG;
      case 4:
        return AUTH_IMMUTABLE_FLAG;
      case 8:
        return AUTH_CLAWBACK_ENABLED_FLAG;
      default:
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(value);
  }

  public static AccountFlags fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static AccountFlags fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
