// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * AuthenticatedMessage's original definition in the XDR file is:
 *
 * <pre>
 * union AuthenticatedMessage switch (uint32 v)
 * {
 * case 0:
 *     struct
 *     {
 *         uint64 sequence;
 *         StellarMessage message;
 *         HmacSha256Mac mac;
 *     } v0;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class AuthenticatedMessage implements XdrElement {
  private Uint32 discriminant;
  private AuthenticatedMessageV0 v0;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getUint32().getNumber().intValue());
    switch (discriminant.getUint32().getNumber().intValue()) {
      case 0:
        v0.encode(stream);
        break;
    }
  }

  public static AuthenticatedMessage decode(XdrDataInputStream stream) throws IOException {
    AuthenticatedMessage decodedAuthenticatedMessage = new AuthenticatedMessage();
    Uint32 discriminant = Uint32.decode(stream);
    decodedAuthenticatedMessage.setDiscriminant(discriminant);
    switch (decodedAuthenticatedMessage.getDiscriminant().getUint32().getNumber().intValue()) {
      case 0:
        decodedAuthenticatedMessage.v0 = AuthenticatedMessageV0.decode(stream);
        break;
    }
    return decodedAuthenticatedMessage;
  }

  public static AuthenticatedMessage fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static AuthenticatedMessage fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * AuthenticatedMessageV0's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         uint64 sequence;
   *         StellarMessage message;
   *         HmacSha256Mac mac;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class AuthenticatedMessageV0 implements XdrElement {
    private Uint64 sequence;
    private StellarMessage message;
    private HmacSha256Mac mac;

    public void encode(XdrDataOutputStream stream) throws IOException {
      sequence.encode(stream);
      message.encode(stream);
      mac.encode(stream);
    }

    public static AuthenticatedMessageV0 decode(XdrDataInputStream stream) throws IOException {
      AuthenticatedMessageV0 decodedAuthenticatedMessageV0 = new AuthenticatedMessageV0();
      decodedAuthenticatedMessageV0.sequence = Uint64.decode(stream);
      decodedAuthenticatedMessageV0.message = StellarMessage.decode(stream);
      decodedAuthenticatedMessageV0.mac = HmacSha256Mac.decode(stream);
      return decodedAuthenticatedMessageV0;
    }

    public static AuthenticatedMessageV0 fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static AuthenticatedMessageV0 fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
