// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ContractDataEntry's original definition in the XDR file is:
 *
 * <pre>
 * struct ContractDataEntry {
 *     ExtensionPoint ext;
 *
 *     SCAddress contract;
 *     SCVal key;
 *     ContractDataDurability durability;
 *     SCVal val;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ContractDataEntry implements XdrElement {
  private ExtensionPoint ext;
  private SCAddress contract;
  private SCVal key;
  private ContractDataDurability durability;
  private SCVal val;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ext.encode(stream);
    contract.encode(stream);
    key.encode(stream);
    durability.encode(stream);
    val.encode(stream);
  }

  public static ContractDataEntry decode(XdrDataInputStream stream) throws IOException {
    ContractDataEntry decodedContractDataEntry = new ContractDataEntry();
    decodedContractDataEntry.ext = ExtensionPoint.decode(stream);
    decodedContractDataEntry.contract = SCAddress.decode(stream);
    decodedContractDataEntry.key = SCVal.decode(stream);
    decodedContractDataEntry.durability = ContractDataDurability.decode(stream);
    decodedContractDataEntry.val = SCVal.decode(stream);
    return decodedContractDataEntry;
  }

  public static ContractDataEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ContractDataEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
