// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * HashIDPreimage's original definition in the XDR file is:
 *
 * <pre>
 * union HashIDPreimage switch (EnvelopeType type)
 * {
 * case ENVELOPE_TYPE_OP_ID:
 *     struct
 *     {
 *         AccountID sourceAccount;
 *         SequenceNumber seqNum;
 *         uint32 opNum;
 *     } operationID;
 * case ENVELOPE_TYPE_POOL_REVOKE_OP_ID:
 *     struct
 *     {
 *         AccountID sourceAccount;
 *         SequenceNumber seqNum;
 *         uint32 opNum;
 *         PoolID liquidityPoolID;
 *         Asset asset;
 *     } revokeID;
 * case ENVELOPE_TYPE_CONTRACT_ID:
 *     struct
 *     {
 *         Hash networkID;
 *         ContractIDPreimage contractIDPreimage;
 *     } contractID;
 * case ENVELOPE_TYPE_SOROBAN_AUTHORIZATION:
 *     struct
 *     {
 *         Hash networkID;
 *         int64 nonce;
 *         uint32 signatureExpirationLedger;
 *         SorobanAuthorizedInvocation invocation;
 *     } sorobanAuthorization;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class HashIDPreimage implements XdrElement {
  private EnvelopeType discriminant;
  private HashIDPreimageOperationID operationID;
  private HashIDPreimageRevokeID revokeID;
  private HashIDPreimageContractID contractID;
  private HashIDPreimageSorobanAuthorization sorobanAuthorization;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case ENVELOPE_TYPE_OP_ID:
        operationID.encode(stream);
        break;
      case ENVELOPE_TYPE_POOL_REVOKE_OP_ID:
        revokeID.encode(stream);
        break;
      case ENVELOPE_TYPE_CONTRACT_ID:
        contractID.encode(stream);
        break;
      case ENVELOPE_TYPE_SOROBAN_AUTHORIZATION:
        sorobanAuthorization.encode(stream);
        break;
    }
  }

  public static HashIDPreimage decode(XdrDataInputStream stream) throws IOException {
    HashIDPreimage decodedHashIDPreimage = new HashIDPreimage();
    EnvelopeType discriminant = EnvelopeType.decode(stream);
    decodedHashIDPreimage.setDiscriminant(discriminant);
    switch (decodedHashIDPreimage.getDiscriminant()) {
      case ENVELOPE_TYPE_OP_ID:
        decodedHashIDPreimage.operationID = HashIDPreimageOperationID.decode(stream);
        break;
      case ENVELOPE_TYPE_POOL_REVOKE_OP_ID:
        decodedHashIDPreimage.revokeID = HashIDPreimageRevokeID.decode(stream);
        break;
      case ENVELOPE_TYPE_CONTRACT_ID:
        decodedHashIDPreimage.contractID = HashIDPreimageContractID.decode(stream);
        break;
      case ENVELOPE_TYPE_SOROBAN_AUTHORIZATION:
        decodedHashIDPreimage.sorobanAuthorization =
            HashIDPreimageSorobanAuthorization.decode(stream);
        break;
    }
    return decodedHashIDPreimage;
  }

  public static HashIDPreimage fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static HashIDPreimage fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * HashIDPreimageOperationID's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         AccountID sourceAccount;
   *         SequenceNumber seqNum;
   *         uint32 opNum;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class HashIDPreimageOperationID implements XdrElement {
    private AccountID sourceAccount;
    private SequenceNumber seqNum;
    private Uint32 opNum;

    public void encode(XdrDataOutputStream stream) throws IOException {
      sourceAccount.encode(stream);
      seqNum.encode(stream);
      opNum.encode(stream);
    }

    public static HashIDPreimageOperationID decode(XdrDataInputStream stream) throws IOException {
      HashIDPreimageOperationID decodedHashIDPreimageOperationID = new HashIDPreimageOperationID();
      decodedHashIDPreimageOperationID.sourceAccount = AccountID.decode(stream);
      decodedHashIDPreimageOperationID.seqNum = SequenceNumber.decode(stream);
      decodedHashIDPreimageOperationID.opNum = Uint32.decode(stream);
      return decodedHashIDPreimageOperationID;
    }

    public static HashIDPreimageOperationID fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static HashIDPreimageOperationID fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  /**
   * HashIDPreimageRevokeID's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         AccountID sourceAccount;
   *         SequenceNumber seqNum;
   *         uint32 opNum;
   *         PoolID liquidityPoolID;
   *         Asset asset;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class HashIDPreimageRevokeID implements XdrElement {
    private AccountID sourceAccount;
    private SequenceNumber seqNum;
    private Uint32 opNum;
    private PoolID liquidityPoolID;
    private Asset asset;

    public void encode(XdrDataOutputStream stream) throws IOException {
      sourceAccount.encode(stream);
      seqNum.encode(stream);
      opNum.encode(stream);
      liquidityPoolID.encode(stream);
      asset.encode(stream);
    }

    public static HashIDPreimageRevokeID decode(XdrDataInputStream stream) throws IOException {
      HashIDPreimageRevokeID decodedHashIDPreimageRevokeID = new HashIDPreimageRevokeID();
      decodedHashIDPreimageRevokeID.sourceAccount = AccountID.decode(stream);
      decodedHashIDPreimageRevokeID.seqNum = SequenceNumber.decode(stream);
      decodedHashIDPreimageRevokeID.opNum = Uint32.decode(stream);
      decodedHashIDPreimageRevokeID.liquidityPoolID = PoolID.decode(stream);
      decodedHashIDPreimageRevokeID.asset = Asset.decode(stream);
      return decodedHashIDPreimageRevokeID;
    }

    public static HashIDPreimageRevokeID fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static HashIDPreimageRevokeID fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  /**
   * HashIDPreimageContractID's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         Hash networkID;
   *         ContractIDPreimage contractIDPreimage;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class HashIDPreimageContractID implements XdrElement {
    private Hash networkID;
    private ContractIDPreimage contractIDPreimage;

    public void encode(XdrDataOutputStream stream) throws IOException {
      networkID.encode(stream);
      contractIDPreimage.encode(stream);
    }

    public static HashIDPreimageContractID decode(XdrDataInputStream stream) throws IOException {
      HashIDPreimageContractID decodedHashIDPreimageContractID = new HashIDPreimageContractID();
      decodedHashIDPreimageContractID.networkID = Hash.decode(stream);
      decodedHashIDPreimageContractID.contractIDPreimage = ContractIDPreimage.decode(stream);
      return decodedHashIDPreimageContractID;
    }

    public static HashIDPreimageContractID fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static HashIDPreimageContractID fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }

  /**
   * HashIDPreimageSorobanAuthorization's original definition in the XDR file is:
   *
   * <pre>
   * struct
   *     {
   *         Hash networkID;
   *         int64 nonce;
   *         uint32 signatureExpirationLedger;
   *         SorobanAuthorizedInvocation invocation;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class HashIDPreimageSorobanAuthorization implements XdrElement {
    private Hash networkID;
    private Int64 nonce;
    private Uint32 signatureExpirationLedger;
    private SorobanAuthorizedInvocation invocation;

    public void encode(XdrDataOutputStream stream) throws IOException {
      networkID.encode(stream);
      nonce.encode(stream);
      signatureExpirationLedger.encode(stream);
      invocation.encode(stream);
    }

    public static HashIDPreimageSorobanAuthorization decode(XdrDataInputStream stream)
        throws IOException {
      HashIDPreimageSorobanAuthorization decodedHashIDPreimageSorobanAuthorization =
          new HashIDPreimageSorobanAuthorization();
      decodedHashIDPreimageSorobanAuthorization.networkID = Hash.decode(stream);
      decodedHashIDPreimageSorobanAuthorization.nonce = Int64.decode(stream);
      decodedHashIDPreimageSorobanAuthorization.signatureExpirationLedger = Uint32.decode(stream);
      decodedHashIDPreimageSorobanAuthorization.invocation =
          SorobanAuthorizedInvocation.decode(stream);
      return decodedHashIDPreimageSorobanAuthorization;
    }

    public static HashIDPreimageSorobanAuthorization fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static HashIDPreimageSorobanAuthorization fromXdrByteArray(byte[] xdr)
        throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
