// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCPNomination's original definition in the XDR file is:
 *
 * <pre>
 * struct SCPNomination
 * {
 *     Hash quorumSetHash; // D
 *     Value votes&lt;&gt;;      // X
 *     Value accepted&lt;&gt;;   // Y
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCPNomination implements XdrElement {
  private Hash quorumSetHash;
  private Value[] votes;
  private Value[] accepted;

  public void encode(XdrDataOutputStream stream) throws IOException {
    quorumSetHash.encode(stream);
    int votesSize = getVotes().length;
    stream.writeInt(votesSize);
    for (int i = 0; i < votesSize; i++) {
      votes[i].encode(stream);
    }
    int acceptedSize = getAccepted().length;
    stream.writeInt(acceptedSize);
    for (int i = 0; i < acceptedSize; i++) {
      accepted[i].encode(stream);
    }
  }

  public static SCPNomination decode(XdrDataInputStream stream) throws IOException {
    SCPNomination decodedSCPNomination = new SCPNomination();
    decodedSCPNomination.quorumSetHash = Hash.decode(stream);
    int votesSize = stream.readInt();
    decodedSCPNomination.votes = new Value[votesSize];
    for (int i = 0; i < votesSize; i++) {
      decodedSCPNomination.votes[i] = Value.decode(stream);
    }
    int acceptedSize = stream.readInt();
    decodedSCPNomination.accepted = new Value[acceptedSize];
    for (int i = 0; i < acceptedSize; i++) {
      decodedSCPNomination.accepted[i] = Value.decode(stream);
    }
    return decodedSCPNomination;
  }

  public static SCPNomination fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCPNomination fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
