// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SorobanAuthorizedInvocation's original definition in the XDR file is:
 *
 * <pre>
 * struct SorobanAuthorizedInvocation
 * {
 *     SorobanAuthorizedFunction function;
 *     SorobanAuthorizedInvocation subInvocations&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SorobanAuthorizedInvocation implements XdrElement {
  private SorobanAuthorizedFunction function;
  private SorobanAuthorizedInvocation[] subInvocations;

  public void encode(XdrDataOutputStream stream) throws IOException {
    function.encode(stream);
    int subInvocationsSize = getSubInvocations().length;
    stream.writeInt(subInvocationsSize);
    for (int i = 0; i < subInvocationsSize; i++) {
      subInvocations[i].encode(stream);
    }
  }

  public static SorobanAuthorizedInvocation decode(XdrDataInputStream stream) throws IOException {
    SorobanAuthorizedInvocation decodedSorobanAuthorizedInvocation =
        new SorobanAuthorizedInvocation();
    decodedSorobanAuthorizedInvocation.function = SorobanAuthorizedFunction.decode(stream);
    int subInvocationsSize = stream.readInt();
    decodedSorobanAuthorizedInvocation.subInvocations =
        new SorobanAuthorizedInvocation[subInvocationsSize];
    for (int i = 0; i < subInvocationsSize; i++) {
      decodedSorobanAuthorizedInvocation.subInvocations[i] =
          SorobanAuthorizedInvocation.decode(stream);
    }
    return decodedSorobanAuthorizedInvocation;
  }

  public static SorobanAuthorizedInvocation fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SorobanAuthorizedInvocation fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
