/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.util.Arrays;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.DataValue;
import org.stellar.sdk.xdr.ManageDataOp;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.String64;
import org.stellar.sdk.xdr.XdrString;

public class ManageDataOperation
extends Operation {
    @NonNull
    private final String name;
    @Nullable
    private final byte[] value;

    public static ManageDataOperation fromXdr(ManageDataOp op) {
        String name = op.getDataName().getString64().toString();
        byte[] value = null;
        if (op.getDataValue() != null) {
            value = op.getDataValue().getDataValue();
        }
        return ((ManageDataOperationBuilder)((ManageDataOperationBuilder)ManageDataOperation.builder().name(name)).value(value)).build();
    }

    @Override
    Operation.OperationBody toOperationBody() {
        ManageDataOp op = new ManageDataOp();
        String64 name = new String64();
        name.setString64(new XdrString(this.name));
        op.setDataName(name);
        if (this.value != null) {
            DataValue dataValue = new DataValue();
            dataValue.setDataValue(this.value);
            op.setDataValue(dataValue);
        }
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.MANAGE_DATA);
        body.setManageDataOp(op);
        return body;
    }

    @Generated
    protected ManageDataOperation(ManageDataOperationBuilder<?, ?> b) {
        super(b);
        this.name = ((ManageDataOperationBuilder)b).name;
        if (this.name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.value = ((ManageDataOperationBuilder)b).value;
    }

    @Generated
    public static ManageDataOperationBuilder<?, ?> builder() {
        return new ManageDataOperationBuilderImpl();
    }

    @Generated
    public ManageDataOperationBuilder<?, ?> toBuilder() {
        return new ManageDataOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Nullable
    @Generated
    public byte[] getValue() {
        return this.value;
    }

    @Generated
    public String toString() {
        return "ManageDataOperation(super=" + super.toString() + ", name=" + this.getName() + ", value=" + Arrays.toString(this.getValue()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManageDataOperation)) {
            return false;
        }
        ManageDataOperation other = (ManageDataOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        return Arrays.equals(this.getValue(), other.getValue());
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ManageDataOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.hashCode(this.getValue());
        return result;
    }

    @Generated
    private ManageDataOperation(@NonNull String name, @Nullable byte[] value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.value = value;
    }

    @Generated
    public static abstract class ManageDataOperationBuilder<C extends ManageDataOperation, B extends ManageDataOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private String name;
        @Generated
        private byte[] value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ManageDataOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ManageDataOperation instance, ManageDataOperationBuilder<?, ?> b) {
            b.name(instance.name);
            b.value(instance.value);
        }

        @Generated
        public B name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return (B)this.self();
        }

        @Generated
        public B value(@Nullable byte[] value) {
            this.value = value;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ManageDataOperation.ManageDataOperationBuilder(super=" + super.toString() + ", name=" + this.name + ", value=" + Arrays.toString(this.value) + ")";
        }
    }

    private static final class ManageDataOperationBuilderImpl
    extends ManageDataOperationBuilder<ManageDataOperation, ManageDataOperationBuilderImpl> {
        @Override
        public ManageDataOperation build() {
            ManageDataOperation op = new ManageDataOperation(this);
            if (new XdrString(op.name).getBytes().length > 64) {
                throw new IllegalArgumentException("name cannot exceed 64 bytes");
            }
            return op;
        }

        @Generated
        private ManageDataOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected ManageDataOperationBuilderImpl self() {
            return this;
        }
    }
}

