/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.exception.UnexpectedException;
import org.stellar.sdk.operations.AccountMergeOperation;
import org.stellar.sdk.operations.AllowTrustOperation;
import org.stellar.sdk.operations.BeginSponsoringFutureReservesOperation;
import org.stellar.sdk.operations.BumpSequenceOperation;
import org.stellar.sdk.operations.ChangeTrustOperation;
import org.stellar.sdk.operations.ClaimClaimableBalanceOperation;
import org.stellar.sdk.operations.ClawbackClaimableBalanceOperation;
import org.stellar.sdk.operations.ClawbackOperation;
import org.stellar.sdk.operations.CreateAccountOperation;
import org.stellar.sdk.operations.CreateClaimableBalanceOperation;
import org.stellar.sdk.operations.CreatePassiveSellOfferOperation;
import org.stellar.sdk.operations.EndSponsoringFutureReservesOperation;
import org.stellar.sdk.operations.ExtendFootprintTTLOperation;
import org.stellar.sdk.operations.InflationOperation;
import org.stellar.sdk.operations.InvokeHostFunctionOperation;
import org.stellar.sdk.operations.LiquidityPoolDepositOperation;
import org.stellar.sdk.operations.LiquidityPoolWithdrawOperation;
import org.stellar.sdk.operations.ManageBuyOfferOperation;
import org.stellar.sdk.operations.ManageDataOperation;
import org.stellar.sdk.operations.ManageSellOfferOperation;
import org.stellar.sdk.operations.PathPaymentStrictReceiveOperation;
import org.stellar.sdk.operations.PathPaymentStrictSendOperation;
import org.stellar.sdk.operations.PaymentOperation;
import org.stellar.sdk.operations.RestoreFootprintOperation;
import org.stellar.sdk.operations.RevokeAccountSponsorshipOperation;
import org.stellar.sdk.operations.RevokeClaimableBalanceSponsorshipOperation;
import org.stellar.sdk.operations.RevokeDataSponsorshipOperation;
import org.stellar.sdk.operations.RevokeOfferSponsorshipOperation;
import org.stellar.sdk.operations.RevokeSignerSponsorshipOperation;
import org.stellar.sdk.operations.RevokeTrustlineSponsorshipOperation;
import org.stellar.sdk.operations.SetOptionsOperation;
import org.stellar.sdk.operations.SetTrustlineFlagsOperation;
import org.stellar.sdk.xdr.Operation;

public abstract class Operation {
    private String sourceAccount;
    private static final BigDecimal ONE = new BigDecimal(10).pow(7);

    Operation() {
    }

    public static long toXdrAmount(@NonNull BigDecimal value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        BigDecimal amount = value.multiply(ONE);
        return amount.longValueExact();
    }

    public static BigDecimal fromXdrAmount(long value) {
        return BigDecimal.valueOf(value).divide(ONE).setScale(7, RoundingMode.UNNECESSARY);
    }

    public static BigDecimal formatAmountScale(BigDecimal value) {
        int scale = value.scale();
        if (scale <= 7) {
            return value.setScale(7, RoundingMode.UNNECESSARY);
        }
        throw new IllegalArgumentException("The scale of the value must be less than or equal to 7");
    }

    public org.stellar.sdk.xdr.Operation toXdr() {
        org.stellar.sdk.xdr.Operation xdr = new org.stellar.sdk.xdr.Operation();
        if (this.getSourceAccount() != null) {
            xdr.setSourceAccount(StrKey.encodeToXDRMuxedAccount(this.sourceAccount));
        }
        xdr.setBody(this.toOperationBody());
        return xdr;
    }

    public String toXdrBase64() {
        try {
            return this.toXdr().toXdrBase64();
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
    }

    public static Operation fromXdr(org.stellar.sdk.xdr.Operation xdr) {
        Operation operation;
        Operation.OperationBody body = xdr.getBody();
        block0 : switch (body.getDiscriminant()) {
            case CREATE_ACCOUNT: {
                operation = CreateAccountOperation.fromXdr(body.getCreateAccountOp());
                break;
            }
            case PAYMENT: {
                operation = PaymentOperation.fromXdr(body.getPaymentOp());
                break;
            }
            case PATH_PAYMENT_STRICT_RECEIVE: {
                operation = PathPaymentStrictReceiveOperation.fromXdr(body.getPathPaymentStrictReceiveOp());
                break;
            }
            case MANAGE_SELL_OFFER: {
                operation = ManageSellOfferOperation.fromXdr(body.getManageSellOfferOp());
                break;
            }
            case MANAGE_BUY_OFFER: {
                operation = ManageBuyOfferOperation.fromXdr(body.getManageBuyOfferOp());
                break;
            }
            case CREATE_PASSIVE_SELL_OFFER: {
                operation = CreatePassiveSellOfferOperation.fromXdr(body.getCreatePassiveSellOfferOp());
                break;
            }
            case SET_OPTIONS: {
                operation = SetOptionsOperation.fromXdr(body.getSetOptionsOp());
                break;
            }
            case CHANGE_TRUST: {
                operation = ChangeTrustOperation.fromXdr(body.getChangeTrustOp());
                break;
            }
            case ALLOW_TRUST: {
                operation = AllowTrustOperation.fromXdr(body.getAllowTrustOp());
                break;
            }
            case ACCOUNT_MERGE: {
                operation = AccountMergeOperation.fromXdr(body.getDestination());
                break;
            }
            case INFLATION: {
                operation = InflationOperation.builder().build();
                break;
            }
            case MANAGE_DATA: {
                operation = ManageDataOperation.fromXdr(body.getManageDataOp());
                break;
            }
            case BUMP_SEQUENCE: {
                operation = BumpSequenceOperation.fromXdr(body.getBumpSequenceOp());
                break;
            }
            case PATH_PAYMENT_STRICT_SEND: {
                operation = PathPaymentStrictSendOperation.fromXdr(body.getPathPaymentStrictSendOp());
                break;
            }
            case CREATE_CLAIMABLE_BALANCE: {
                operation = CreateClaimableBalanceOperation.fromXdr(body.getCreateClaimableBalanceOp());
                break;
            }
            case CLAIM_CLAIMABLE_BALANCE: {
                operation = ClaimClaimableBalanceOperation.fromXdr(body.getClaimClaimableBalanceOp());
                break;
            }
            case BEGIN_SPONSORING_FUTURE_RESERVES: {
                operation = BeginSponsoringFutureReservesOperation.fromXdr(body.getBeginSponsoringFutureReservesOp());
                break;
            }
            case END_SPONSORING_FUTURE_RESERVES: {
                operation = EndSponsoringFutureReservesOperation.builder().build();
                break;
            }
            case REVOKE_SPONSORSHIP: {
                switch (body.getRevokeSponsorshipOp().getDiscriminant()) {
                    case REVOKE_SPONSORSHIP_SIGNER: {
                        operation = RevokeSignerSponsorshipOperation.fromXdr(body.getRevokeSponsorshipOp());
                        break block0;
                    }
                    case REVOKE_SPONSORSHIP_LEDGER_ENTRY: {
                        switch (body.getRevokeSponsorshipOp().getLedgerKey().getDiscriminant()) {
                            case DATA: {
                                operation = RevokeDataSponsorshipOperation.fromXdr(body.getRevokeSponsorshipOp());
                                break block0;
                            }
                            case OFFER: {
                                operation = RevokeOfferSponsorshipOperation.fromXdr(body.getRevokeSponsorshipOp());
                                break block0;
                            }
                            case ACCOUNT: {
                                operation = RevokeAccountSponsorshipOperation.fromXdr(body.getRevokeSponsorshipOp());
                                break block0;
                            }
                            case TRUSTLINE: {
                                operation = RevokeTrustlineSponsorshipOperation.fromXdr(body.getRevokeSponsorshipOp());
                                break block0;
                            }
                            case CLAIMABLE_BALANCE: {
                                operation = RevokeClaimableBalanceSponsorshipOperation.fromXdr(body.getRevokeSponsorshipOp());
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException("Unknown revoke sponsorship ledger entry type " + body.getRevokeSponsorshipOp().getLedgerKey().getDiscriminant());
                    }
                }
                throw new IllegalArgumentException("Unknown revoke sponsorship body " + body.getRevokeSponsorshipOp().getDiscriminant());
            }
            case CLAWBACK: {
                operation = ClawbackOperation.fromXdr(body.getClawbackOp());
                break;
            }
            case CLAWBACK_CLAIMABLE_BALANCE: {
                operation = ClawbackClaimableBalanceOperation.fromXdr(body.getClawbackClaimableBalanceOp());
                break;
            }
            case SET_TRUST_LINE_FLAGS: {
                operation = SetTrustlineFlagsOperation.fromXdr(body.getSetTrustLineFlagsOp());
                break;
            }
            case LIQUIDITY_POOL_DEPOSIT: {
                operation = LiquidityPoolDepositOperation.fromXdr(body.getLiquidityPoolDepositOp());
                break;
            }
            case LIQUIDITY_POOL_WITHDRAW: {
                operation = LiquidityPoolWithdrawOperation.fromXdr(body.getLiquidityPoolWithdrawOp());
                break;
            }
            case INVOKE_HOST_FUNCTION: {
                operation = InvokeHostFunctionOperation.fromXdr(body.getInvokeHostFunctionOp());
                break;
            }
            case EXTEND_FOOTPRINT_TTL: {
                operation = ExtendFootprintTTLOperation.fromXdr(body.getExtendFootprintTTLOp());
                break;
            }
            case RESTORE_FOOTPRINT: {
                operation = RestoreFootprintOperation.fromXdr(body.getRestoreFootprintOp());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation body " + body.getDiscriminant());
            }
        }
        if (xdr.getSourceAccount() != null) {
            operation.setSourceAccount(StrKey.encodeMuxedAccount(xdr.getSourceAccount()));
        }
        return operation;
    }

    abstract Operation.OperationBody toOperationBody();

    @Generated
    protected Operation(OperationBuilder<?, ?> b) {
        this.sourceAccount = ((OperationBuilder)b).sourceAccount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Operation)) {
            return false;
        }
        Operation other = (Operation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$sourceAccount = this.getSourceAccount();
        String other$sourceAccount = other.getSourceAccount();
        return !(this$sourceAccount == null ? other$sourceAccount != null : !this$sourceAccount.equals(other$sourceAccount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Operation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sourceAccount = this.getSourceAccount();
        result = result * 59 + ($sourceAccount == null ? 43 : $sourceAccount.hashCode());
        return result;
    }

    @Generated
    public String getSourceAccount() {
        return this.sourceAccount;
    }

    @Generated
    public void setSourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    @Generated
    public static abstract class OperationBuilder<C extends Operation, B extends OperationBuilder<C, B>> {
        @Generated
        private String sourceAccount;

        @Generated
        protected B $fillValuesFrom(C instance) {
            OperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Operation instance, OperationBuilder<?, ?> b) {
            b.sourceAccount(instance.sourceAccount);
        }

        @Generated
        public B sourceAccount(String sourceAccount) {
            this.sourceAccount = sourceAccount;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Operation.OperationBuilder(sourceAccount=" + this.sourceAccount + ")";
        }
    }
}

