/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.List;
import lombok.Generated;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.stellar.sdk.exception.ConnectionErrorException;
import org.stellar.sdk.exception.RequestTimeoutException;
import org.stellar.sdk.requests.ResponseHandler;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Response;
import org.stellar.sdk.responses.gson.TypedResponse;

public class Page<T>
extends Response
implements TypedResponse<Page<T>> {
    @SerializedName(value="records")
    private List<T> records;
    @SerializedName(value="links")
    private Links links;
    private TypeToken<Page<T>> type;

    Page() {
    }

    public Page<T> getNextPage(OkHttpClient httpClient) {
        okhttp3.Response response;
        if (this.getLinks().getNext() == null) {
            return null;
        }
        if (this.type == null) {
            throw new NullPointerException("type cannot be null, is it being correctly set after the creation of this " + this.getClass().getSimpleName() + "?");
        }
        ResponseHandler<Page<T>> responseHandler = new ResponseHandler<Page<T>>(this.type);
        String url = this.getLinks().getNext().getHref();
        Request request = new Request.Builder().get().url(url).build();
        try {
            response = httpClient.newCall(request).execute();
        }
        catch (SocketTimeoutException e) {
            throw new RequestTimeoutException(e);
        }
        catch (IOException e) {
            throw new ConnectionErrorException(e);
        }
        return responseHandler.handleResponse(response);
    }

    @Override
    public void setType(TypeToken<Page<T>> type) {
        this.type = type;
    }

    @Generated
    public List<T> getRecords() {
        return this.records;
    }

    @Generated
    public Links getLinks() {
        return this.links;
    }

    @Generated
    public TypeToken<Page<T>> getType() {
        return this.type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<T> this$records = this.getRecords();
        List<T> other$records = other.getRecords();
        if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        TypeToken<Page<T>> this$type = this.getType();
        TypeToken<Page<T>> other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<T> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        TypeToken<Page<T>> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        return result;
    }

    public static final class Links {
        @SerializedName(value="next")
        private final Link next;
        @SerializedName(value="prev")
        private final Link prev;
        @SerializedName(value="self")
        private final Link self;

        @Generated
        public Links(Link next, Link prev, Link self) {
            this.next = next;
            this.prev = prev;
            this.self = self;
        }

        @Generated
        public Link getNext() {
            return this.next;
        }

        @Generated
        public Link getPrev() {
            return this.prev;
        }

        @Generated
        public Link getSelf() {
            return this.self;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Links)) {
                return false;
            }
            Links other = (Links)o;
            Link this$next = this.getNext();
            Link other$next = other.getNext();
            if (this$next == null ? other$next != null : !((Object)this$next).equals(other$next)) {
                return false;
            }
            Link this$prev = this.getPrev();
            Link other$prev = other.getPrev();
            if (this$prev == null ? other$prev != null : !((Object)this$prev).equals(other$prev)) {
                return false;
            }
            Link this$self = this.getSelf();
            Link other$self = other.getSelf();
            return !(this$self == null ? other$self != null : !((Object)this$self).equals(other$self));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Link $next = this.getNext();
            result = result * 59 + ($next == null ? 43 : ((Object)$next).hashCode());
            Link $prev = this.getPrev();
            result = result * 59 + ($prev == null ? 43 : ((Object)$prev).hashCode());
            Link $self = this.getSelf();
            result = result * 59 + ($self == null ? 43 : ((Object)$self).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Page.Links(next=" + this.getNext() + ", prev=" + this.getPrev() + ", self=" + this.getSelf() + ")";
        }
    }
}

