/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import com.google.gson.annotations.SerializedName;
import java.math.BigInteger;
import java.util.List;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.Memo;
import org.stellar.sdk.Util;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Pageable;
import org.stellar.sdk.responses.Response;
import org.stellar.sdk.xdr.OperationMeta;
import org.stellar.sdk.xdr.TransactionEnvelope;
import org.stellar.sdk.xdr.TransactionMeta;
import org.stellar.sdk.xdr.TransactionResult;

public final class TransactionResponse
extends Response
implements Pageable {
    @SerializedName(value="id")
    private final String id;
    @SerializedName(value="paging_token")
    private final String pagingToken;
    @SerializedName(value="successful")
    private final Boolean successful;
    @SerializedName(value="hash")
    private final String hash;
    @SerializedName(value="ledger")
    private final Long ledger;
    @SerializedName(value="created_at")
    private final String createdAt;
    @SerializedName(value="source_account")
    private final String sourceAccount;
    @SerializedName(value="account_muxed")
    private final String accountMuxed;
    @SerializedName(value="account_muxed_id")
    private final BigInteger accountMuxedId;
    @SerializedName(value="source_account_sequence")
    private final Long sourceAccountSequence;
    @SerializedName(value="fee_account")
    private final String feeAccount;
    @SerializedName(value="fee_account_muxed")
    private final String feeAccountMuxed;
    @SerializedName(value="fee_account_muxed_id")
    private final BigInteger feeAccountMuxedId;
    @SerializedName(value="fee_charged")
    private final Long feeCharged;
    @SerializedName(value="max_fee")
    private final Long maxFee;
    @SerializedName(value="operation_count")
    private final Integer operationCount;
    @SerializedName(value="envelope_xdr")
    private final String envelopeXdr;
    @SerializedName(value="result_xdr")
    private final String resultXdr;
    @SerializedName(value="result_meta_xdr")
    private final String resultMetaXdr;
    @SerializedName(value="fee_meta_xdr")
    private final String feeMetaXdr;
    @SerializedName(value="signatures")
    private final List<String> signatures;
    @SerializedName(value="preconditions")
    private final Preconditions preconditions;
    @SerializedName(value="fee_bump_transaction")
    private final FeeBumpTransaction feeBumpTransaction;
    @SerializedName(value="inner_transaction")
    private final InnerTransaction innerTransaction;
    @SerializedName(value="memo_type")
    private final String memoType;
    @SerializedName(value="memo_bytes")
    private final String memoBytes;
    @SerializedName(value="memo")
    private final String memoValue;
    @SerializedName(value="_links")
    private final Links links;

    public TransactionEnvelope parseEnvelopeXdr() {
        return Util.parseXdr(this.envelopeXdr, TransactionEnvelope::fromXdrBase64);
    }

    public TransactionResult parseResultXdr() {
        return Util.parseXdr(this.resultXdr, TransactionResult::fromXdrBase64);
    }

    public TransactionMeta parseResultMetaXdr() {
        return Util.parseXdr(this.resultMetaXdr, TransactionMeta::fromXdrBase64);
    }

    public OperationMeta parseFeeMetaXdr() {
        return Util.parseXdr(this.feeMetaXdr, OperationMeta::fromXdrBase64);
    }

    public Memo getMemo() {
        if ("none".equals(this.memoType)) {
            return Memo.none();
        }
        if ("text".equals(this.memoType)) {
            return Memo.text(Base64Factory.getInstance().decode(this.memoBytes));
        }
        if ("id".equals(this.memoType)) {
            return Memo.id(new BigInteger(this.memoValue));
        }
        if ("hash".equals(this.memoType)) {
            return Memo.hash(Base64Factory.getInstance().decode(this.memoValue));
        }
        if ("return".equals(this.memoType)) {
            return Memo.returnHash(Base64Factory.getInstance().decode(this.memoValue));
        }
        throw new IllegalArgumentException("Invalid memo type: " + this.memoType);
    }

    @Generated
    public TransactionResponse(String id, String pagingToken, Boolean successful, String hash, Long ledger, String createdAt, String sourceAccount, String accountMuxed, BigInteger accountMuxedId, Long sourceAccountSequence, String feeAccount, String feeAccountMuxed, BigInteger feeAccountMuxedId, Long feeCharged, Long maxFee, Integer operationCount, String envelopeXdr, String resultXdr, String resultMetaXdr, String feeMetaXdr, List<String> signatures, Preconditions preconditions, FeeBumpTransaction feeBumpTransaction, InnerTransaction innerTransaction, String memoType, String memoBytes, String memoValue, Links links) {
        this.id = id;
        this.pagingToken = pagingToken;
        this.successful = successful;
        this.hash = hash;
        this.ledger = ledger;
        this.createdAt = createdAt;
        this.sourceAccount = sourceAccount;
        this.accountMuxed = accountMuxed;
        this.accountMuxedId = accountMuxedId;
        this.sourceAccountSequence = sourceAccountSequence;
        this.feeAccount = feeAccount;
        this.feeAccountMuxed = feeAccountMuxed;
        this.feeAccountMuxedId = feeAccountMuxedId;
        this.feeCharged = feeCharged;
        this.maxFee = maxFee;
        this.operationCount = operationCount;
        this.envelopeXdr = envelopeXdr;
        this.resultXdr = resultXdr;
        this.resultMetaXdr = resultMetaXdr;
        this.feeMetaXdr = feeMetaXdr;
        this.signatures = signatures;
        this.preconditions = preconditions;
        this.feeBumpTransaction = feeBumpTransaction;
        this.innerTransaction = innerTransaction;
        this.memoType = memoType;
        this.memoBytes = memoBytes;
        this.memoValue = memoValue;
        this.links = links;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getPagingToken() {
        return this.pagingToken;
    }

    @Generated
    public Boolean getSuccessful() {
        return this.successful;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public Long getLedger() {
        return this.ledger;
    }

    @Generated
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public String getSourceAccount() {
        return this.sourceAccount;
    }

    @Generated
    public String getAccountMuxed() {
        return this.accountMuxed;
    }

    @Generated
    public BigInteger getAccountMuxedId() {
        return this.accountMuxedId;
    }

    @Generated
    public Long getSourceAccountSequence() {
        return this.sourceAccountSequence;
    }

    @Generated
    public String getFeeAccount() {
        return this.feeAccount;
    }

    @Generated
    public String getFeeAccountMuxed() {
        return this.feeAccountMuxed;
    }

    @Generated
    public BigInteger getFeeAccountMuxedId() {
        return this.feeAccountMuxedId;
    }

    @Generated
    public Long getFeeCharged() {
        return this.feeCharged;
    }

    @Generated
    public Long getMaxFee() {
        return this.maxFee;
    }

    @Generated
    public Integer getOperationCount() {
        return this.operationCount;
    }

    @Generated
    public String getEnvelopeXdr() {
        return this.envelopeXdr;
    }

    @Generated
    public String getResultXdr() {
        return this.resultXdr;
    }

    @Generated
    public String getResultMetaXdr() {
        return this.resultMetaXdr;
    }

    @Generated
    public String getFeeMetaXdr() {
        return this.feeMetaXdr;
    }

    @Generated
    public List<String> getSignatures() {
        return this.signatures;
    }

    @Generated
    public Preconditions getPreconditions() {
        return this.preconditions;
    }

    @Generated
    public FeeBumpTransaction getFeeBumpTransaction() {
        return this.feeBumpTransaction;
    }

    @Generated
    public InnerTransaction getInnerTransaction() {
        return this.innerTransaction;
    }

    @Generated
    public String getMemoType() {
        return this.memoType;
    }

    @Generated
    public String getMemoBytes() {
        return this.memoBytes;
    }

    @Generated
    public String getMemoValue() {
        return this.memoValue;
    }

    @Generated
    public Links getLinks() {
        return this.links;
    }

    @Generated
    public String toString() {
        return "TransactionResponse(id=" + this.getId() + ", pagingToken=" + this.getPagingToken() + ", successful=" + this.getSuccessful() + ", hash=" + this.getHash() + ", ledger=" + this.getLedger() + ", createdAt=" + this.getCreatedAt() + ", sourceAccount=" + this.getSourceAccount() + ", accountMuxed=" + this.getAccountMuxed() + ", accountMuxedId=" + this.getAccountMuxedId() + ", sourceAccountSequence=" + this.getSourceAccountSequence() + ", feeAccount=" + this.getFeeAccount() + ", feeAccountMuxed=" + this.getFeeAccountMuxed() + ", feeAccountMuxedId=" + this.getFeeAccountMuxedId() + ", feeCharged=" + this.getFeeCharged() + ", maxFee=" + this.getMaxFee() + ", operationCount=" + this.getOperationCount() + ", envelopeXdr=" + this.getEnvelopeXdr() + ", resultXdr=" + this.getResultXdr() + ", resultMetaXdr=" + this.getResultMetaXdr() + ", feeMetaXdr=" + this.getFeeMetaXdr() + ", signatures=" + this.getSignatures() + ", preconditions=" + this.getPreconditions() + ", feeBumpTransaction=" + this.getFeeBumpTransaction() + ", innerTransaction=" + this.getInnerTransaction() + ", memoType=" + this.getMemoType() + ", memoBytes=" + this.getMemoBytes() + ", memoValue=" + this.getMemoValue() + ", links=" + this.getLinks() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionResponse)) {
            return false;
        }
        TransactionResponse other = (TransactionResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$successful = this.getSuccessful();
        Boolean other$successful = other.getSuccessful();
        if (this$successful == null ? other$successful != null : !((Object)this$successful).equals(other$successful)) {
            return false;
        }
        Long this$ledger = this.getLedger();
        Long other$ledger = other.getLedger();
        if (this$ledger == null ? other$ledger != null : !((Object)this$ledger).equals(other$ledger)) {
            return false;
        }
        Long this$sourceAccountSequence = this.getSourceAccountSequence();
        Long other$sourceAccountSequence = other.getSourceAccountSequence();
        if (this$sourceAccountSequence == null ? other$sourceAccountSequence != null : !((Object)this$sourceAccountSequence).equals(other$sourceAccountSequence)) {
            return false;
        }
        Long this$feeCharged = this.getFeeCharged();
        Long other$feeCharged = other.getFeeCharged();
        if (this$feeCharged == null ? other$feeCharged != null : !((Object)this$feeCharged).equals(other$feeCharged)) {
            return false;
        }
        Long this$maxFee = this.getMaxFee();
        Long other$maxFee = other.getMaxFee();
        if (this$maxFee == null ? other$maxFee != null : !((Object)this$maxFee).equals(other$maxFee)) {
            return false;
        }
        Integer this$operationCount = this.getOperationCount();
        Integer other$operationCount = other.getOperationCount();
        if (this$operationCount == null ? other$operationCount != null : !((Object)this$operationCount).equals(other$operationCount)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$pagingToken = this.getPagingToken();
        String other$pagingToken = other.getPagingToken();
        if (this$pagingToken == null ? other$pagingToken != null : !this$pagingToken.equals(other$pagingToken)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$createdAt = this.getCreatedAt();
        String other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) {
            return false;
        }
        String this$sourceAccount = this.getSourceAccount();
        String other$sourceAccount = other.getSourceAccount();
        if (this$sourceAccount == null ? other$sourceAccount != null : !this$sourceAccount.equals(other$sourceAccount)) {
            return false;
        }
        String this$accountMuxed = this.getAccountMuxed();
        String other$accountMuxed = other.getAccountMuxed();
        if (this$accountMuxed == null ? other$accountMuxed != null : !this$accountMuxed.equals(other$accountMuxed)) {
            return false;
        }
        BigInteger this$accountMuxedId = this.getAccountMuxedId();
        BigInteger other$accountMuxedId = other.getAccountMuxedId();
        if (this$accountMuxedId == null ? other$accountMuxedId != null : !((Object)this$accountMuxedId).equals(other$accountMuxedId)) {
            return false;
        }
        String this$feeAccount = this.getFeeAccount();
        String other$feeAccount = other.getFeeAccount();
        if (this$feeAccount == null ? other$feeAccount != null : !this$feeAccount.equals(other$feeAccount)) {
            return false;
        }
        String this$feeAccountMuxed = this.getFeeAccountMuxed();
        String other$feeAccountMuxed = other.getFeeAccountMuxed();
        if (this$feeAccountMuxed == null ? other$feeAccountMuxed != null : !this$feeAccountMuxed.equals(other$feeAccountMuxed)) {
            return false;
        }
        BigInteger this$feeAccountMuxedId = this.getFeeAccountMuxedId();
        BigInteger other$feeAccountMuxedId = other.getFeeAccountMuxedId();
        if (this$feeAccountMuxedId == null ? other$feeAccountMuxedId != null : !((Object)this$feeAccountMuxedId).equals(other$feeAccountMuxedId)) {
            return false;
        }
        String this$envelopeXdr = this.getEnvelopeXdr();
        String other$envelopeXdr = other.getEnvelopeXdr();
        if (this$envelopeXdr == null ? other$envelopeXdr != null : !this$envelopeXdr.equals(other$envelopeXdr)) {
            return false;
        }
        String this$resultXdr = this.getResultXdr();
        String other$resultXdr = other.getResultXdr();
        if (this$resultXdr == null ? other$resultXdr != null : !this$resultXdr.equals(other$resultXdr)) {
            return false;
        }
        String this$resultMetaXdr = this.getResultMetaXdr();
        String other$resultMetaXdr = other.getResultMetaXdr();
        if (this$resultMetaXdr == null ? other$resultMetaXdr != null : !this$resultMetaXdr.equals(other$resultMetaXdr)) {
            return false;
        }
        String this$feeMetaXdr = this.getFeeMetaXdr();
        String other$feeMetaXdr = other.getFeeMetaXdr();
        if (this$feeMetaXdr == null ? other$feeMetaXdr != null : !this$feeMetaXdr.equals(other$feeMetaXdr)) {
            return false;
        }
        List<String> this$signatures = this.getSignatures();
        List<String> other$signatures = other.getSignatures();
        if (this$signatures == null ? other$signatures != null : !((Object)this$signatures).equals(other$signatures)) {
            return false;
        }
        Preconditions this$preconditions = this.getPreconditions();
        Preconditions other$preconditions = other.getPreconditions();
        if (this$preconditions == null ? other$preconditions != null : !((Object)this$preconditions).equals(other$preconditions)) {
            return false;
        }
        FeeBumpTransaction this$feeBumpTransaction = this.getFeeBumpTransaction();
        FeeBumpTransaction other$feeBumpTransaction = other.getFeeBumpTransaction();
        if (this$feeBumpTransaction == null ? other$feeBumpTransaction != null : !((Object)this$feeBumpTransaction).equals(other$feeBumpTransaction)) {
            return false;
        }
        InnerTransaction this$innerTransaction = this.getInnerTransaction();
        InnerTransaction other$innerTransaction = other.getInnerTransaction();
        if (this$innerTransaction == null ? other$innerTransaction != null : !((Object)this$innerTransaction).equals(other$innerTransaction)) {
            return false;
        }
        String this$memoType = this.getMemoType();
        String other$memoType = other.getMemoType();
        if (this$memoType == null ? other$memoType != null : !this$memoType.equals(other$memoType)) {
            return false;
        }
        String this$memoBytes = this.getMemoBytes();
        String other$memoBytes = other.getMemoBytes();
        if (this$memoBytes == null ? other$memoBytes != null : !this$memoBytes.equals(other$memoBytes)) {
            return false;
        }
        String this$memoValue = this.getMemoValue();
        String other$memoValue = other.getMemoValue();
        if (this$memoValue == null ? other$memoValue != null : !this$memoValue.equals(other$memoValue)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $successful = this.getSuccessful();
        result = result * 59 + ($successful == null ? 43 : ((Object)$successful).hashCode());
        Long $ledger = this.getLedger();
        result = result * 59 + ($ledger == null ? 43 : ((Object)$ledger).hashCode());
        Long $sourceAccountSequence = this.getSourceAccountSequence();
        result = result * 59 + ($sourceAccountSequence == null ? 43 : ((Object)$sourceAccountSequence).hashCode());
        Long $feeCharged = this.getFeeCharged();
        result = result * 59 + ($feeCharged == null ? 43 : ((Object)$feeCharged).hashCode());
        Long $maxFee = this.getMaxFee();
        result = result * 59 + ($maxFee == null ? 43 : ((Object)$maxFee).hashCode());
        Integer $operationCount = this.getOperationCount();
        result = result * 59 + ($operationCount == null ? 43 : ((Object)$operationCount).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $pagingToken = this.getPagingToken();
        result = result * 59 + ($pagingToken == null ? 43 : $pagingToken.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : $createdAt.hashCode());
        String $sourceAccount = this.getSourceAccount();
        result = result * 59 + ($sourceAccount == null ? 43 : $sourceAccount.hashCode());
        String $accountMuxed = this.getAccountMuxed();
        result = result * 59 + ($accountMuxed == null ? 43 : $accountMuxed.hashCode());
        BigInteger $accountMuxedId = this.getAccountMuxedId();
        result = result * 59 + ($accountMuxedId == null ? 43 : ((Object)$accountMuxedId).hashCode());
        String $feeAccount = this.getFeeAccount();
        result = result * 59 + ($feeAccount == null ? 43 : $feeAccount.hashCode());
        String $feeAccountMuxed = this.getFeeAccountMuxed();
        result = result * 59 + ($feeAccountMuxed == null ? 43 : $feeAccountMuxed.hashCode());
        BigInteger $feeAccountMuxedId = this.getFeeAccountMuxedId();
        result = result * 59 + ($feeAccountMuxedId == null ? 43 : ((Object)$feeAccountMuxedId).hashCode());
        String $envelopeXdr = this.getEnvelopeXdr();
        result = result * 59 + ($envelopeXdr == null ? 43 : $envelopeXdr.hashCode());
        String $resultXdr = this.getResultXdr();
        result = result * 59 + ($resultXdr == null ? 43 : $resultXdr.hashCode());
        String $resultMetaXdr = this.getResultMetaXdr();
        result = result * 59 + ($resultMetaXdr == null ? 43 : $resultMetaXdr.hashCode());
        String $feeMetaXdr = this.getFeeMetaXdr();
        result = result * 59 + ($feeMetaXdr == null ? 43 : $feeMetaXdr.hashCode());
        List<String> $signatures = this.getSignatures();
        result = result * 59 + ($signatures == null ? 43 : ((Object)$signatures).hashCode());
        Preconditions $preconditions = this.getPreconditions();
        result = result * 59 + ($preconditions == null ? 43 : ((Object)$preconditions).hashCode());
        FeeBumpTransaction $feeBumpTransaction = this.getFeeBumpTransaction();
        result = result * 59 + ($feeBumpTransaction == null ? 43 : ((Object)$feeBumpTransaction).hashCode());
        InnerTransaction $innerTransaction = this.getInnerTransaction();
        result = result * 59 + ($innerTransaction == null ? 43 : ((Object)$innerTransaction).hashCode());
        String $memoType = this.getMemoType();
        result = result * 59 + ($memoType == null ? 43 : $memoType.hashCode());
        String $memoBytes = this.getMemoBytes();
        result = result * 59 + ($memoBytes == null ? 43 : $memoBytes.hashCode());
        String $memoValue = this.getMemoValue();
        result = result * 59 + ($memoValue == null ? 43 : $memoValue.hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }

    public static final class Preconditions {
        @SerializedName(value="timebounds")
        private final TimeBounds timeBounds;
        @SerializedName(value="ledgerbounds")
        private final LedgerBounds ledgerBounds;
        @SerializedName(value="min_account_sequence")
        private final Long minAccountSequence;
        @SerializedName(value="min_account_sequence_age")
        private final Long minAccountSequenceAge;
        @SerializedName(value="min_account_sequence_ledger_gap")
        private final Long minAccountSequenceLedgerGap;
        @SerializedName(value="extra_signers")
        private final List<String> signatures;

        @Generated
        public Preconditions(TimeBounds timeBounds, LedgerBounds ledgerBounds, Long minAccountSequence, Long minAccountSequenceAge, Long minAccountSequenceLedgerGap, List<String> signatures) {
            this.timeBounds = timeBounds;
            this.ledgerBounds = ledgerBounds;
            this.minAccountSequence = minAccountSequence;
            this.minAccountSequenceAge = minAccountSequenceAge;
            this.minAccountSequenceLedgerGap = minAccountSequenceLedgerGap;
            this.signatures = signatures;
        }

        @Generated
        public TimeBounds getTimeBounds() {
            return this.timeBounds;
        }

        @Generated
        public LedgerBounds getLedgerBounds() {
            return this.ledgerBounds;
        }

        @Generated
        public Long getMinAccountSequence() {
            return this.minAccountSequence;
        }

        @Generated
        public Long getMinAccountSequenceAge() {
            return this.minAccountSequenceAge;
        }

        @Generated
        public Long getMinAccountSequenceLedgerGap() {
            return this.minAccountSequenceLedgerGap;
        }

        @Generated
        public List<String> getSignatures() {
            return this.signatures;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Preconditions)) {
                return false;
            }
            Preconditions other = (Preconditions)o;
            Long this$minAccountSequence = this.getMinAccountSequence();
            Long other$minAccountSequence = other.getMinAccountSequence();
            if (this$minAccountSequence == null ? other$minAccountSequence != null : !((Object)this$minAccountSequence).equals(other$minAccountSequence)) {
                return false;
            }
            Long this$minAccountSequenceAge = this.getMinAccountSequenceAge();
            Long other$minAccountSequenceAge = other.getMinAccountSequenceAge();
            if (this$minAccountSequenceAge == null ? other$minAccountSequenceAge != null : !((Object)this$minAccountSequenceAge).equals(other$minAccountSequenceAge)) {
                return false;
            }
            Long this$minAccountSequenceLedgerGap = this.getMinAccountSequenceLedgerGap();
            Long other$minAccountSequenceLedgerGap = other.getMinAccountSequenceLedgerGap();
            if (this$minAccountSequenceLedgerGap == null ? other$minAccountSequenceLedgerGap != null : !((Object)this$minAccountSequenceLedgerGap).equals(other$minAccountSequenceLedgerGap)) {
                return false;
            }
            TimeBounds this$timeBounds = this.getTimeBounds();
            TimeBounds other$timeBounds = other.getTimeBounds();
            if (this$timeBounds == null ? other$timeBounds != null : !((Object)this$timeBounds).equals(other$timeBounds)) {
                return false;
            }
            LedgerBounds this$ledgerBounds = this.getLedgerBounds();
            LedgerBounds other$ledgerBounds = other.getLedgerBounds();
            if (this$ledgerBounds == null ? other$ledgerBounds != null : !((Object)this$ledgerBounds).equals(other$ledgerBounds)) {
                return false;
            }
            List<String> this$signatures = this.getSignatures();
            List<String> other$signatures = other.getSignatures();
            return !(this$signatures == null ? other$signatures != null : !((Object)this$signatures).equals(other$signatures));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $minAccountSequence = this.getMinAccountSequence();
            result = result * 59 + ($minAccountSequence == null ? 43 : ((Object)$minAccountSequence).hashCode());
            Long $minAccountSequenceAge = this.getMinAccountSequenceAge();
            result = result * 59 + ($minAccountSequenceAge == null ? 43 : ((Object)$minAccountSequenceAge).hashCode());
            Long $minAccountSequenceLedgerGap = this.getMinAccountSequenceLedgerGap();
            result = result * 59 + ($minAccountSequenceLedgerGap == null ? 43 : ((Object)$minAccountSequenceLedgerGap).hashCode());
            TimeBounds $timeBounds = this.getTimeBounds();
            result = result * 59 + ($timeBounds == null ? 43 : ((Object)$timeBounds).hashCode());
            LedgerBounds $ledgerBounds = this.getLedgerBounds();
            result = result * 59 + ($ledgerBounds == null ? 43 : ((Object)$ledgerBounds).hashCode());
            List<String> $signatures = this.getSignatures();
            result = result * 59 + ($signatures == null ? 43 : ((Object)$signatures).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TransactionResponse.Preconditions(timeBounds=" + this.getTimeBounds() + ", ledgerBounds=" + this.getLedgerBounds() + ", minAccountSequence=" + this.getMinAccountSequence() + ", minAccountSequenceAge=" + this.getMinAccountSequenceAge() + ", minAccountSequenceLedgerGap=" + this.getMinAccountSequenceLedgerGap() + ", signatures=" + this.getSignatures() + ")";
        }

        public static final class TimeBounds {
            @SerializedName(value="min_time")
            private final BigInteger minTime;
            @SerializedName(value="max_time")
            private final BigInteger maxTime;

            @Generated
            public TimeBounds(BigInteger minTime, BigInteger maxTime) {
                this.minTime = minTime;
                this.maxTime = maxTime;
            }

            @Generated
            public BigInteger getMinTime() {
                return this.minTime;
            }

            @Generated
            public BigInteger getMaxTime() {
                return this.maxTime;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TimeBounds)) {
                    return false;
                }
                TimeBounds other = (TimeBounds)o;
                BigInteger this$minTime = this.getMinTime();
                BigInteger other$minTime = other.getMinTime();
                if (this$minTime == null ? other$minTime != null : !((Object)this$minTime).equals(other$minTime)) {
                    return false;
                }
                BigInteger this$maxTime = this.getMaxTime();
                BigInteger other$maxTime = other.getMaxTime();
                return !(this$maxTime == null ? other$maxTime != null : !((Object)this$maxTime).equals(other$maxTime));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                BigInteger $minTime = this.getMinTime();
                result = result * 59 + ($minTime == null ? 43 : ((Object)$minTime).hashCode());
                BigInteger $maxTime = this.getMaxTime();
                result = result * 59 + ($maxTime == null ? 43 : ((Object)$maxTime).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "TransactionResponse.Preconditions.TimeBounds(minTime=" + this.getMinTime() + ", maxTime=" + this.getMaxTime() + ")";
            }
        }

        public static final class LedgerBounds {
            @SerializedName(value="min_ledger")
            private final Long minTime;
            @SerializedName(value="max_ledger")
            private final Long maxTime;

            @Generated
            public LedgerBounds(Long minTime, Long maxTime) {
                this.minTime = minTime;
                this.maxTime = maxTime;
            }

            @Generated
            public Long getMinTime() {
                return this.minTime;
            }

            @Generated
            public Long getMaxTime() {
                return this.maxTime;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LedgerBounds)) {
                    return false;
                }
                LedgerBounds other = (LedgerBounds)o;
                Long this$minTime = this.getMinTime();
                Long other$minTime = other.getMinTime();
                if (this$minTime == null ? other$minTime != null : !((Object)this$minTime).equals(other$minTime)) {
                    return false;
                }
                Long this$maxTime = this.getMaxTime();
                Long other$maxTime = other.getMaxTime();
                return !(this$maxTime == null ? other$maxTime != null : !((Object)this$maxTime).equals(other$maxTime));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $minTime = this.getMinTime();
                result = result * 59 + ($minTime == null ? 43 : ((Object)$minTime).hashCode());
                Long $maxTime = this.getMaxTime();
                result = result * 59 + ($maxTime == null ? 43 : ((Object)$maxTime).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "TransactionResponse.Preconditions.LedgerBounds(minTime=" + this.getMinTime() + ", maxTime=" + this.getMaxTime() + ")";
            }
        }
    }

    public static final class FeeBumpTransaction {
        @SerializedName(value="hash")
        private final String hash;
        @SerializedName(value="signatures")
        private final List<String> signatures;

        @Generated
        public FeeBumpTransaction(String hash, List<String> signatures) {
            this.hash = hash;
            this.signatures = signatures;
        }

        @Generated
        public String getHash() {
            return this.hash;
        }

        @Generated
        public List<String> getSignatures() {
            return this.signatures;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeeBumpTransaction)) {
                return false;
            }
            FeeBumpTransaction other = (FeeBumpTransaction)o;
            String this$hash = this.getHash();
            String other$hash = other.getHash();
            if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
                return false;
            }
            List<String> this$signatures = this.getSignatures();
            List<String> other$signatures = other.getSignatures();
            return !(this$signatures == null ? other$signatures != null : !((Object)this$signatures).equals(other$signatures));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hash = this.getHash();
            result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
            List<String> $signatures = this.getSignatures();
            result = result * 59 + ($signatures == null ? 43 : ((Object)$signatures).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TransactionResponse.FeeBumpTransaction(hash=" + this.getHash() + ", signatures=" + this.getSignatures() + ")";
        }
    }

    public static final class InnerTransaction {
        @SerializedName(value="hash")
        private final String hash;
        @SerializedName(value="signatures")
        private final List<String> signatures;
        @SerializedName(value="max_fee")
        private final Long maxFee;

        @Generated
        public InnerTransaction(String hash, List<String> signatures, Long maxFee) {
            this.hash = hash;
            this.signatures = signatures;
            this.maxFee = maxFee;
        }

        @Generated
        public String getHash() {
            return this.hash;
        }

        @Generated
        public List<String> getSignatures() {
            return this.signatures;
        }

        @Generated
        public Long getMaxFee() {
            return this.maxFee;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InnerTransaction)) {
                return false;
            }
            InnerTransaction other = (InnerTransaction)o;
            Long this$maxFee = this.getMaxFee();
            Long other$maxFee = other.getMaxFee();
            if (this$maxFee == null ? other$maxFee != null : !((Object)this$maxFee).equals(other$maxFee)) {
                return false;
            }
            String this$hash = this.getHash();
            String other$hash = other.getHash();
            if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
                return false;
            }
            List<String> this$signatures = this.getSignatures();
            List<String> other$signatures = other.getSignatures();
            return !(this$signatures == null ? other$signatures != null : !((Object)this$signatures).equals(other$signatures));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $maxFee = this.getMaxFee();
            result = result * 59 + ($maxFee == null ? 43 : ((Object)$maxFee).hashCode());
            String $hash = this.getHash();
            result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
            List<String> $signatures = this.getSignatures();
            result = result * 59 + ($signatures == null ? 43 : ((Object)$signatures).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TransactionResponse.InnerTransaction(hash=" + this.getHash() + ", signatures=" + this.getSignatures() + ", maxFee=" + this.getMaxFee() + ")";
        }
    }

    public static final class Links {
        @SerializedName(value="self")
        private final Link self;
        @SerializedName(value="account")
        private final Link account;
        @SerializedName(value="ledger")
        private final Link ledger;
        @SerializedName(value="operations")
        private final Link operations;
        @SerializedName(value="effects")
        private final Link effects;
        @SerializedName(value="precedes")
        private final Link precedes;
        @SerializedName(value="succeeds")
        private final Link succeeds;

        @Generated
        public Links(Link self, Link account, Link ledger, Link operations, Link effects, Link precedes, Link succeeds) {
            this.self = self;
            this.account = account;
            this.ledger = ledger;
            this.operations = operations;
            this.effects = effects;
            this.precedes = precedes;
            this.succeeds = succeeds;
        }

        @Generated
        public Link getSelf() {
            return this.self;
        }

        @Generated
        public Link getAccount() {
            return this.account;
        }

        @Generated
        public Link getLedger() {
            return this.ledger;
        }

        @Generated
        public Link getOperations() {
            return this.operations;
        }

        @Generated
        public Link getEffects() {
            return this.effects;
        }

        @Generated
        public Link getPrecedes() {
            return this.precedes;
        }

        @Generated
        public Link getSucceeds() {
            return this.succeeds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Links)) {
                return false;
            }
            Links other = (Links)o;
            Link this$self = this.getSelf();
            Link other$self = other.getSelf();
            if (this$self == null ? other$self != null : !((Object)this$self).equals(other$self)) {
                return false;
            }
            Link this$account = this.getAccount();
            Link other$account = other.getAccount();
            if (this$account == null ? other$account != null : !((Object)this$account).equals(other$account)) {
                return false;
            }
            Link this$ledger = this.getLedger();
            Link other$ledger = other.getLedger();
            if (this$ledger == null ? other$ledger != null : !((Object)this$ledger).equals(other$ledger)) {
                return false;
            }
            Link this$operations = this.getOperations();
            Link other$operations = other.getOperations();
            if (this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations)) {
                return false;
            }
            Link this$effects = this.getEffects();
            Link other$effects = other.getEffects();
            if (this$effects == null ? other$effects != null : !((Object)this$effects).equals(other$effects)) {
                return false;
            }
            Link this$precedes = this.getPrecedes();
            Link other$precedes = other.getPrecedes();
            if (this$precedes == null ? other$precedes != null : !((Object)this$precedes).equals(other$precedes)) {
                return false;
            }
            Link this$succeeds = this.getSucceeds();
            Link other$succeeds = other.getSucceeds();
            return !(this$succeeds == null ? other$succeeds != null : !((Object)this$succeeds).equals(other$succeeds));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Link $self = this.getSelf();
            result = result * 59 + ($self == null ? 43 : ((Object)$self).hashCode());
            Link $account = this.getAccount();
            result = result * 59 + ($account == null ? 43 : ((Object)$account).hashCode());
            Link $ledger = this.getLedger();
            result = result * 59 + ($ledger == null ? 43 : ((Object)$ledger).hashCode());
            Link $operations = this.getOperations();
            result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
            Link $effects = this.getEffects();
            result = result * 59 + ($effects == null ? 43 : ((Object)$effects).hashCode());
            Link $precedes = this.getPrecedes();
            result = result * 59 + ($precedes == null ? 43 : ((Object)$precedes).hashCode());
            Link $succeeds = this.getSucceeds();
            result = result * 59 + ($succeeds == null ? 43 : ((Object)$succeeds).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TransactionResponse.Links(self=" + this.getSelf() + ", account=" + this.getAccount() + ", ledger=" + this.getLedger() + ", operations=" + this.getOperations() + ", effects=" + this.getEffects() + ", precedes=" + this.getPrecedes() + ", succeeds=" + this.getSucceeds() + ")";
        }
    }
}

