/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AlphaNum12;
import org.stellar.sdk.xdr.AlphaNum4;
import org.stellar.sdk.xdr.AssetType;
import org.stellar.sdk.xdr.LiquidityPoolParameters;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ChangeTrustAsset
implements XdrElement {
    private AssetType discriminant;
    private AlphaNum4 alphaNum4;
    private AlphaNum12 alphaNum12;
    private LiquidityPoolParameters liquidityPool;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case ASSET_TYPE_NATIVE: {
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                this.alphaNum4.encode(stream);
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                this.alphaNum12.encode(stream);
                break;
            }
            case ASSET_TYPE_POOL_SHARE: {
                this.liquidityPool.encode(stream);
            }
        }
    }

    public static ChangeTrustAsset decode(XdrDataInputStream stream) throws IOException {
        ChangeTrustAsset decodedChangeTrustAsset = new ChangeTrustAsset();
        AssetType discriminant = AssetType.decode(stream);
        decodedChangeTrustAsset.setDiscriminant(discriminant);
        switch (decodedChangeTrustAsset.getDiscriminant()) {
            case ASSET_TYPE_NATIVE: {
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                decodedChangeTrustAsset.alphaNum4 = AlphaNum4.decode(stream);
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                decodedChangeTrustAsset.alphaNum12 = AlphaNum12.decode(stream);
                break;
            }
            case ASSET_TYPE_POOL_SHARE: {
                decodedChangeTrustAsset.liquidityPool = LiquidityPoolParameters.decode(stream);
            }
        }
        return decodedChangeTrustAsset;
    }

    public static ChangeTrustAsset fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ChangeTrustAsset.fromXdrByteArray(bytes);
    }

    public static ChangeTrustAsset fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ChangeTrustAsset.decode(xdrDataInputStream);
    }

    @Generated
    public static ChangeTrustAssetBuilder builder() {
        return new ChangeTrustAssetBuilder();
    }

    @Generated
    public ChangeTrustAssetBuilder toBuilder() {
        return new ChangeTrustAssetBuilder().discriminant(this.discriminant).alphaNum4(this.alphaNum4).alphaNum12(this.alphaNum12).liquidityPool(this.liquidityPool);
    }

    @Generated
    public AssetType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public AlphaNum4 getAlphaNum4() {
        return this.alphaNum4;
    }

    @Generated
    public AlphaNum12 getAlphaNum12() {
        return this.alphaNum12;
    }

    @Generated
    public LiquidityPoolParameters getLiquidityPool() {
        return this.liquidityPool;
    }

    @Generated
    public void setDiscriminant(AssetType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setAlphaNum4(AlphaNum4 alphaNum4) {
        this.alphaNum4 = alphaNum4;
    }

    @Generated
    public void setAlphaNum12(AlphaNum12 alphaNum12) {
        this.alphaNum12 = alphaNum12;
    }

    @Generated
    public void setLiquidityPool(LiquidityPoolParameters liquidityPool) {
        this.liquidityPool = liquidityPool;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeTrustAsset)) {
            return false;
        }
        ChangeTrustAsset other = (ChangeTrustAsset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AssetType this$discriminant = this.getDiscriminant();
        AssetType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        AlphaNum4 this$alphaNum4 = this.getAlphaNum4();
        AlphaNum4 other$alphaNum4 = other.getAlphaNum4();
        if (this$alphaNum4 == null ? other$alphaNum4 != null : !((Object)this$alphaNum4).equals(other$alphaNum4)) {
            return false;
        }
        AlphaNum12 this$alphaNum12 = this.getAlphaNum12();
        AlphaNum12 other$alphaNum12 = other.getAlphaNum12();
        if (this$alphaNum12 == null ? other$alphaNum12 != null : !((Object)this$alphaNum12).equals(other$alphaNum12)) {
            return false;
        }
        LiquidityPoolParameters this$liquidityPool = this.getLiquidityPool();
        LiquidityPoolParameters other$liquidityPool = other.getLiquidityPool();
        return !(this$liquidityPool == null ? other$liquidityPool != null : !((Object)this$liquidityPool).equals(other$liquidityPool));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeTrustAsset;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AssetType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        AlphaNum4 $alphaNum4 = this.getAlphaNum4();
        result = result * 59 + ($alphaNum4 == null ? 43 : ((Object)$alphaNum4).hashCode());
        AlphaNum12 $alphaNum12 = this.getAlphaNum12();
        result = result * 59 + ($alphaNum12 == null ? 43 : ((Object)$alphaNum12).hashCode());
        LiquidityPoolParameters $liquidityPool = this.getLiquidityPool();
        result = result * 59 + ($liquidityPool == null ? 43 : ((Object)$liquidityPool).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ChangeTrustAsset(discriminant=" + this.getDiscriminant() + ", alphaNum4=" + this.getAlphaNum4() + ", alphaNum12=" + this.getAlphaNum12() + ", liquidityPool=" + this.getLiquidityPool() + ")";
    }

    @Generated
    public ChangeTrustAsset() {
    }

    @Generated
    public ChangeTrustAsset(AssetType discriminant, AlphaNum4 alphaNum4, AlphaNum12 alphaNum12, LiquidityPoolParameters liquidityPool) {
        this.discriminant = discriminant;
        this.alphaNum4 = alphaNum4;
        this.alphaNum12 = alphaNum12;
        this.liquidityPool = liquidityPool;
    }

    @Generated
    public static class ChangeTrustAssetBuilder {
        @Generated
        private AssetType discriminant;
        @Generated
        private AlphaNum4 alphaNum4;
        @Generated
        private AlphaNum12 alphaNum12;
        @Generated
        private LiquidityPoolParameters liquidityPool;

        @Generated
        ChangeTrustAssetBuilder() {
        }

        @Generated
        public ChangeTrustAssetBuilder discriminant(AssetType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public ChangeTrustAssetBuilder alphaNum4(AlphaNum4 alphaNum4) {
            this.alphaNum4 = alphaNum4;
            return this;
        }

        @Generated
        public ChangeTrustAssetBuilder alphaNum12(AlphaNum12 alphaNum12) {
            this.alphaNum12 = alphaNum12;
            return this;
        }

        @Generated
        public ChangeTrustAssetBuilder liquidityPool(LiquidityPoolParameters liquidityPool) {
            this.liquidityPool = liquidityPool;
            return this;
        }

        @Generated
        public ChangeTrustAsset build() {
            return new ChangeTrustAsset(this.discriminant, this.alphaNum4, this.alphaNum12, this.liquidityPool);
        }

        @Generated
        public String toString() {
            return "ChangeTrustAsset.ChangeTrustAssetBuilder(discriminant=" + this.discriminant + ", alphaNum4=" + this.alphaNum4 + ", alphaNum12=" + this.alphaNum12 + ", liquidityPool=" + this.liquidityPool + ")";
        }
    }
}

