/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ContractExecutable;
import org.stellar.sdk.xdr.ContractIDPreimage;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class CreateContractArgsV2
implements XdrElement {
    private ContractIDPreimage contractIDPreimage;
    private ContractExecutable executable;
    private SCVal[] constructorArgs;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.contractIDPreimage.encode(stream);
        this.executable.encode(stream);
        int constructorArgsSize = this.getConstructorArgs().length;
        stream.writeInt(constructorArgsSize);
        for (int i = 0; i < constructorArgsSize; ++i) {
            this.constructorArgs[i].encode(stream);
        }
    }

    public static CreateContractArgsV2 decode(XdrDataInputStream stream) throws IOException {
        CreateContractArgsV2 decodedCreateContractArgsV2 = new CreateContractArgsV2();
        decodedCreateContractArgsV2.contractIDPreimage = ContractIDPreimage.decode(stream);
        decodedCreateContractArgsV2.executable = ContractExecutable.decode(stream);
        int constructorArgsSize = stream.readInt();
        decodedCreateContractArgsV2.constructorArgs = new SCVal[constructorArgsSize];
        for (int i = 0; i < constructorArgsSize; ++i) {
            decodedCreateContractArgsV2.constructorArgs[i] = SCVal.decode(stream);
        }
        return decodedCreateContractArgsV2;
    }

    public static CreateContractArgsV2 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return CreateContractArgsV2.fromXdrByteArray(bytes);
    }

    public static CreateContractArgsV2 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return CreateContractArgsV2.decode(xdrDataInputStream);
    }

    @Generated
    public static CreateContractArgsV2Builder builder() {
        return new CreateContractArgsV2Builder();
    }

    @Generated
    public CreateContractArgsV2Builder toBuilder() {
        return new CreateContractArgsV2Builder().contractIDPreimage(this.contractIDPreimage).executable(this.executable).constructorArgs(this.constructorArgs);
    }

    @Generated
    public ContractIDPreimage getContractIDPreimage() {
        return this.contractIDPreimage;
    }

    @Generated
    public ContractExecutable getExecutable() {
        return this.executable;
    }

    @Generated
    public SCVal[] getConstructorArgs() {
        return this.constructorArgs;
    }

    @Generated
    public void setContractIDPreimage(ContractIDPreimage contractIDPreimage) {
        this.contractIDPreimage = contractIDPreimage;
    }

    @Generated
    public void setExecutable(ContractExecutable executable) {
        this.executable = executable;
    }

    @Generated
    public void setConstructorArgs(SCVal[] constructorArgs) {
        this.constructorArgs = constructorArgs;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateContractArgsV2)) {
            return false;
        }
        CreateContractArgsV2 other = (CreateContractArgsV2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ContractIDPreimage this$contractIDPreimage = this.getContractIDPreimage();
        ContractIDPreimage other$contractIDPreimage = other.getContractIDPreimage();
        if (this$contractIDPreimage == null ? other$contractIDPreimage != null : !((Object)this$contractIDPreimage).equals(other$contractIDPreimage)) {
            return false;
        }
        ContractExecutable this$executable = this.getExecutable();
        ContractExecutable other$executable = other.getExecutable();
        if (this$executable == null ? other$executable != null : !((Object)this$executable).equals(other$executable)) {
            return false;
        }
        return Arrays.deepEquals(this.getConstructorArgs(), other.getConstructorArgs());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateContractArgsV2;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContractIDPreimage $contractIDPreimage = this.getContractIDPreimage();
        result = result * 59 + ($contractIDPreimage == null ? 43 : ((Object)$contractIDPreimage).hashCode());
        ContractExecutable $executable = this.getExecutable();
        result = result * 59 + ($executable == null ? 43 : ((Object)$executable).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getConstructorArgs());
        return result;
    }

    @Generated
    public String toString() {
        return "CreateContractArgsV2(contractIDPreimage=" + this.getContractIDPreimage() + ", executable=" + this.getExecutable() + ", constructorArgs=" + Arrays.deepToString(this.getConstructorArgs()) + ")";
    }

    @Generated
    public CreateContractArgsV2() {
    }

    @Generated
    public CreateContractArgsV2(ContractIDPreimage contractIDPreimage, ContractExecutable executable, SCVal[] constructorArgs) {
        this.contractIDPreimage = contractIDPreimage;
        this.executable = executable;
        this.constructorArgs = constructorArgs;
    }

    @Generated
    public static class CreateContractArgsV2Builder {
        @Generated
        private ContractIDPreimage contractIDPreimage;
        @Generated
        private ContractExecutable executable;
        @Generated
        private SCVal[] constructorArgs;

        @Generated
        CreateContractArgsV2Builder() {
        }

        @Generated
        public CreateContractArgsV2Builder contractIDPreimage(ContractIDPreimage contractIDPreimage) {
            this.contractIDPreimage = contractIDPreimage;
            return this;
        }

        @Generated
        public CreateContractArgsV2Builder executable(ContractExecutable executable) {
            this.executable = executable;
            return this;
        }

        @Generated
        public CreateContractArgsV2Builder constructorArgs(SCVal[] constructorArgs) {
            this.constructorArgs = constructorArgs;
            return this;
        }

        @Generated
        public CreateContractArgsV2 build() {
            return new CreateContractArgsV2(this.contractIDPreimage, this.executable, this.constructorArgs);
        }

        @Generated
        public String toString() {
            return "CreateContractArgsV2.CreateContractArgsV2Builder(contractIDPreimage=" + this.contractIDPreimage + ", executable=" + this.executable + ", constructorArgs=" + Arrays.deepToString(this.constructorArgs) + ")";
        }
    }
}

