/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCAddress;
import org.stellar.sdk.xdr.SCSymbol;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class InvokeContractArgs
implements XdrElement {
    private SCAddress contractAddress;
    private SCSymbol functionName;
    private SCVal[] args;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.contractAddress.encode(stream);
        this.functionName.encode(stream);
        int argsSize = this.getArgs().length;
        stream.writeInt(argsSize);
        for (int i = 0; i < argsSize; ++i) {
            this.args[i].encode(stream);
        }
    }

    public static InvokeContractArgs decode(XdrDataInputStream stream) throws IOException {
        InvokeContractArgs decodedInvokeContractArgs = new InvokeContractArgs();
        decodedInvokeContractArgs.contractAddress = SCAddress.decode(stream);
        decodedInvokeContractArgs.functionName = SCSymbol.decode(stream);
        int argsSize = stream.readInt();
        decodedInvokeContractArgs.args = new SCVal[argsSize];
        for (int i = 0; i < argsSize; ++i) {
            decodedInvokeContractArgs.args[i] = SCVal.decode(stream);
        }
        return decodedInvokeContractArgs;
    }

    public static InvokeContractArgs fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return InvokeContractArgs.fromXdrByteArray(bytes);
    }

    public static InvokeContractArgs fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return InvokeContractArgs.decode(xdrDataInputStream);
    }

    @Generated
    public static InvokeContractArgsBuilder builder() {
        return new InvokeContractArgsBuilder();
    }

    @Generated
    public InvokeContractArgsBuilder toBuilder() {
        return new InvokeContractArgsBuilder().contractAddress(this.contractAddress).functionName(this.functionName).args(this.args);
    }

    @Generated
    public SCAddress getContractAddress() {
        return this.contractAddress;
    }

    @Generated
    public SCSymbol getFunctionName() {
        return this.functionName;
    }

    @Generated
    public SCVal[] getArgs() {
        return this.args;
    }

    @Generated
    public void setContractAddress(SCAddress contractAddress) {
        this.contractAddress = contractAddress;
    }

    @Generated
    public void setFunctionName(SCSymbol functionName) {
        this.functionName = functionName;
    }

    @Generated
    public void setArgs(SCVal[] args2) {
        this.args = args2;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvokeContractArgs)) {
            return false;
        }
        InvokeContractArgs other = (InvokeContractArgs)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SCAddress this$contractAddress = this.getContractAddress();
        SCAddress other$contractAddress = other.getContractAddress();
        if (this$contractAddress == null ? other$contractAddress != null : !((Object)this$contractAddress).equals(other$contractAddress)) {
            return false;
        }
        SCSymbol this$functionName = this.getFunctionName();
        SCSymbol other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !((Object)this$functionName).equals(other$functionName)) {
            return false;
        }
        return Arrays.deepEquals(this.getArgs(), other.getArgs());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InvokeContractArgs;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SCAddress $contractAddress = this.getContractAddress();
        result = result * 59 + ($contractAddress == null ? 43 : ((Object)$contractAddress).hashCode());
        SCSymbol $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : ((Object)$functionName).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArgs());
        return result;
    }

    @Generated
    public String toString() {
        return "InvokeContractArgs(contractAddress=" + this.getContractAddress() + ", functionName=" + this.getFunctionName() + ", args=" + Arrays.deepToString(this.getArgs()) + ")";
    }

    @Generated
    public InvokeContractArgs() {
    }

    @Generated
    public InvokeContractArgs(SCAddress contractAddress, SCSymbol functionName, SCVal[] args2) {
        this.contractAddress = contractAddress;
        this.functionName = functionName;
        this.args = args2;
    }

    @Generated
    public static class InvokeContractArgsBuilder {
        @Generated
        private SCAddress contractAddress;
        @Generated
        private SCSymbol functionName;
        @Generated
        private SCVal[] args;

        @Generated
        InvokeContractArgsBuilder() {
        }

        @Generated
        public InvokeContractArgsBuilder contractAddress(SCAddress contractAddress) {
            this.contractAddress = contractAddress;
            return this;
        }

        @Generated
        public InvokeContractArgsBuilder functionName(SCSymbol functionName) {
            this.functionName = functionName;
            return this;
        }

        @Generated
        public InvokeContractArgsBuilder args(SCVal[] args2) {
            this.args = args2;
            return this;
        }

        @Generated
        public InvokeContractArgs build() {
            return new InvokeContractArgs(this.contractAddress, this.functionName, this.args);
        }

        @Generated
        public String toString() {
            return "InvokeContractArgs.InvokeContractArgsBuilder(contractAddress=" + this.contractAddress + ", functionName=" + this.functionName + ", args=" + Arrays.deepToString(this.args) + ")";
        }
    }
}

