/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class PaymentOp
implements XdrElement {
    private MuxedAccount destination;
    private Asset asset;
    private Int64 amount;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.destination.encode(stream);
        this.asset.encode(stream);
        this.amount.encode(stream);
    }

    public static PaymentOp decode(XdrDataInputStream stream) throws IOException {
        PaymentOp decodedPaymentOp = new PaymentOp();
        decodedPaymentOp.destination = MuxedAccount.decode(stream);
        decodedPaymentOp.asset = Asset.decode(stream);
        decodedPaymentOp.amount = Int64.decode(stream);
        return decodedPaymentOp;
    }

    public static PaymentOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PaymentOp.fromXdrByteArray(bytes);
    }

    public static PaymentOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PaymentOp.decode(xdrDataInputStream);
    }

    @Generated
    public static PaymentOpBuilder builder() {
        return new PaymentOpBuilder();
    }

    @Generated
    public PaymentOpBuilder toBuilder() {
        return new PaymentOpBuilder().destination(this.destination).asset(this.asset).amount(this.amount);
    }

    @Generated
    public MuxedAccount getDestination() {
        return this.destination;
    }

    @Generated
    public Asset getAsset() {
        return this.asset;
    }

    @Generated
    public Int64 getAmount() {
        return this.amount;
    }

    @Generated
    public void setDestination(MuxedAccount destination) {
        this.destination = destination;
    }

    @Generated
    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    @Generated
    public void setAmount(Int64 amount) {
        this.amount = amount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentOp)) {
            return false;
        }
        PaymentOp other = (PaymentOp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MuxedAccount this$destination = this.getDestination();
        MuxedAccount other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !((Object)this$destination).equals(other$destination)) {
            return false;
        }
        Asset this$asset = this.getAsset();
        Asset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        Int64 this$amount = this.getAmount();
        Int64 other$amount = other.getAmount();
        return !(this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentOp;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MuxedAccount $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : ((Object)$destination).hashCode());
        Asset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
        Int64 $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PaymentOp(destination=" + this.getDestination() + ", asset=" + this.getAsset() + ", amount=" + this.getAmount() + ")";
    }

    @Generated
    public PaymentOp() {
    }

    @Generated
    public PaymentOp(MuxedAccount destination, Asset asset, Int64 amount) {
        this.destination = destination;
        this.asset = asset;
        this.amount = amount;
    }

    @Generated
    public static class PaymentOpBuilder {
        @Generated
        private MuxedAccount destination;
        @Generated
        private Asset asset;
        @Generated
        private Int64 amount;

        @Generated
        PaymentOpBuilder() {
        }

        @Generated
        public PaymentOpBuilder destination(MuxedAccount destination) {
            this.destination = destination;
            return this;
        }

        @Generated
        public PaymentOpBuilder asset(Asset asset) {
            this.asset = asset;
            return this;
        }

        @Generated
        public PaymentOpBuilder amount(Int64 amount) {
            this.amount = amount;
            return this;
        }

        @Generated
        public PaymentOp build() {
            return new PaymentOp(this.destination, this.asset, this.amount);
        }

        @Generated
        public String toString() {
            return "PaymentOp.PaymentOpBuilder(destination=" + this.destination + ", asset=" + this.asset + ", amount=" + this.amount + ")";
        }
    }
}

