/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.IPAddrType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class PeerAddress
implements XdrElement {
    private PeerAddressIp ip;
    private Uint32 port;
    private Uint32 numFailures;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ip.encode(stream);
        this.port.encode(stream);
        this.numFailures.encode(stream);
    }

    public static PeerAddress decode(XdrDataInputStream stream) throws IOException {
        PeerAddress decodedPeerAddress = new PeerAddress();
        decodedPeerAddress.ip = PeerAddressIp.decode(stream);
        decodedPeerAddress.port = Uint32.decode(stream);
        decodedPeerAddress.numFailures = Uint32.decode(stream);
        return decodedPeerAddress;
    }

    public static PeerAddress fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PeerAddress.fromXdrByteArray(bytes);
    }

    public static PeerAddress fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PeerAddress.decode(xdrDataInputStream);
    }

    @Generated
    public static PeerAddressBuilder builder() {
        return new PeerAddressBuilder();
    }

    @Generated
    public PeerAddressBuilder toBuilder() {
        return new PeerAddressBuilder().ip(this.ip).port(this.port).numFailures(this.numFailures);
    }

    @Generated
    public PeerAddressIp getIp() {
        return this.ip;
    }

    @Generated
    public Uint32 getPort() {
        return this.port;
    }

    @Generated
    public Uint32 getNumFailures() {
        return this.numFailures;
    }

    @Generated
    public void setIp(PeerAddressIp ip) {
        this.ip = ip;
    }

    @Generated
    public void setPort(Uint32 port) {
        this.port = port;
    }

    @Generated
    public void setNumFailures(Uint32 numFailures) {
        this.numFailures = numFailures;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PeerAddress)) {
            return false;
        }
        PeerAddress other = (PeerAddress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PeerAddressIp this$ip = this.getIp();
        PeerAddressIp other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !((Object)this$ip).equals(other$ip)) {
            return false;
        }
        Uint32 this$port = this.getPort();
        Uint32 other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Uint32 this$numFailures = this.getNumFailures();
        Uint32 other$numFailures = other.getNumFailures();
        return !(this$numFailures == null ? other$numFailures != null : !((Object)this$numFailures).equals(other$numFailures));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PeerAddress;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PeerAddressIp $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : ((Object)$ip).hashCode());
        Uint32 $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Uint32 $numFailures = this.getNumFailures();
        result = result * 59 + ($numFailures == null ? 43 : ((Object)$numFailures).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PeerAddress(ip=" + this.getIp() + ", port=" + this.getPort() + ", numFailures=" + this.getNumFailures() + ")";
    }

    @Generated
    public PeerAddress() {
    }

    @Generated
    public PeerAddress(PeerAddressIp ip, Uint32 port, Uint32 numFailures) {
        this.ip = ip;
        this.port = port;
        this.numFailures = numFailures;
    }

    public static class PeerAddressIp
    implements XdrElement {
        private IPAddrType discriminant;
        private byte[] ipv4;
        private byte[] ipv6;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant.getValue());
            switch (this.discriminant) {
                case IPv4: {
                    int ipv4Size = this.ipv4.length;
                    stream.write(this.getIpv4(), 0, ipv4Size);
                    break;
                }
                case IPv6: {
                    int ipv6Size = this.ipv6.length;
                    stream.write(this.getIpv6(), 0, ipv6Size);
                }
            }
        }

        public static PeerAddressIp decode(XdrDataInputStream stream) throws IOException {
            PeerAddressIp decodedPeerAddressIp = new PeerAddressIp();
            IPAddrType discriminant = IPAddrType.decode(stream);
            decodedPeerAddressIp.setDiscriminant(discriminant);
            switch (decodedPeerAddressIp.getDiscriminant()) {
                case IPv4: {
                    int ipv4Size = 4;
                    decodedPeerAddressIp.ipv4 = new byte[ipv4Size];
                    stream.read(decodedPeerAddressIp.ipv4, 0, ipv4Size);
                    break;
                }
                case IPv6: {
                    int ipv6Size = 16;
                    decodedPeerAddressIp.ipv6 = new byte[ipv6Size];
                    stream.read(decodedPeerAddressIp.ipv6, 0, ipv6Size);
                }
            }
            return decodedPeerAddressIp;
        }

        public static PeerAddressIp fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return PeerAddressIp.fromXdrByteArray(bytes);
        }

        public static PeerAddressIp fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return PeerAddressIp.decode(xdrDataInputStream);
        }

        @Generated
        public static PeerAddressIpBuilder builder() {
            return new PeerAddressIpBuilder();
        }

        @Generated
        public PeerAddressIpBuilder toBuilder() {
            return new PeerAddressIpBuilder().discriminant(this.discriminant).ipv4(this.ipv4).ipv6(this.ipv6);
        }

        @Generated
        public IPAddrType getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public byte[] getIpv4() {
            return this.ipv4;
        }

        @Generated
        public byte[] getIpv6() {
            return this.ipv6;
        }

        @Generated
        public void setDiscriminant(IPAddrType discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setIpv4(byte[] ipv4) {
            this.ipv4 = ipv4;
        }

        @Generated
        public void setIpv6(byte[] ipv6) {
            this.ipv6 = ipv6;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PeerAddressIp)) {
                return false;
            }
            PeerAddressIp other = (PeerAddressIp)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IPAddrType this$discriminant = this.getDiscriminant();
            IPAddrType other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
                return false;
            }
            if (!Arrays.equals(this.getIpv4(), other.getIpv4())) {
                return false;
            }
            return Arrays.equals(this.getIpv6(), other.getIpv6());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PeerAddressIp;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IPAddrType $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
            result = result * 59 + Arrays.hashCode(this.getIpv4());
            result = result * 59 + Arrays.hashCode(this.getIpv6());
            return result;
        }

        @Generated
        public String toString() {
            return "PeerAddress.PeerAddressIp(discriminant=" + this.getDiscriminant() + ", ipv4=" + Arrays.toString(this.getIpv4()) + ", ipv6=" + Arrays.toString(this.getIpv6()) + ")";
        }

        @Generated
        public PeerAddressIp() {
        }

        @Generated
        public PeerAddressIp(IPAddrType discriminant, byte[] ipv4, byte[] ipv6) {
            this.discriminant = discriminant;
            this.ipv4 = ipv4;
            this.ipv6 = ipv6;
        }

        @Generated
        public static class PeerAddressIpBuilder {
            @Generated
            private IPAddrType discriminant;
            @Generated
            private byte[] ipv4;
            @Generated
            private byte[] ipv6;

            @Generated
            PeerAddressIpBuilder() {
            }

            @Generated
            public PeerAddressIpBuilder discriminant(IPAddrType discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public PeerAddressIpBuilder ipv4(byte[] ipv4) {
                this.ipv4 = ipv4;
                return this;
            }

            @Generated
            public PeerAddressIpBuilder ipv6(byte[] ipv6) {
                this.ipv6 = ipv6;
                return this;
            }

            @Generated
            public PeerAddressIp build() {
                return new PeerAddressIp(this.discriminant, this.ipv4, this.ipv6);
            }

            @Generated
            public String toString() {
                return "PeerAddress.PeerAddressIp.PeerAddressIpBuilder(discriminant=" + this.discriminant + ", ipv4=" + Arrays.toString(this.ipv4) + ", ipv6=" + Arrays.toString(this.ipv6) + ")";
            }
        }
    }

    @Generated
    public static class PeerAddressBuilder {
        @Generated
        private PeerAddressIp ip;
        @Generated
        private Uint32 port;
        @Generated
        private Uint32 numFailures;

        @Generated
        PeerAddressBuilder() {
        }

        @Generated
        public PeerAddressBuilder ip(PeerAddressIp ip) {
            this.ip = ip;
            return this;
        }

        @Generated
        public PeerAddressBuilder port(Uint32 port) {
            this.port = port;
            return this;
        }

        @Generated
        public PeerAddressBuilder numFailures(Uint32 numFailures) {
            this.numFailures = numFailures;
            return this;
        }

        @Generated
        public PeerAddress build() {
            return new PeerAddress(this.ip, this.port, this.numFailures);
        }

        @Generated
        public String toString() {
            return "PeerAddress.PeerAddressBuilder(ip=" + this.ip + ", port=" + this.port + ", numFailures=" + this.numFailures + ")";
        }
    }
}

