/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerEntryChanges;
import org.stellar.sdk.xdr.TransactionMeta;
import org.stellar.sdk.xdr.TransactionResultPair;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionResultMeta
implements XdrElement {
    private TransactionResultPair result;
    private LedgerEntryChanges feeProcessing;
    private TransactionMeta txApplyProcessing;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.result.encode(stream);
        this.feeProcessing.encode(stream);
        this.txApplyProcessing.encode(stream);
    }

    public static TransactionResultMeta decode(XdrDataInputStream stream) throws IOException {
        TransactionResultMeta decodedTransactionResultMeta = new TransactionResultMeta();
        decodedTransactionResultMeta.result = TransactionResultPair.decode(stream);
        decodedTransactionResultMeta.feeProcessing = LedgerEntryChanges.decode(stream);
        decodedTransactionResultMeta.txApplyProcessing = TransactionMeta.decode(stream);
        return decodedTransactionResultMeta;
    }

    public static TransactionResultMeta fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionResultMeta.fromXdrByteArray(bytes);
    }

    public static TransactionResultMeta fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionResultMeta.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionResultMetaBuilder builder() {
        return new TransactionResultMetaBuilder();
    }

    @Generated
    public TransactionResultMetaBuilder toBuilder() {
        return new TransactionResultMetaBuilder().result(this.result).feeProcessing(this.feeProcessing).txApplyProcessing(this.txApplyProcessing);
    }

    @Generated
    public TransactionResultPair getResult() {
        return this.result;
    }

    @Generated
    public LedgerEntryChanges getFeeProcessing() {
        return this.feeProcessing;
    }

    @Generated
    public TransactionMeta getTxApplyProcessing() {
        return this.txApplyProcessing;
    }

    @Generated
    public void setResult(TransactionResultPair result) {
        this.result = result;
    }

    @Generated
    public void setFeeProcessing(LedgerEntryChanges feeProcessing) {
        this.feeProcessing = feeProcessing;
    }

    @Generated
    public void setTxApplyProcessing(TransactionMeta txApplyProcessing) {
        this.txApplyProcessing = txApplyProcessing;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionResultMeta)) {
            return false;
        }
        TransactionResultMeta other = (TransactionResultMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TransactionResultPair this$result = this.getResult();
        TransactionResultPair other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
            return false;
        }
        LedgerEntryChanges this$feeProcessing = this.getFeeProcessing();
        LedgerEntryChanges other$feeProcessing = other.getFeeProcessing();
        if (this$feeProcessing == null ? other$feeProcessing != null : !((Object)this$feeProcessing).equals(other$feeProcessing)) {
            return false;
        }
        TransactionMeta this$txApplyProcessing = this.getTxApplyProcessing();
        TransactionMeta other$txApplyProcessing = other.getTxApplyProcessing();
        return !(this$txApplyProcessing == null ? other$txApplyProcessing != null : !((Object)this$txApplyProcessing).equals(other$txApplyProcessing));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionResultMeta;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TransactionResultPair $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        LedgerEntryChanges $feeProcessing = this.getFeeProcessing();
        result = result * 59 + ($feeProcessing == null ? 43 : ((Object)$feeProcessing).hashCode());
        TransactionMeta $txApplyProcessing = this.getTxApplyProcessing();
        result = result * 59 + ($txApplyProcessing == null ? 43 : ((Object)$txApplyProcessing).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionResultMeta(result=" + this.getResult() + ", feeProcessing=" + this.getFeeProcessing() + ", txApplyProcessing=" + this.getTxApplyProcessing() + ")";
    }

    @Generated
    public TransactionResultMeta() {
    }

    @Generated
    public TransactionResultMeta(TransactionResultPair result, LedgerEntryChanges feeProcessing, TransactionMeta txApplyProcessing) {
        this.result = result;
        this.feeProcessing = feeProcessing;
        this.txApplyProcessing = txApplyProcessing;
    }

    @Generated
    public static class TransactionResultMetaBuilder {
        @Generated
        private TransactionResultPair result;
        @Generated
        private LedgerEntryChanges feeProcessing;
        @Generated
        private TransactionMeta txApplyProcessing;

        @Generated
        TransactionResultMetaBuilder() {
        }

        @Generated
        public TransactionResultMetaBuilder result(TransactionResultPair result) {
            this.result = result;
            return this;
        }

        @Generated
        public TransactionResultMetaBuilder feeProcessing(LedgerEntryChanges feeProcessing) {
            this.feeProcessing = feeProcessing;
            return this;
        }

        @Generated
        public TransactionResultMetaBuilder txApplyProcessing(TransactionMeta txApplyProcessing) {
            this.txApplyProcessing = txApplyProcessing;
            return this;
        }

        @Generated
        public TransactionResultMeta build() {
            return new TransactionResultMeta(this.result, this.feeProcessing, this.txApplyProcessing);
        }

        @Generated
        public String toString() {
            return "TransactionResultMeta.TransactionResultMetaBuilder(result=" + this.result + ", feeProcessing=" + this.feeProcessing + ", txApplyProcessing=" + this.txApplyProcessing + ")";
        }
    }
}

