/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Uint256
implements XdrElement {
    private byte[] uint256;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        int uint256Size = this.uint256.length;
        stream.write(this.getUint256(), 0, uint256Size);
    }

    public static Uint256 decode(XdrDataInputStream stream) throws IOException {
        Uint256 decodedUint256 = new Uint256();
        int uint256Size = 32;
        decodedUint256.uint256 = new byte[uint256Size];
        stream.read(decodedUint256.uint256, 0, uint256Size);
        return decodedUint256;
    }

    public static Uint256 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Uint256.fromXdrByteArray(bytes);
    }

    public static Uint256 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Uint256.decode(xdrDataInputStream);
    }

    @Generated
    public byte[] getUint256() {
        return this.uint256;
    }

    @Generated
    public void setUint256(byte[] uint256) {
        this.uint256 = uint256;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Uint256)) {
            return false;
        }
        Uint256 other = (Uint256)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getUint256(), other.getUint256());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Uint256;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getUint256());
        return result;
    }

    @Generated
    public String toString() {
        return "Uint256(uint256=" + Arrays.toString(this.getUint256()) + ")";
    }

    @Generated
    public Uint256() {
    }

    @Generated
    public Uint256(byte[] uint256) {
        this.uint256 = uint256;
    }
}

