/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.GeneralizedTransactionSet;
import org.stellar.sdk.xdr.LedgerCloseMetaExt;
import org.stellar.sdk.xdr.LedgerEntry;
import org.stellar.sdk.xdr.LedgerHeaderHistoryEntry;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.SCPHistoryEntry;
import org.stellar.sdk.xdr.TransactionResultMeta;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.UpgradeEntryMeta;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class LedgerCloseMetaV1
implements XdrElement {
    private LedgerCloseMetaExt ext;
    private LedgerHeaderHistoryEntry ledgerHeader;
    private GeneralizedTransactionSet txSet;
    private TransactionResultMeta[] txProcessing;
    private UpgradeEntryMeta[] upgradesProcessing;
    private SCPHistoryEntry[] scpInfo;
    private Uint64 totalByteSizeOfBucketList;
    private LedgerKey[] evictedTemporaryLedgerKeys;
    private LedgerEntry[] evictedPersistentLedgerEntries;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ext.encode(stream);
        this.ledgerHeader.encode(stream);
        this.txSet.encode(stream);
        int txProcessingSize = this.getTxProcessing().length;
        stream.writeInt(txProcessingSize);
        for (int i = 0; i < txProcessingSize; ++i) {
            this.txProcessing[i].encode(stream);
        }
        int upgradesProcessingSize = this.getUpgradesProcessing().length;
        stream.writeInt(upgradesProcessingSize);
        for (int i = 0; i < upgradesProcessingSize; ++i) {
            this.upgradesProcessing[i].encode(stream);
        }
        int scpInfoSize = this.getScpInfo().length;
        stream.writeInt(scpInfoSize);
        for (int i = 0; i < scpInfoSize; ++i) {
            this.scpInfo[i].encode(stream);
        }
        this.totalByteSizeOfBucketList.encode(stream);
        int evictedTemporaryLedgerKeysSize = this.getEvictedTemporaryLedgerKeys().length;
        stream.writeInt(evictedTemporaryLedgerKeysSize);
        for (int i = 0; i < evictedTemporaryLedgerKeysSize; ++i) {
            this.evictedTemporaryLedgerKeys[i].encode(stream);
        }
        int evictedPersistentLedgerEntriesSize = this.getEvictedPersistentLedgerEntries().length;
        stream.writeInt(evictedPersistentLedgerEntriesSize);
        for (int i = 0; i < evictedPersistentLedgerEntriesSize; ++i) {
            this.evictedPersistentLedgerEntries[i].encode(stream);
        }
    }

    public static LedgerCloseMetaV1 decode(XdrDataInputStream stream) throws IOException {
        LedgerCloseMetaV1 decodedLedgerCloseMetaV1 = new LedgerCloseMetaV1();
        decodedLedgerCloseMetaV1.ext = LedgerCloseMetaExt.decode(stream);
        decodedLedgerCloseMetaV1.ledgerHeader = LedgerHeaderHistoryEntry.decode(stream);
        decodedLedgerCloseMetaV1.txSet = GeneralizedTransactionSet.decode(stream);
        int txProcessingSize = stream.readInt();
        decodedLedgerCloseMetaV1.txProcessing = new TransactionResultMeta[txProcessingSize];
        for (int i = 0; i < txProcessingSize; ++i) {
            decodedLedgerCloseMetaV1.txProcessing[i] = TransactionResultMeta.decode(stream);
        }
        int upgradesProcessingSize = stream.readInt();
        decodedLedgerCloseMetaV1.upgradesProcessing = new UpgradeEntryMeta[upgradesProcessingSize];
        for (int i = 0; i < upgradesProcessingSize; ++i) {
            decodedLedgerCloseMetaV1.upgradesProcessing[i] = UpgradeEntryMeta.decode(stream);
        }
        int scpInfoSize = stream.readInt();
        decodedLedgerCloseMetaV1.scpInfo = new SCPHistoryEntry[scpInfoSize];
        for (int i = 0; i < scpInfoSize; ++i) {
            decodedLedgerCloseMetaV1.scpInfo[i] = SCPHistoryEntry.decode(stream);
        }
        decodedLedgerCloseMetaV1.totalByteSizeOfBucketList = Uint64.decode(stream);
        int evictedTemporaryLedgerKeysSize = stream.readInt();
        decodedLedgerCloseMetaV1.evictedTemporaryLedgerKeys = new LedgerKey[evictedTemporaryLedgerKeysSize];
        for (int i = 0; i < evictedTemporaryLedgerKeysSize; ++i) {
            decodedLedgerCloseMetaV1.evictedTemporaryLedgerKeys[i] = LedgerKey.decode(stream);
        }
        int evictedPersistentLedgerEntriesSize = stream.readInt();
        decodedLedgerCloseMetaV1.evictedPersistentLedgerEntries = new LedgerEntry[evictedPersistentLedgerEntriesSize];
        for (int i = 0; i < evictedPersistentLedgerEntriesSize; ++i) {
            decodedLedgerCloseMetaV1.evictedPersistentLedgerEntries[i] = LedgerEntry.decode(stream);
        }
        return decodedLedgerCloseMetaV1;
    }

    public static LedgerCloseMetaV1 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return LedgerCloseMetaV1.fromXdrByteArray(bytes);
    }

    public static LedgerCloseMetaV1 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return LedgerCloseMetaV1.decode(xdrDataInputStream);
    }

    @Generated
    public static LedgerCloseMetaV1Builder builder() {
        return new LedgerCloseMetaV1Builder();
    }

    @Generated
    public LedgerCloseMetaV1Builder toBuilder() {
        return new LedgerCloseMetaV1Builder().ext(this.ext).ledgerHeader(this.ledgerHeader).txSet(this.txSet).txProcessing(this.txProcessing).upgradesProcessing(this.upgradesProcessing).scpInfo(this.scpInfo).totalByteSizeOfBucketList(this.totalByteSizeOfBucketList).evictedTemporaryLedgerKeys(this.evictedTemporaryLedgerKeys).evictedPersistentLedgerEntries(this.evictedPersistentLedgerEntries);
    }

    @Generated
    public LedgerCloseMetaExt getExt() {
        return this.ext;
    }

    @Generated
    public LedgerHeaderHistoryEntry getLedgerHeader() {
        return this.ledgerHeader;
    }

    @Generated
    public GeneralizedTransactionSet getTxSet() {
        return this.txSet;
    }

    @Generated
    public TransactionResultMeta[] getTxProcessing() {
        return this.txProcessing;
    }

    @Generated
    public UpgradeEntryMeta[] getUpgradesProcessing() {
        return this.upgradesProcessing;
    }

    @Generated
    public SCPHistoryEntry[] getScpInfo() {
        return this.scpInfo;
    }

    @Generated
    public Uint64 getTotalByteSizeOfBucketList() {
        return this.totalByteSizeOfBucketList;
    }

    @Generated
    public LedgerKey[] getEvictedTemporaryLedgerKeys() {
        return this.evictedTemporaryLedgerKeys;
    }

    @Generated
    public LedgerEntry[] getEvictedPersistentLedgerEntries() {
        return this.evictedPersistentLedgerEntries;
    }

    @Generated
    public void setExt(LedgerCloseMetaExt ext) {
        this.ext = ext;
    }

    @Generated
    public void setLedgerHeader(LedgerHeaderHistoryEntry ledgerHeader) {
        this.ledgerHeader = ledgerHeader;
    }

    @Generated
    public void setTxSet(GeneralizedTransactionSet txSet) {
        this.txSet = txSet;
    }

    @Generated
    public void setTxProcessing(TransactionResultMeta[] txProcessing) {
        this.txProcessing = txProcessing;
    }

    @Generated
    public void setUpgradesProcessing(UpgradeEntryMeta[] upgradesProcessing) {
        this.upgradesProcessing = upgradesProcessing;
    }

    @Generated
    public void setScpInfo(SCPHistoryEntry[] scpInfo) {
        this.scpInfo = scpInfo;
    }

    @Generated
    public void setTotalByteSizeOfBucketList(Uint64 totalByteSizeOfBucketList) {
        this.totalByteSizeOfBucketList = totalByteSizeOfBucketList;
    }

    @Generated
    public void setEvictedTemporaryLedgerKeys(LedgerKey[] evictedTemporaryLedgerKeys) {
        this.evictedTemporaryLedgerKeys = evictedTemporaryLedgerKeys;
    }

    @Generated
    public void setEvictedPersistentLedgerEntries(LedgerEntry[] evictedPersistentLedgerEntries) {
        this.evictedPersistentLedgerEntries = evictedPersistentLedgerEntries;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerCloseMetaV1)) {
            return false;
        }
        LedgerCloseMetaV1 other = (LedgerCloseMetaV1)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LedgerCloseMetaExt this$ext = this.getExt();
        LedgerCloseMetaExt other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext)) {
            return false;
        }
        LedgerHeaderHistoryEntry this$ledgerHeader = this.getLedgerHeader();
        LedgerHeaderHistoryEntry other$ledgerHeader = other.getLedgerHeader();
        if (this$ledgerHeader == null ? other$ledgerHeader != null : !((Object)this$ledgerHeader).equals(other$ledgerHeader)) {
            return false;
        }
        GeneralizedTransactionSet this$txSet = this.getTxSet();
        GeneralizedTransactionSet other$txSet = other.getTxSet();
        if (this$txSet == null ? other$txSet != null : !((Object)this$txSet).equals(other$txSet)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTxProcessing(), other.getTxProcessing())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getUpgradesProcessing(), other.getUpgradesProcessing())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getScpInfo(), other.getScpInfo())) {
            return false;
        }
        Uint64 this$totalByteSizeOfBucketList = this.getTotalByteSizeOfBucketList();
        Uint64 other$totalByteSizeOfBucketList = other.getTotalByteSizeOfBucketList();
        if (this$totalByteSizeOfBucketList == null ? other$totalByteSizeOfBucketList != null : !((Object)this$totalByteSizeOfBucketList).equals(other$totalByteSizeOfBucketList)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getEvictedTemporaryLedgerKeys(), other.getEvictedTemporaryLedgerKeys())) {
            return false;
        }
        return Arrays.deepEquals(this.getEvictedPersistentLedgerEntries(), other.getEvictedPersistentLedgerEntries());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LedgerCloseMetaV1;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LedgerCloseMetaExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        LedgerHeaderHistoryEntry $ledgerHeader = this.getLedgerHeader();
        result = result * 59 + ($ledgerHeader == null ? 43 : ((Object)$ledgerHeader).hashCode());
        GeneralizedTransactionSet $txSet = this.getTxSet();
        result = result * 59 + ($txSet == null ? 43 : ((Object)$txSet).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTxProcessing());
        result = result * 59 + Arrays.deepHashCode(this.getUpgradesProcessing());
        result = result * 59 + Arrays.deepHashCode(this.getScpInfo());
        Uint64 $totalByteSizeOfBucketList = this.getTotalByteSizeOfBucketList();
        result = result * 59 + ($totalByteSizeOfBucketList == null ? 43 : ((Object)$totalByteSizeOfBucketList).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getEvictedTemporaryLedgerKeys());
        result = result * 59 + Arrays.deepHashCode(this.getEvictedPersistentLedgerEntries());
        return result;
    }

    @Generated
    public String toString() {
        return "LedgerCloseMetaV1(ext=" + this.getExt() + ", ledgerHeader=" + this.getLedgerHeader() + ", txSet=" + this.getTxSet() + ", txProcessing=" + Arrays.deepToString(this.getTxProcessing()) + ", upgradesProcessing=" + Arrays.deepToString(this.getUpgradesProcessing()) + ", scpInfo=" + Arrays.deepToString(this.getScpInfo()) + ", totalByteSizeOfBucketList=" + this.getTotalByteSizeOfBucketList() + ", evictedTemporaryLedgerKeys=" + Arrays.deepToString(this.getEvictedTemporaryLedgerKeys()) + ", evictedPersistentLedgerEntries=" + Arrays.deepToString(this.getEvictedPersistentLedgerEntries()) + ")";
    }

    @Generated
    public LedgerCloseMetaV1() {
    }

    @Generated
    public LedgerCloseMetaV1(LedgerCloseMetaExt ext, LedgerHeaderHistoryEntry ledgerHeader, GeneralizedTransactionSet txSet, TransactionResultMeta[] txProcessing, UpgradeEntryMeta[] upgradesProcessing, SCPHistoryEntry[] scpInfo, Uint64 totalByteSizeOfBucketList, LedgerKey[] evictedTemporaryLedgerKeys, LedgerEntry[] evictedPersistentLedgerEntries) {
        this.ext = ext;
        this.ledgerHeader = ledgerHeader;
        this.txSet = txSet;
        this.txProcessing = txProcessing;
        this.upgradesProcessing = upgradesProcessing;
        this.scpInfo = scpInfo;
        this.totalByteSizeOfBucketList = totalByteSizeOfBucketList;
        this.evictedTemporaryLedgerKeys = evictedTemporaryLedgerKeys;
        this.evictedPersistentLedgerEntries = evictedPersistentLedgerEntries;
    }

    @Generated
    public static class LedgerCloseMetaV1Builder {
        @Generated
        private LedgerCloseMetaExt ext;
        @Generated
        private LedgerHeaderHistoryEntry ledgerHeader;
        @Generated
        private GeneralizedTransactionSet txSet;
        @Generated
        private TransactionResultMeta[] txProcessing;
        @Generated
        private UpgradeEntryMeta[] upgradesProcessing;
        @Generated
        private SCPHistoryEntry[] scpInfo;
        @Generated
        private Uint64 totalByteSizeOfBucketList;
        @Generated
        private LedgerKey[] evictedTemporaryLedgerKeys;
        @Generated
        private LedgerEntry[] evictedPersistentLedgerEntries;

        @Generated
        LedgerCloseMetaV1Builder() {
        }

        @Generated
        public LedgerCloseMetaV1Builder ext(LedgerCloseMetaExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1Builder ledgerHeader(LedgerHeaderHistoryEntry ledgerHeader) {
            this.ledgerHeader = ledgerHeader;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1Builder txSet(GeneralizedTransactionSet txSet) {
            this.txSet = txSet;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1Builder txProcessing(TransactionResultMeta[] txProcessing) {
            this.txProcessing = txProcessing;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1Builder upgradesProcessing(UpgradeEntryMeta[] upgradesProcessing) {
            this.upgradesProcessing = upgradesProcessing;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1Builder scpInfo(SCPHistoryEntry[] scpInfo) {
            this.scpInfo = scpInfo;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1Builder totalByteSizeOfBucketList(Uint64 totalByteSizeOfBucketList) {
            this.totalByteSizeOfBucketList = totalByteSizeOfBucketList;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1Builder evictedTemporaryLedgerKeys(LedgerKey[] evictedTemporaryLedgerKeys) {
            this.evictedTemporaryLedgerKeys = evictedTemporaryLedgerKeys;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1Builder evictedPersistentLedgerEntries(LedgerEntry[] evictedPersistentLedgerEntries) {
            this.evictedPersistentLedgerEntries = evictedPersistentLedgerEntries;
            return this;
        }

        @Generated
        public LedgerCloseMetaV1 build() {
            return new LedgerCloseMetaV1(this.ext, this.ledgerHeader, this.txSet, this.txProcessing, this.upgradesProcessing, this.scpInfo, this.totalByteSizeOfBucketList, this.evictedTemporaryLedgerKeys, this.evictedPersistentLedgerEntries);
        }

        @Generated
        public String toString() {
            return "LedgerCloseMetaV1.LedgerCloseMetaV1Builder(ext=" + this.ext + ", ledgerHeader=" + this.ledgerHeader + ", txSet=" + this.txSet + ", txProcessing=" + Arrays.deepToString(this.txProcessing) + ", upgradesProcessing=" + Arrays.deepToString(this.upgradesProcessing) + ", scpInfo=" + Arrays.deepToString(this.scpInfo) + ", totalByteSizeOfBucketList=" + this.totalByteSizeOfBucketList + ", evictedTemporaryLedgerKeys=" + Arrays.deepToString(this.evictedTemporaryLedgerKeys) + ", evictedPersistentLedgerEntries=" + Arrays.deepToString(this.evictedPersistentLedgerEntries) + ")";
        }
    }
}

