/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.MemoType;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import org.stellar.sdk.xdr.XdrString;

public class Memo
implements XdrElement {
    private MemoType discriminant;
    private XdrString text;
    private Uint64 id;
    private Hash hash;
    private Hash retHash;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case MEMO_NONE: {
                break;
            }
            case MEMO_TEXT: {
                this.text.encode(stream);
                break;
            }
            case MEMO_ID: {
                this.id.encode(stream);
                break;
            }
            case MEMO_HASH: {
                this.hash.encode(stream);
                break;
            }
            case MEMO_RETURN: {
                this.retHash.encode(stream);
            }
        }
    }

    public static Memo decode(XdrDataInputStream stream) throws IOException {
        Memo decodedMemo = new Memo();
        MemoType discriminant = MemoType.decode(stream);
        decodedMemo.setDiscriminant(discriminant);
        switch (decodedMemo.getDiscriminant()) {
            case MEMO_NONE: {
                break;
            }
            case MEMO_TEXT: {
                decodedMemo.text = XdrString.decode(stream, 28);
                break;
            }
            case MEMO_ID: {
                decodedMemo.id = Uint64.decode(stream);
                break;
            }
            case MEMO_HASH: {
                decodedMemo.hash = Hash.decode(stream);
                break;
            }
            case MEMO_RETURN: {
                decodedMemo.retHash = Hash.decode(stream);
            }
        }
        return decodedMemo;
    }

    public static Memo fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Memo.fromXdrByteArray(bytes);
    }

    public static Memo fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Memo.decode(xdrDataInputStream);
    }

    @Generated
    public static MemoBuilder builder() {
        return new MemoBuilder();
    }

    @Generated
    public MemoBuilder toBuilder() {
        return new MemoBuilder().discriminant(this.discriminant).text(this.text).id(this.id).hash(this.hash).retHash(this.retHash);
    }

    @Generated
    public MemoType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public XdrString getText() {
        return this.text;
    }

    @Generated
    public Uint64 getId() {
        return this.id;
    }

    @Generated
    public Hash getHash() {
        return this.hash;
    }

    @Generated
    public Hash getRetHash() {
        return this.retHash;
    }

    @Generated
    public void setDiscriminant(MemoType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setText(XdrString text) {
        this.text = text;
    }

    @Generated
    public void setId(Uint64 id) {
        this.id = id;
    }

    @Generated
    public void setHash(Hash hash) {
        this.hash = hash;
    }

    @Generated
    public void setRetHash(Hash retHash) {
        this.retHash = retHash;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Memo)) {
            return false;
        }
        Memo other = (Memo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MemoType this$discriminant = this.getDiscriminant();
        MemoType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        XdrString this$text = this.getText();
        XdrString other$text = other.getText();
        if (this$text == null ? other$text != null : !((Object)this$text).equals(other$text)) {
            return false;
        }
        Uint64 this$id = this.getId();
        Uint64 other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Hash this$hash = this.getHash();
        Hash other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !((Object)this$hash).equals(other$hash)) {
            return false;
        }
        Hash this$retHash = this.getRetHash();
        Hash other$retHash = other.getRetHash();
        return !(this$retHash == null ? other$retHash != null : !((Object)this$retHash).equals(other$retHash));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Memo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MemoType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        XdrString $text = this.getText();
        result = result * 59 + ($text == null ? 43 : ((Object)$text).hashCode());
        Uint64 $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Hash $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : ((Object)$hash).hashCode());
        Hash $retHash = this.getRetHash();
        result = result * 59 + ($retHash == null ? 43 : ((Object)$retHash).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Memo(discriminant=" + this.getDiscriminant() + ", text=" + this.getText() + ", id=" + this.getId() + ", hash=" + this.getHash() + ", retHash=" + this.getRetHash() + ")";
    }

    @Generated
    public Memo() {
    }

    @Generated
    public Memo(MemoType discriminant, XdrString text, Uint64 id, Hash hash, Hash retHash) {
        this.discriminant = discriminant;
        this.text = text;
        this.id = id;
        this.hash = hash;
        this.retHash = retHash;
    }

    @Generated
    public static class MemoBuilder {
        @Generated
        private MemoType discriminant;
        @Generated
        private XdrString text;
        @Generated
        private Uint64 id;
        @Generated
        private Hash hash;
        @Generated
        private Hash retHash;

        @Generated
        MemoBuilder() {
        }

        @Generated
        public MemoBuilder discriminant(MemoType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public MemoBuilder text(XdrString text) {
            this.text = text;
            return this;
        }

        @Generated
        public MemoBuilder id(Uint64 id) {
            this.id = id;
            return this;
        }

        @Generated
        public MemoBuilder hash(Hash hash) {
            this.hash = hash;
            return this;
        }

        @Generated
        public MemoBuilder retHash(Hash retHash) {
            this.retHash = retHash;
            return this;
        }

        @Generated
        public Memo build() {
            return new Memo(this.discriminant, this.text, this.id, this.hash, this.retHash);
        }

        @Generated
        public String toString() {
            return "Memo.MemoBuilder(discriminant=" + this.discriminant + ", text=" + this.text + ", id=" + this.id + ", hash=" + this.hash + ", retHash=" + this.retHash + ")";
        }
    }
}

