/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.NodeID;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import org.stellar.sdk.xdr.XdrString;

public class PeerStats
implements XdrElement {
    private NodeID id;
    private XdrString versionStr;
    private Uint64 messagesRead;
    private Uint64 messagesWritten;
    private Uint64 bytesRead;
    private Uint64 bytesWritten;
    private Uint64 secondsConnected;
    private Uint64 uniqueFloodBytesRecv;
    private Uint64 duplicateFloodBytesRecv;
    private Uint64 uniqueFetchBytesRecv;
    private Uint64 duplicateFetchBytesRecv;
    private Uint64 uniqueFloodMessageRecv;
    private Uint64 duplicateFloodMessageRecv;
    private Uint64 uniqueFetchMessageRecv;
    private Uint64 duplicateFetchMessageRecv;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.id.encode(stream);
        this.versionStr.encode(stream);
        this.messagesRead.encode(stream);
        this.messagesWritten.encode(stream);
        this.bytesRead.encode(stream);
        this.bytesWritten.encode(stream);
        this.secondsConnected.encode(stream);
        this.uniqueFloodBytesRecv.encode(stream);
        this.duplicateFloodBytesRecv.encode(stream);
        this.uniqueFetchBytesRecv.encode(stream);
        this.duplicateFetchBytesRecv.encode(stream);
        this.uniqueFloodMessageRecv.encode(stream);
        this.duplicateFloodMessageRecv.encode(stream);
        this.uniqueFetchMessageRecv.encode(stream);
        this.duplicateFetchMessageRecv.encode(stream);
    }

    public static PeerStats decode(XdrDataInputStream stream) throws IOException {
        PeerStats decodedPeerStats = new PeerStats();
        decodedPeerStats.id = NodeID.decode(stream);
        decodedPeerStats.versionStr = XdrString.decode(stream, 100);
        decodedPeerStats.messagesRead = Uint64.decode(stream);
        decodedPeerStats.messagesWritten = Uint64.decode(stream);
        decodedPeerStats.bytesRead = Uint64.decode(stream);
        decodedPeerStats.bytesWritten = Uint64.decode(stream);
        decodedPeerStats.secondsConnected = Uint64.decode(stream);
        decodedPeerStats.uniqueFloodBytesRecv = Uint64.decode(stream);
        decodedPeerStats.duplicateFloodBytesRecv = Uint64.decode(stream);
        decodedPeerStats.uniqueFetchBytesRecv = Uint64.decode(stream);
        decodedPeerStats.duplicateFetchBytesRecv = Uint64.decode(stream);
        decodedPeerStats.uniqueFloodMessageRecv = Uint64.decode(stream);
        decodedPeerStats.duplicateFloodMessageRecv = Uint64.decode(stream);
        decodedPeerStats.uniqueFetchMessageRecv = Uint64.decode(stream);
        decodedPeerStats.duplicateFetchMessageRecv = Uint64.decode(stream);
        return decodedPeerStats;
    }

    public static PeerStats fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PeerStats.fromXdrByteArray(bytes);
    }

    public static PeerStats fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PeerStats.decode(xdrDataInputStream);
    }

    @Generated
    public static PeerStatsBuilder builder() {
        return new PeerStatsBuilder();
    }

    @Generated
    public PeerStatsBuilder toBuilder() {
        return new PeerStatsBuilder().id(this.id).versionStr(this.versionStr).messagesRead(this.messagesRead).messagesWritten(this.messagesWritten).bytesRead(this.bytesRead).bytesWritten(this.bytesWritten).secondsConnected(this.secondsConnected).uniqueFloodBytesRecv(this.uniqueFloodBytesRecv).duplicateFloodBytesRecv(this.duplicateFloodBytesRecv).uniqueFetchBytesRecv(this.uniqueFetchBytesRecv).duplicateFetchBytesRecv(this.duplicateFetchBytesRecv).uniqueFloodMessageRecv(this.uniqueFloodMessageRecv).duplicateFloodMessageRecv(this.duplicateFloodMessageRecv).uniqueFetchMessageRecv(this.uniqueFetchMessageRecv).duplicateFetchMessageRecv(this.duplicateFetchMessageRecv);
    }

    @Generated
    public NodeID getId() {
        return this.id;
    }

    @Generated
    public XdrString getVersionStr() {
        return this.versionStr;
    }

    @Generated
    public Uint64 getMessagesRead() {
        return this.messagesRead;
    }

    @Generated
    public Uint64 getMessagesWritten() {
        return this.messagesWritten;
    }

    @Generated
    public Uint64 getBytesRead() {
        return this.bytesRead;
    }

    @Generated
    public Uint64 getBytesWritten() {
        return this.bytesWritten;
    }

    @Generated
    public Uint64 getSecondsConnected() {
        return this.secondsConnected;
    }

    @Generated
    public Uint64 getUniqueFloodBytesRecv() {
        return this.uniqueFloodBytesRecv;
    }

    @Generated
    public Uint64 getDuplicateFloodBytesRecv() {
        return this.duplicateFloodBytesRecv;
    }

    @Generated
    public Uint64 getUniqueFetchBytesRecv() {
        return this.uniqueFetchBytesRecv;
    }

    @Generated
    public Uint64 getDuplicateFetchBytesRecv() {
        return this.duplicateFetchBytesRecv;
    }

    @Generated
    public Uint64 getUniqueFloodMessageRecv() {
        return this.uniqueFloodMessageRecv;
    }

    @Generated
    public Uint64 getDuplicateFloodMessageRecv() {
        return this.duplicateFloodMessageRecv;
    }

    @Generated
    public Uint64 getUniqueFetchMessageRecv() {
        return this.uniqueFetchMessageRecv;
    }

    @Generated
    public Uint64 getDuplicateFetchMessageRecv() {
        return this.duplicateFetchMessageRecv;
    }

    @Generated
    public void setId(NodeID id) {
        this.id = id;
    }

    @Generated
    public void setVersionStr(XdrString versionStr) {
        this.versionStr = versionStr;
    }

    @Generated
    public void setMessagesRead(Uint64 messagesRead) {
        this.messagesRead = messagesRead;
    }

    @Generated
    public void setMessagesWritten(Uint64 messagesWritten) {
        this.messagesWritten = messagesWritten;
    }

    @Generated
    public void setBytesRead(Uint64 bytesRead) {
        this.bytesRead = bytesRead;
    }

    @Generated
    public void setBytesWritten(Uint64 bytesWritten) {
        this.bytesWritten = bytesWritten;
    }

    @Generated
    public void setSecondsConnected(Uint64 secondsConnected) {
        this.secondsConnected = secondsConnected;
    }

    @Generated
    public void setUniqueFloodBytesRecv(Uint64 uniqueFloodBytesRecv) {
        this.uniqueFloodBytesRecv = uniqueFloodBytesRecv;
    }

    @Generated
    public void setDuplicateFloodBytesRecv(Uint64 duplicateFloodBytesRecv) {
        this.duplicateFloodBytesRecv = duplicateFloodBytesRecv;
    }

    @Generated
    public void setUniqueFetchBytesRecv(Uint64 uniqueFetchBytesRecv) {
        this.uniqueFetchBytesRecv = uniqueFetchBytesRecv;
    }

    @Generated
    public void setDuplicateFetchBytesRecv(Uint64 duplicateFetchBytesRecv) {
        this.duplicateFetchBytesRecv = duplicateFetchBytesRecv;
    }

    @Generated
    public void setUniqueFloodMessageRecv(Uint64 uniqueFloodMessageRecv) {
        this.uniqueFloodMessageRecv = uniqueFloodMessageRecv;
    }

    @Generated
    public void setDuplicateFloodMessageRecv(Uint64 duplicateFloodMessageRecv) {
        this.duplicateFloodMessageRecv = duplicateFloodMessageRecv;
    }

    @Generated
    public void setUniqueFetchMessageRecv(Uint64 uniqueFetchMessageRecv) {
        this.uniqueFetchMessageRecv = uniqueFetchMessageRecv;
    }

    @Generated
    public void setDuplicateFetchMessageRecv(Uint64 duplicateFetchMessageRecv) {
        this.duplicateFetchMessageRecv = duplicateFetchMessageRecv;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PeerStats)) {
            return false;
        }
        PeerStats other = (PeerStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeID this$id = this.getId();
        NodeID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        XdrString this$versionStr = this.getVersionStr();
        XdrString other$versionStr = other.getVersionStr();
        if (this$versionStr == null ? other$versionStr != null : !((Object)this$versionStr).equals(other$versionStr)) {
            return false;
        }
        Uint64 this$messagesRead = this.getMessagesRead();
        Uint64 other$messagesRead = other.getMessagesRead();
        if (this$messagesRead == null ? other$messagesRead != null : !((Object)this$messagesRead).equals(other$messagesRead)) {
            return false;
        }
        Uint64 this$messagesWritten = this.getMessagesWritten();
        Uint64 other$messagesWritten = other.getMessagesWritten();
        if (this$messagesWritten == null ? other$messagesWritten != null : !((Object)this$messagesWritten).equals(other$messagesWritten)) {
            return false;
        }
        Uint64 this$bytesRead = this.getBytesRead();
        Uint64 other$bytesRead = other.getBytesRead();
        if (this$bytesRead == null ? other$bytesRead != null : !((Object)this$bytesRead).equals(other$bytesRead)) {
            return false;
        }
        Uint64 this$bytesWritten = this.getBytesWritten();
        Uint64 other$bytesWritten = other.getBytesWritten();
        if (this$bytesWritten == null ? other$bytesWritten != null : !((Object)this$bytesWritten).equals(other$bytesWritten)) {
            return false;
        }
        Uint64 this$secondsConnected = this.getSecondsConnected();
        Uint64 other$secondsConnected = other.getSecondsConnected();
        if (this$secondsConnected == null ? other$secondsConnected != null : !((Object)this$secondsConnected).equals(other$secondsConnected)) {
            return false;
        }
        Uint64 this$uniqueFloodBytesRecv = this.getUniqueFloodBytesRecv();
        Uint64 other$uniqueFloodBytesRecv = other.getUniqueFloodBytesRecv();
        if (this$uniqueFloodBytesRecv == null ? other$uniqueFloodBytesRecv != null : !((Object)this$uniqueFloodBytesRecv).equals(other$uniqueFloodBytesRecv)) {
            return false;
        }
        Uint64 this$duplicateFloodBytesRecv = this.getDuplicateFloodBytesRecv();
        Uint64 other$duplicateFloodBytesRecv = other.getDuplicateFloodBytesRecv();
        if (this$duplicateFloodBytesRecv == null ? other$duplicateFloodBytesRecv != null : !((Object)this$duplicateFloodBytesRecv).equals(other$duplicateFloodBytesRecv)) {
            return false;
        }
        Uint64 this$uniqueFetchBytesRecv = this.getUniqueFetchBytesRecv();
        Uint64 other$uniqueFetchBytesRecv = other.getUniqueFetchBytesRecv();
        if (this$uniqueFetchBytesRecv == null ? other$uniqueFetchBytesRecv != null : !((Object)this$uniqueFetchBytesRecv).equals(other$uniqueFetchBytesRecv)) {
            return false;
        }
        Uint64 this$duplicateFetchBytesRecv = this.getDuplicateFetchBytesRecv();
        Uint64 other$duplicateFetchBytesRecv = other.getDuplicateFetchBytesRecv();
        if (this$duplicateFetchBytesRecv == null ? other$duplicateFetchBytesRecv != null : !((Object)this$duplicateFetchBytesRecv).equals(other$duplicateFetchBytesRecv)) {
            return false;
        }
        Uint64 this$uniqueFloodMessageRecv = this.getUniqueFloodMessageRecv();
        Uint64 other$uniqueFloodMessageRecv = other.getUniqueFloodMessageRecv();
        if (this$uniqueFloodMessageRecv == null ? other$uniqueFloodMessageRecv != null : !((Object)this$uniqueFloodMessageRecv).equals(other$uniqueFloodMessageRecv)) {
            return false;
        }
        Uint64 this$duplicateFloodMessageRecv = this.getDuplicateFloodMessageRecv();
        Uint64 other$duplicateFloodMessageRecv = other.getDuplicateFloodMessageRecv();
        if (this$duplicateFloodMessageRecv == null ? other$duplicateFloodMessageRecv != null : !((Object)this$duplicateFloodMessageRecv).equals(other$duplicateFloodMessageRecv)) {
            return false;
        }
        Uint64 this$uniqueFetchMessageRecv = this.getUniqueFetchMessageRecv();
        Uint64 other$uniqueFetchMessageRecv = other.getUniqueFetchMessageRecv();
        if (this$uniqueFetchMessageRecv == null ? other$uniqueFetchMessageRecv != null : !((Object)this$uniqueFetchMessageRecv).equals(other$uniqueFetchMessageRecv)) {
            return false;
        }
        Uint64 this$duplicateFetchMessageRecv = this.getDuplicateFetchMessageRecv();
        Uint64 other$duplicateFetchMessageRecv = other.getDuplicateFetchMessageRecv();
        return !(this$duplicateFetchMessageRecv == null ? other$duplicateFetchMessageRecv != null : !((Object)this$duplicateFetchMessageRecv).equals(other$duplicateFetchMessageRecv));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PeerStats;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        XdrString $versionStr = this.getVersionStr();
        result = result * 59 + ($versionStr == null ? 43 : ((Object)$versionStr).hashCode());
        Uint64 $messagesRead = this.getMessagesRead();
        result = result * 59 + ($messagesRead == null ? 43 : ((Object)$messagesRead).hashCode());
        Uint64 $messagesWritten = this.getMessagesWritten();
        result = result * 59 + ($messagesWritten == null ? 43 : ((Object)$messagesWritten).hashCode());
        Uint64 $bytesRead = this.getBytesRead();
        result = result * 59 + ($bytesRead == null ? 43 : ((Object)$bytesRead).hashCode());
        Uint64 $bytesWritten = this.getBytesWritten();
        result = result * 59 + ($bytesWritten == null ? 43 : ((Object)$bytesWritten).hashCode());
        Uint64 $secondsConnected = this.getSecondsConnected();
        result = result * 59 + ($secondsConnected == null ? 43 : ((Object)$secondsConnected).hashCode());
        Uint64 $uniqueFloodBytesRecv = this.getUniqueFloodBytesRecv();
        result = result * 59 + ($uniqueFloodBytesRecv == null ? 43 : ((Object)$uniqueFloodBytesRecv).hashCode());
        Uint64 $duplicateFloodBytesRecv = this.getDuplicateFloodBytesRecv();
        result = result * 59 + ($duplicateFloodBytesRecv == null ? 43 : ((Object)$duplicateFloodBytesRecv).hashCode());
        Uint64 $uniqueFetchBytesRecv = this.getUniqueFetchBytesRecv();
        result = result * 59 + ($uniqueFetchBytesRecv == null ? 43 : ((Object)$uniqueFetchBytesRecv).hashCode());
        Uint64 $duplicateFetchBytesRecv = this.getDuplicateFetchBytesRecv();
        result = result * 59 + ($duplicateFetchBytesRecv == null ? 43 : ((Object)$duplicateFetchBytesRecv).hashCode());
        Uint64 $uniqueFloodMessageRecv = this.getUniqueFloodMessageRecv();
        result = result * 59 + ($uniqueFloodMessageRecv == null ? 43 : ((Object)$uniqueFloodMessageRecv).hashCode());
        Uint64 $duplicateFloodMessageRecv = this.getDuplicateFloodMessageRecv();
        result = result * 59 + ($duplicateFloodMessageRecv == null ? 43 : ((Object)$duplicateFloodMessageRecv).hashCode());
        Uint64 $uniqueFetchMessageRecv = this.getUniqueFetchMessageRecv();
        result = result * 59 + ($uniqueFetchMessageRecv == null ? 43 : ((Object)$uniqueFetchMessageRecv).hashCode());
        Uint64 $duplicateFetchMessageRecv = this.getDuplicateFetchMessageRecv();
        result = result * 59 + ($duplicateFetchMessageRecv == null ? 43 : ((Object)$duplicateFetchMessageRecv).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PeerStats(id=" + this.getId() + ", versionStr=" + this.getVersionStr() + ", messagesRead=" + this.getMessagesRead() + ", messagesWritten=" + this.getMessagesWritten() + ", bytesRead=" + this.getBytesRead() + ", bytesWritten=" + this.getBytesWritten() + ", secondsConnected=" + this.getSecondsConnected() + ", uniqueFloodBytesRecv=" + this.getUniqueFloodBytesRecv() + ", duplicateFloodBytesRecv=" + this.getDuplicateFloodBytesRecv() + ", uniqueFetchBytesRecv=" + this.getUniqueFetchBytesRecv() + ", duplicateFetchBytesRecv=" + this.getDuplicateFetchBytesRecv() + ", uniqueFloodMessageRecv=" + this.getUniqueFloodMessageRecv() + ", duplicateFloodMessageRecv=" + this.getDuplicateFloodMessageRecv() + ", uniqueFetchMessageRecv=" + this.getUniqueFetchMessageRecv() + ", duplicateFetchMessageRecv=" + this.getDuplicateFetchMessageRecv() + ")";
    }

    @Generated
    public PeerStats() {
    }

    @Generated
    public PeerStats(NodeID id, XdrString versionStr, Uint64 messagesRead, Uint64 messagesWritten, Uint64 bytesRead, Uint64 bytesWritten, Uint64 secondsConnected, Uint64 uniqueFloodBytesRecv, Uint64 duplicateFloodBytesRecv, Uint64 uniqueFetchBytesRecv, Uint64 duplicateFetchBytesRecv, Uint64 uniqueFloodMessageRecv, Uint64 duplicateFloodMessageRecv, Uint64 uniqueFetchMessageRecv, Uint64 duplicateFetchMessageRecv) {
        this.id = id;
        this.versionStr = versionStr;
        this.messagesRead = messagesRead;
        this.messagesWritten = messagesWritten;
        this.bytesRead = bytesRead;
        this.bytesWritten = bytesWritten;
        this.secondsConnected = secondsConnected;
        this.uniqueFloodBytesRecv = uniqueFloodBytesRecv;
        this.duplicateFloodBytesRecv = duplicateFloodBytesRecv;
        this.uniqueFetchBytesRecv = uniqueFetchBytesRecv;
        this.duplicateFetchBytesRecv = duplicateFetchBytesRecv;
        this.uniqueFloodMessageRecv = uniqueFloodMessageRecv;
        this.duplicateFloodMessageRecv = duplicateFloodMessageRecv;
        this.uniqueFetchMessageRecv = uniqueFetchMessageRecv;
        this.duplicateFetchMessageRecv = duplicateFetchMessageRecv;
    }

    @Generated
    public static class PeerStatsBuilder {
        @Generated
        private NodeID id;
        @Generated
        private XdrString versionStr;
        @Generated
        private Uint64 messagesRead;
        @Generated
        private Uint64 messagesWritten;
        @Generated
        private Uint64 bytesRead;
        @Generated
        private Uint64 bytesWritten;
        @Generated
        private Uint64 secondsConnected;
        @Generated
        private Uint64 uniqueFloodBytesRecv;
        @Generated
        private Uint64 duplicateFloodBytesRecv;
        @Generated
        private Uint64 uniqueFetchBytesRecv;
        @Generated
        private Uint64 duplicateFetchBytesRecv;
        @Generated
        private Uint64 uniqueFloodMessageRecv;
        @Generated
        private Uint64 duplicateFloodMessageRecv;
        @Generated
        private Uint64 uniqueFetchMessageRecv;
        @Generated
        private Uint64 duplicateFetchMessageRecv;

        @Generated
        PeerStatsBuilder() {
        }

        @Generated
        public PeerStatsBuilder id(NodeID id) {
            this.id = id;
            return this;
        }

        @Generated
        public PeerStatsBuilder versionStr(XdrString versionStr) {
            this.versionStr = versionStr;
            return this;
        }

        @Generated
        public PeerStatsBuilder messagesRead(Uint64 messagesRead) {
            this.messagesRead = messagesRead;
            return this;
        }

        @Generated
        public PeerStatsBuilder messagesWritten(Uint64 messagesWritten) {
            this.messagesWritten = messagesWritten;
            return this;
        }

        @Generated
        public PeerStatsBuilder bytesRead(Uint64 bytesRead) {
            this.bytesRead = bytesRead;
            return this;
        }

        @Generated
        public PeerStatsBuilder bytesWritten(Uint64 bytesWritten) {
            this.bytesWritten = bytesWritten;
            return this;
        }

        @Generated
        public PeerStatsBuilder secondsConnected(Uint64 secondsConnected) {
            this.secondsConnected = secondsConnected;
            return this;
        }

        @Generated
        public PeerStatsBuilder uniqueFloodBytesRecv(Uint64 uniqueFloodBytesRecv) {
            this.uniqueFloodBytesRecv = uniqueFloodBytesRecv;
            return this;
        }

        @Generated
        public PeerStatsBuilder duplicateFloodBytesRecv(Uint64 duplicateFloodBytesRecv) {
            this.duplicateFloodBytesRecv = duplicateFloodBytesRecv;
            return this;
        }

        @Generated
        public PeerStatsBuilder uniqueFetchBytesRecv(Uint64 uniqueFetchBytesRecv) {
            this.uniqueFetchBytesRecv = uniqueFetchBytesRecv;
            return this;
        }

        @Generated
        public PeerStatsBuilder duplicateFetchBytesRecv(Uint64 duplicateFetchBytesRecv) {
            this.duplicateFetchBytesRecv = duplicateFetchBytesRecv;
            return this;
        }

        @Generated
        public PeerStatsBuilder uniqueFloodMessageRecv(Uint64 uniqueFloodMessageRecv) {
            this.uniqueFloodMessageRecv = uniqueFloodMessageRecv;
            return this;
        }

        @Generated
        public PeerStatsBuilder duplicateFloodMessageRecv(Uint64 duplicateFloodMessageRecv) {
            this.duplicateFloodMessageRecv = duplicateFloodMessageRecv;
            return this;
        }

        @Generated
        public PeerStatsBuilder uniqueFetchMessageRecv(Uint64 uniqueFetchMessageRecv) {
            this.uniqueFetchMessageRecv = uniqueFetchMessageRecv;
            return this;
        }

        @Generated
        public PeerStatsBuilder duplicateFetchMessageRecv(Uint64 duplicateFetchMessageRecv) {
            this.duplicateFetchMessageRecv = duplicateFetchMessageRecv;
            return this;
        }

        @Generated
        public PeerStats build() {
            return new PeerStats(this.id, this.versionStr, this.messagesRead, this.messagesWritten, this.bytesRead, this.bytesWritten, this.secondsConnected, this.uniqueFloodBytesRecv, this.duplicateFloodBytesRecv, this.uniqueFetchBytesRecv, this.duplicateFetchBytesRecv, this.uniqueFloodMessageRecv, this.duplicateFloodMessageRecv, this.uniqueFetchMessageRecv, this.duplicateFetchMessageRecv);
        }

        @Generated
        public String toString() {
            return "PeerStats.PeerStatsBuilder(id=" + this.id + ", versionStr=" + this.versionStr + ", messagesRead=" + this.messagesRead + ", messagesWritten=" + this.messagesWritten + ", bytesRead=" + this.bytesRead + ", bytesWritten=" + this.bytesWritten + ", secondsConnected=" + this.secondsConnected + ", uniqueFloodBytesRecv=" + this.uniqueFloodBytesRecv + ", duplicateFloodBytesRecv=" + this.duplicateFloodBytesRecv + ", uniqueFetchBytesRecv=" + this.uniqueFetchBytesRecv + ", duplicateFetchBytesRecv=" + this.duplicateFetchBytesRecv + ", uniqueFloodMessageRecv=" + this.uniqueFloodMessageRecv + ", duplicateFloodMessageRecv=" + this.duplicateFloodMessageRecv + ", uniqueFetchMessageRecv=" + this.uniqueFetchMessageRecv + ", duplicateFetchMessageRecv=" + this.duplicateFetchMessageRecv + ")";
        }
    }
}

