/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SignerKeyType;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SignerKey
implements XdrElement {
    private SignerKeyType discriminant;
    private Uint256 ed25519;
    private Uint256 preAuthTx;
    private Uint256 hashX;
    private SignerKeyEd25519SignedPayload ed25519SignedPayload;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case SIGNER_KEY_TYPE_ED25519: {
                this.ed25519.encode(stream);
                break;
            }
            case SIGNER_KEY_TYPE_PRE_AUTH_TX: {
                this.preAuthTx.encode(stream);
                break;
            }
            case SIGNER_KEY_TYPE_HASH_X: {
                this.hashX.encode(stream);
                break;
            }
            case SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD: {
                this.ed25519SignedPayload.encode(stream);
            }
        }
    }

    public static SignerKey decode(XdrDataInputStream stream) throws IOException {
        SignerKey decodedSignerKey = new SignerKey();
        SignerKeyType discriminant = SignerKeyType.decode(stream);
        decodedSignerKey.setDiscriminant(discriminant);
        switch (decodedSignerKey.getDiscriminant()) {
            case SIGNER_KEY_TYPE_ED25519: {
                decodedSignerKey.ed25519 = Uint256.decode(stream);
                break;
            }
            case SIGNER_KEY_TYPE_PRE_AUTH_TX: {
                decodedSignerKey.preAuthTx = Uint256.decode(stream);
                break;
            }
            case SIGNER_KEY_TYPE_HASH_X: {
                decodedSignerKey.hashX = Uint256.decode(stream);
                break;
            }
            case SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD: {
                decodedSignerKey.ed25519SignedPayload = SignerKeyEd25519SignedPayload.decode(stream);
            }
        }
        return decodedSignerKey;
    }

    public static SignerKey fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SignerKey.fromXdrByteArray(bytes);
    }

    public static SignerKey fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SignerKey.decode(xdrDataInputStream);
    }

    @Generated
    public static SignerKeyBuilder builder() {
        return new SignerKeyBuilder();
    }

    @Generated
    public SignerKeyBuilder toBuilder() {
        return new SignerKeyBuilder().discriminant(this.discriminant).ed25519(this.ed25519).preAuthTx(this.preAuthTx).hashX(this.hashX).ed25519SignedPayload(this.ed25519SignedPayload);
    }

    @Generated
    public SignerKeyType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public Uint256 getEd25519() {
        return this.ed25519;
    }

    @Generated
    public Uint256 getPreAuthTx() {
        return this.preAuthTx;
    }

    @Generated
    public Uint256 getHashX() {
        return this.hashX;
    }

    @Generated
    public SignerKeyEd25519SignedPayload getEd25519SignedPayload() {
        return this.ed25519SignedPayload;
    }

    @Generated
    public void setDiscriminant(SignerKeyType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setEd25519(Uint256 ed25519) {
        this.ed25519 = ed25519;
    }

    @Generated
    public void setPreAuthTx(Uint256 preAuthTx) {
        this.preAuthTx = preAuthTx;
    }

    @Generated
    public void setHashX(Uint256 hashX) {
        this.hashX = hashX;
    }

    @Generated
    public void setEd25519SignedPayload(SignerKeyEd25519SignedPayload ed25519SignedPayload) {
        this.ed25519SignedPayload = ed25519SignedPayload;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignerKey)) {
            return false;
        }
        SignerKey other = (SignerKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SignerKeyType this$discriminant = this.getDiscriminant();
        SignerKeyType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        Uint256 this$ed25519 = this.getEd25519();
        Uint256 other$ed25519 = other.getEd25519();
        if (this$ed25519 == null ? other$ed25519 != null : !((Object)this$ed25519).equals(other$ed25519)) {
            return false;
        }
        Uint256 this$preAuthTx = this.getPreAuthTx();
        Uint256 other$preAuthTx = other.getPreAuthTx();
        if (this$preAuthTx == null ? other$preAuthTx != null : !((Object)this$preAuthTx).equals(other$preAuthTx)) {
            return false;
        }
        Uint256 this$hashX = this.getHashX();
        Uint256 other$hashX = other.getHashX();
        if (this$hashX == null ? other$hashX != null : !((Object)this$hashX).equals(other$hashX)) {
            return false;
        }
        SignerKeyEd25519SignedPayload this$ed25519SignedPayload = this.getEd25519SignedPayload();
        SignerKeyEd25519SignedPayload other$ed25519SignedPayload = other.getEd25519SignedPayload();
        return !(this$ed25519SignedPayload == null ? other$ed25519SignedPayload != null : !((Object)this$ed25519SignedPayload).equals(other$ed25519SignedPayload));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SignerKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SignerKeyType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        Uint256 $ed25519 = this.getEd25519();
        result = result * 59 + ($ed25519 == null ? 43 : ((Object)$ed25519).hashCode());
        Uint256 $preAuthTx = this.getPreAuthTx();
        result = result * 59 + ($preAuthTx == null ? 43 : ((Object)$preAuthTx).hashCode());
        Uint256 $hashX = this.getHashX();
        result = result * 59 + ($hashX == null ? 43 : ((Object)$hashX).hashCode());
        SignerKeyEd25519SignedPayload $ed25519SignedPayload = this.getEd25519SignedPayload();
        result = result * 59 + ($ed25519SignedPayload == null ? 43 : ((Object)$ed25519SignedPayload).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SignerKey(discriminant=" + this.getDiscriminant() + ", ed25519=" + this.getEd25519() + ", preAuthTx=" + this.getPreAuthTx() + ", hashX=" + this.getHashX() + ", ed25519SignedPayload=" + this.getEd25519SignedPayload() + ")";
    }

    @Generated
    public SignerKey() {
    }

    @Generated
    public SignerKey(SignerKeyType discriminant, Uint256 ed25519, Uint256 preAuthTx, Uint256 hashX, SignerKeyEd25519SignedPayload ed25519SignedPayload) {
        this.discriminant = discriminant;
        this.ed25519 = ed25519;
        this.preAuthTx = preAuthTx;
        this.hashX = hashX;
        this.ed25519SignedPayload = ed25519SignedPayload;
    }

    public static class SignerKeyEd25519SignedPayload
    implements XdrElement {
        private Uint256 ed25519;
        private byte[] payload;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.ed25519.encode(stream);
            int payloadSize = this.payload.length;
            stream.writeInt(payloadSize);
            stream.write(this.getPayload(), 0, payloadSize);
        }

        public static SignerKeyEd25519SignedPayload decode(XdrDataInputStream stream) throws IOException {
            SignerKeyEd25519SignedPayload decodedSignerKeyEd25519SignedPayload = new SignerKeyEd25519SignedPayload();
            decodedSignerKeyEd25519SignedPayload.ed25519 = Uint256.decode(stream);
            int payloadSize = stream.readInt();
            decodedSignerKeyEd25519SignedPayload.payload = new byte[payloadSize];
            stream.read(decodedSignerKeyEd25519SignedPayload.payload, 0, payloadSize);
            return decodedSignerKeyEd25519SignedPayload;
        }

        public static SignerKeyEd25519SignedPayload fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return SignerKeyEd25519SignedPayload.fromXdrByteArray(bytes);
        }

        public static SignerKeyEd25519SignedPayload fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return SignerKeyEd25519SignedPayload.decode(xdrDataInputStream);
        }

        @Generated
        public static SignerKeyEd25519SignedPayloadBuilder builder() {
            return new SignerKeyEd25519SignedPayloadBuilder();
        }

        @Generated
        public SignerKeyEd25519SignedPayloadBuilder toBuilder() {
            return new SignerKeyEd25519SignedPayloadBuilder().ed25519(this.ed25519).payload(this.payload);
        }

        @Generated
        public Uint256 getEd25519() {
            return this.ed25519;
        }

        @Generated
        public byte[] getPayload() {
            return this.payload;
        }

        @Generated
        public void setEd25519(Uint256 ed25519) {
            this.ed25519 = ed25519;
        }

        @Generated
        public void setPayload(byte[] payload) {
            this.payload = payload;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SignerKeyEd25519SignedPayload)) {
                return false;
            }
            SignerKeyEd25519SignedPayload other = (SignerKeyEd25519SignedPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Uint256 this$ed25519 = this.getEd25519();
            Uint256 other$ed25519 = other.getEd25519();
            if (this$ed25519 == null ? other$ed25519 != null : !((Object)this$ed25519).equals(other$ed25519)) {
                return false;
            }
            return Arrays.equals(this.getPayload(), other.getPayload());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SignerKeyEd25519SignedPayload;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Uint256 $ed25519 = this.getEd25519();
            result = result * 59 + ($ed25519 == null ? 43 : ((Object)$ed25519).hashCode());
            result = result * 59 + Arrays.hashCode(this.getPayload());
            return result;
        }

        @Generated
        public String toString() {
            return "SignerKey.SignerKeyEd25519SignedPayload(ed25519=" + this.getEd25519() + ", payload=" + Arrays.toString(this.getPayload()) + ")";
        }

        @Generated
        public SignerKeyEd25519SignedPayload() {
        }

        @Generated
        public SignerKeyEd25519SignedPayload(Uint256 ed25519, byte[] payload) {
            this.ed25519 = ed25519;
            this.payload = payload;
        }

        @Generated
        public static class SignerKeyEd25519SignedPayloadBuilder {
            @Generated
            private Uint256 ed25519;
            @Generated
            private byte[] payload;

            @Generated
            SignerKeyEd25519SignedPayloadBuilder() {
            }

            @Generated
            public SignerKeyEd25519SignedPayloadBuilder ed25519(Uint256 ed25519) {
                this.ed25519 = ed25519;
                return this;
            }

            @Generated
            public SignerKeyEd25519SignedPayloadBuilder payload(byte[] payload) {
                this.payload = payload;
                return this;
            }

            @Generated
            public SignerKeyEd25519SignedPayload build() {
                return new SignerKeyEd25519SignedPayload(this.ed25519, this.payload);
            }

            @Generated
            public String toString() {
                return "SignerKey.SignerKeyEd25519SignedPayload.SignerKeyEd25519SignedPayloadBuilder(ed25519=" + this.ed25519 + ", payload=" + Arrays.toString(this.payload) + ")";
            }
        }
    }

    @Generated
    public static class SignerKeyBuilder {
        @Generated
        private SignerKeyType discriminant;
        @Generated
        private Uint256 ed25519;
        @Generated
        private Uint256 preAuthTx;
        @Generated
        private Uint256 hashX;
        @Generated
        private SignerKeyEd25519SignedPayload ed25519SignedPayload;

        @Generated
        SignerKeyBuilder() {
        }

        @Generated
        public SignerKeyBuilder discriminant(SignerKeyType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public SignerKeyBuilder ed25519(Uint256 ed25519) {
            this.ed25519 = ed25519;
            return this;
        }

        @Generated
        public SignerKeyBuilder preAuthTx(Uint256 preAuthTx) {
            this.preAuthTx = preAuthTx;
            return this;
        }

        @Generated
        public SignerKeyBuilder hashX(Uint256 hashX) {
            this.hashX = hashX;
            return this;
        }

        @Generated
        public SignerKeyBuilder ed25519SignedPayload(SignerKeyEd25519SignedPayload ed25519SignedPayload) {
            this.ed25519SignedPayload = ed25519SignedPayload;
            return this;
        }

        @Generated
        public SignerKey build() {
            return new SignerKey(this.discriminant, this.ed25519, this.preAuthTx, this.hashX, this.ed25519SignedPayload);
        }

        @Generated
        public String toString() {
            return "SignerKey.SignerKeyBuilder(discriminant=" + this.discriminant + ", ed25519=" + this.ed25519 + ", preAuthTx=" + this.preAuthTx + ", hashX=" + this.hashX + ", ed25519SignedPayload=" + this.ed25519SignedPayload + ")";
        }
    }
}

