/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SorobanAddressCredentials;
import org.stellar.sdk.xdr.SorobanCredentialsType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SorobanCredentials
implements XdrElement {
    private SorobanCredentialsType discriminant;
    private SorobanAddressCredentials address;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case SOROBAN_CREDENTIALS_SOURCE_ACCOUNT: {
                break;
            }
            case SOROBAN_CREDENTIALS_ADDRESS: {
                this.address.encode(stream);
            }
        }
    }

    public static SorobanCredentials decode(XdrDataInputStream stream) throws IOException {
        SorobanCredentials decodedSorobanCredentials = new SorobanCredentials();
        SorobanCredentialsType discriminant = SorobanCredentialsType.decode(stream);
        decodedSorobanCredentials.setDiscriminant(discriminant);
        switch (decodedSorobanCredentials.getDiscriminant()) {
            case SOROBAN_CREDENTIALS_SOURCE_ACCOUNT: {
                break;
            }
            case SOROBAN_CREDENTIALS_ADDRESS: {
                decodedSorobanCredentials.address = SorobanAddressCredentials.decode(stream);
            }
        }
        return decodedSorobanCredentials;
    }

    public static SorobanCredentials fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SorobanCredentials.fromXdrByteArray(bytes);
    }

    public static SorobanCredentials fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SorobanCredentials.decode(xdrDataInputStream);
    }

    @Generated
    public static SorobanCredentialsBuilder builder() {
        return new SorobanCredentialsBuilder();
    }

    @Generated
    public SorobanCredentialsBuilder toBuilder() {
        return new SorobanCredentialsBuilder().discriminant(this.discriminant).address(this.address);
    }

    @Generated
    public SorobanCredentialsType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public SorobanAddressCredentials getAddress() {
        return this.address;
    }

    @Generated
    public void setDiscriminant(SorobanCredentialsType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setAddress(SorobanAddressCredentials address) {
        this.address = address;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SorobanCredentials)) {
            return false;
        }
        SorobanCredentials other = (SorobanCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SorobanCredentialsType this$discriminant = this.getDiscriminant();
        SorobanCredentialsType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        SorobanAddressCredentials this$address = this.getAddress();
        SorobanAddressCredentials other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !((Object)this$address).equals(other$address));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SorobanCredentials;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SorobanCredentialsType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        SorobanAddressCredentials $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SorobanCredentials(discriminant=" + this.getDiscriminant() + ", address=" + this.getAddress() + ")";
    }

    @Generated
    public SorobanCredentials() {
    }

    @Generated
    public SorobanCredentials(SorobanCredentialsType discriminant, SorobanAddressCredentials address) {
        this.discriminant = discriminant;
        this.address = address;
    }

    @Generated
    public static class SorobanCredentialsBuilder {
        @Generated
        private SorobanCredentialsType discriminant;
        @Generated
        private SorobanAddressCredentials address;

        @Generated
        SorobanCredentialsBuilder() {
        }

        @Generated
        public SorobanCredentialsBuilder discriminant(SorobanCredentialsType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public SorobanCredentialsBuilder address(SorobanAddressCredentials address) {
            this.address = address;
            return this;
        }

        @Generated
        public SorobanCredentials build() {
            return new SorobanCredentials(this.discriminant, this.address);
        }

        @Generated
        public String toString() {
            return "SorobanCredentials.SorobanCredentialsBuilder(discriminant=" + this.discriminant + ", address=" + this.address + ")";
        }
    }
}

